/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture;

import com.teamscale.index.architecture.commons.EStereotype;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class ArchitectureComponentInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String name;
    public final Point position;
    public final Dimension dimension;
    private final TreeMap<String, String> matchedTypes = new TreeMap();
    public final @Nullable EStereotype stereotype;
    private final List<ArchitectureComponentInfo> subComponents = new ArrayList<ArchitectureComponentInfo>();
    private final List<String> overlapWarnings;
    private final List<String> redundantIncludePatterns;
    private final List<Integer> numberOfMatches;

    protected ArchitectureComponentInfo(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.position = new Point(Objects.requireNonNull(builder.position, "position"));
        this.dimension = new Dimension(Objects.requireNonNull(builder.dimension, "dimension"));
        this.matchedTypes.putAll(builder.matchedTypes);
        this.stereotype = builder.stereotype;
        this.subComponents.addAll(builder.subComponents);
        this.overlapWarnings = new ArrayList<String>(builder.overlapWarnings);
        this.redundantIncludePatterns = new ArrayList<String>(builder.redundantIncludePatterns);
        this.numberOfMatches = new ArrayList<Integer>(builder.numberOfMatches);
    }

    public UnmodifiableList<String> getOverlapWarnings() {
        return CollectionUtils.asUnmodifiable(this.overlapWarnings);
    }

    public UnmodifiableList<ArchitectureComponentInfo> getSubComponents() {
        return CollectionUtils.asUnmodifiable(this.subComponents);
    }

    public List<ArchitectureComponentInfo> getSubComponentsRecursively() {
        ArrayList<ArchitectureComponentInfo> allComponents = new ArrayList<ArchitectureComponentInfo>(this.subComponents);
        for (ArchitectureComponentInfo subBlock : this.subComponents) {
            allComponents.addAll(subBlock.getSubComponentsRecursively());
        }
        return allComponents;
    }

    public UnmodifiableMap<String, String> getMatchedTypes() {
        return CollectionUtils.asUnmodifiable(this.matchedTypes);
    }

    public UnmodifiableList<Integer> getNumberOfMatches() {
        return CollectionUtils.asUnmodifiable(this.numberOfMatches);
    }

    public UnmodifiableList<String> getRedundantIncludePatterns() {
        return CollectionUtils.asUnmodifiable(this.redundantIncludePatterns);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchitectureComponentInfo that = (ArchitectureComponentInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.position, that.position) && Objects.equals(this.dimension, that.dimension) && Objects.equals(this.matchedTypes, that.matchedTypes) && this.stereotype == that.stereotype && Objects.equals(this.subComponents, that.subComponents) && Objects.equals(this.overlapWarnings, that.overlapWarnings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.position, this.dimension, this.matchedTypes, this.stereotype, this.subComponents, this.overlapWarnings});
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String name;
        private Point position;
        private Dimension dimension;
        private TreeMap<String, String> matchedTypes = new TreeMap();
        private EStereotype stereotype;
        private List<ArchitectureComponentInfo> subComponents = new ArrayList<ArchitectureComponentInfo>();
        private List<String> overlapWarnings = new ArrayList<String>();
        private List<String> redundantIncludePatterns = new ArrayList<String>();
        private List<Integer> numberOfMatches = new ArrayList<Integer>();

        protected Builder() {
        }

        protected Builder(ArchitectureComponentInfo architectureComponentInfo) {
            this.name = architectureComponentInfo.name;
            this.position = architectureComponentInfo.position;
            this.dimension = architectureComponentInfo.dimension;
            this.matchedTypes = new TreeMap<String, String>((SortedMap<String, String>)architectureComponentInfo.matchedTypes);
            this.stereotype = architectureComponentInfo.stereotype;
            this.subComponents = new ArrayList<ArchitectureComponentInfo>(architectureComponentInfo.subComponents);
            this.overlapWarnings = new ArrayList<String>(architectureComponentInfo.overlapWarnings);
            this.redundantIncludePatterns = new ArrayList<String>(architectureComponentInfo.redundantIncludePatterns);
            this.numberOfMatches = new ArrayList<Integer>(architectureComponentInfo.numberOfMatches);
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withPosition(Point position) {
            this.position = new Point(position);
            return this;
        }

        public Builder withDimension(Dimension dimension) {
            this.dimension = new Dimension(dimension);
            return this;
        }

        public Builder withMatchedTypes(Map<String, String> matchedTypes) {
            this.matchedTypes.putAll(matchedTypes);
            return this;
        }

        public Builder withMatchedType(String key, String value) {
            this.matchedTypes.put(key, value);
            return this;
        }

        public Builder withStereotype(EStereotype stereotype) {
            this.stereotype = stereotype;
            return this;
        }

        public Builder withSubComponents(Collection<ArchitectureComponentInfo> subComponents) {
            this.subComponents.addAll(subComponents);
            return this;
        }

        public Builder withSubComponent(ArchitectureComponentInfo subComponent) {
            this.subComponents.add(subComponent);
            return this;
        }

        public Builder withOverlapWarnings(Collection<String> overlapWarnings) {
            this.overlapWarnings.addAll(overlapWarnings);
            return this;
        }

        public Builder withOverlapWarning(String overlapWarning) {
            this.overlapWarnings.add(overlapWarning);
            return this;
        }

        public Builder withRedundantIncludePatterns(Collection<String> redundantIncludePatterns) {
            this.redundantIncludePatterns.addAll(redundantIncludePatterns);
            return this;
        }

        public Builder withRedundantIncludePattern(String redundantIncludePattern) {
            this.redundantIncludePatterns.add(redundantIncludePattern);
            return this;
        }

        public Builder withNumberOfMatches(Collection<Integer> numberOfMatches) {
            this.numberOfMatches.addAll(numberOfMatches);
            return this;
        }

        public Builder withNumberOfMatches(int numberOfMatches) {
            this.numberOfMatches.add(numberOfMatches);
            return this;
        }

        public ArchitectureComponentInfo build() {
            return new ArchitectureComponentInfo(this);
        }
    }
}

