/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.assessment;

import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.index.architecture.assessment.QuickCheckPattern;
import com.teamscale.index.architecture.assessment.shared.CodeMapping;
import com.teamscale.index.architecture.format.ECodeMappingType;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ComponentNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class TypeToComponentMapper {
    private final ArchitectureDefinition architecture;
    private final IParallelTaskExecutor parallelTaskExecutor;
    private final List<String> unmatchedTypes = new ArrayList<String>();
    private final ListMap<String, String> componentOverlapWarnings = new ListMap();
    private final ListMap<String, String> redundantIncludePatterns = new ListMap();
    private final ListMap<String, Integer> numberOfMatches = new ListMap();
    private final SetMap<String, ComponentNode> typesToComponents = new SetMap();
    private final SetMap<ComponentNode, String> componentsToTypes = new SetMap();
    private final SetMap<String, String> includePatternsToTypes = new SetMap();
    private final SetMap<String, String> excludePatternsToTypes = new SetMap();
    private final ListMap<ComponentNode, QuickCheckPattern> quickCheckIncludePatternsByComponent = new ListMap();
    private final ConcurrentMap<String, Pattern> compiledPatterns = new ConcurrentHashMap<String, Pattern>();
    private static final Logger LOGGER = LogManager.getLogger();

    public TypeToComponentMapper(ArchitectureDefinition architecture, IParallelTaskExecutor parallelTaskExecutor) {
        this.architecture = architecture;
        this.parallelTaskExecutor = parallelTaskExecutor;
    }

    public void map(Collection<String> types) {
        this.componentsToTypes.clear();
        this.typesToComponents.clear();
        this.unmatchedTypes.clear();
        this.numberOfMatches.clear();
        this.mapTypes(types);
        if (!this.architecture.isStructureOnly()) {
            this.checkForRedundantIncludePatterns();
        }
        this.setNumberOfMatches();
    }

    private void setNumberOfMatches() {
        Set<ComponentNode> components = this.architecture.getAllComponents();
        for (ComponentNode component : components) {
            this.setNumberOfMatchesForComponent(components, component);
        }
    }

    private void setNumberOfMatchesForComponent(Set<ComponentNode> components, ComponentNode component) {
        for (CodeMapping mapping : component.getCodeMappings()) {
            Optional<ComponentNode> node;
            int numberMatches = 0;
            if (mapping.getType() == ECodeMappingType.INCLUDE) {
                numberMatches = ((Set)this.includePatternsToTypes.getCollectionOrEmpty((Object)mapping.getPattern())).size();
            } else if (mapping.getType() == ECodeMappingType.EXCLUDE) {
                numberMatches = ((Set)this.excludePatternsToTypes.getCollectionOrEmpty((Object)mapping.getPattern())).size();
            } else if (mapping.getType() == ECodeMappingType.EXCLUDE_COMPONENT && (node = components.stream().filter(comp -> comp.getName().equals(mapping.getPattern())).findAny()).isPresent()) {
                numberMatches = ((Set)this.componentsToTypes.getCollectionOrEmpty((Object)node.get())).size();
            }
            this.numberOfMatches.add((Object)component.getName(), (Object)numberMatches);
        }
    }

    private void checkForRedundantIncludePatterns() {
        for (ComponentNode component : this.componentsToTypes.getKeys()) {
            this.checkForRedundantIncludePatterns(component);
        }
    }

    private void checkForRedundantIncludePatterns(ComponentNode component) {
        PatternList includePatterns = component.getIncludePatterns();
        if (includePatterns.size() == 1) {
            return;
        }
        HashSet allTypes = new HashSet();
        for (Pattern includePattern : includePatterns) {
            allTypes.addAll(this.includePatternsToTypes.getCollectionOrEmpty((Object)includePattern.pattern()));
        }
        for (int i = 0; i < includePatterns.size(); ++i) {
            HashSet types = new HashSet();
            for (int j = 0; j < includePatterns.size(); ++j) {
                if (i == j) continue;
                types.addAll(this.includePatternsToTypes.getCollectionOrEmpty((Object)((Pattern)includePatterns.get(j)).pattern()));
            }
            if (allTypes.size() != types.size()) continue;
            this.redundantIncludePatterns.add((Object)component.getName(), (Object)((Pattern)includePatterns.get(i)).pattern());
        }
    }

    private void mapTypes(Collection<String> types) {
        ListMap hashToIncludeLink = new ListMap();
        ListMap hashToExcludeLink = new ListMap();
        this.processComponents(this.architecture.getAllComponents(), (ListMap<Long, QuickCheckPattern>)hashToIncludeLink, (ListMap<Long, QuickCheckPattern>)hashToExcludeLink);
        try {
            this.parallelTaskExecutor.processInParallelBatches(new ArrayList<String>(types), typeBatch -> this.processTypes((Collection<String>)typeBatch, (ListMap<Long, QuickCheckPattern>)hashToIncludeLink, (ListMap<Long, QuickCheckPattern>)hashToExcludeLink));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void processTypes(Collection<String> types, ListMap<Long, QuickCheckPattern> hashToIncludeLink, ListMap<Long, QuickCheckPattern> hashToExcludeLink) {
        for (String type : types) {
            if (!this.architecture.isIncludedInScope(type)) continue;
            this.computeMatchingExcludePatternsForType(type, hashToExcludeLink);
            this.computeComponentToTypeMapping(hashToIncludeLink, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeComponentToTypeMapping(ListMap<Long, QuickCheckPattern> hashToIncludeLink, String type) {
        List<ComponentNode> matchingComponents = this.getMatchingComponents(type, hashToIncludeLink);
        if (matchingComponents.isEmpty()) {
            List<String> list = this.unmatchedTypes;
            synchronized (list) {
                this.unmatchedTypes.add(type);
            }
        }
        SetMap<String, ComponentNode> setMap = this.typesToComponents;
        synchronized (setMap) {
            this.addComponentsToTypes(type, matchingComponents);
        }
    }

    private void addComponentsToTypes(String type, List<ComponentNode> matchingComponents) {
        for (ComponentNode node : matchingComponents) {
            this.typesToComponents.add((Object)type, (Object)node);
            this.componentsToTypes.add((Object)node, (Object)type);
        }
    }

    private void processComponents(Collection<ComponentNode> components, ListMap<Long, QuickCheckPattern> hashToIncludeLink, ListMap<Long, QuickCheckPattern> hashToExcludeLink) {
        for (ComponentNode component : components) {
            for (CodeMapping pattern : component.getCodeMappings()) {
                QuickCheckPattern quickCheckPattern = new QuickCheckPattern(pattern.getPattern(), component);
                if (pattern.getType() == ECodeMappingType.INCLUDE) {
                    this.quickCheckIncludePatternsByComponent.add((Object)component, (Object)quickCheckPattern);
                    hashToIncludeLink.add((Object)quickCheckPattern.calculateHash(), (Object)quickCheckPattern);
                    continue;
                }
                if (pattern.getType() != ECodeMappingType.EXCLUDE) continue;
                hashToExcludeLink.add((Object)quickCheckPattern.calculateHash(), (Object)quickCheckPattern);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeMatchingExcludePatternsForType(String type, ListMap<Long, QuickCheckPattern> hashToExcludeLink) {
        List<String> matchingPatterns = QuickCheckPattern.determinePrefixHashes(type).stream().map(arg_0 -> hashToExcludeLink.getCollectionOrEmpty(arg_0)).flatMap(Collection::stream).filter(pattern -> this.matches(type, (QuickCheckPattern)pattern)).map(QuickCheckPattern::getPattern).toList();
        SetMap<String, String> setMap = this.excludePatternsToTypes;
        synchronized (setMap) {
            for (String matchingPattern : matchingPatterns) {
                this.excludePatternsToTypes.add((Object)matchingPattern, (Object)type);
            }
        }
    }

    public UnmodifiableList<String> getUnmatchedTypes() {
        return CollectionUtils.asUnmodifiable(this.unmatchedTypes);
    }

    public @Nullable ComponentNode getMappedComponentForType(String type) {
        return (ComponentNode)CollectionUtils.getAny((Iterable)this.typesToComponents.getCollectionOrElse((Object)type, (Collection)CollectionUtils.emptySet()));
    }

    public @NonNull UnmodifiableSet<ComponentNode> getMappedComponentsForType(String type) {
        return CollectionUtils.asUnmodifiable((Set)((Set)this.typesToComponents.getCollectionOrElse((Object)type, (Collection)CollectionUtils.emptySet())));
    }

    public SetMap<ComponentNode, String> getComponentsToTypes() {
        return this.componentsToTypes;
    }

    public SetMap<String, ComponentNode> getTypesToComponents() {
        return this.typesToComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ComponentNode> getMatchingComponents(String type, ListMap<Long, QuickCheckPattern> hashToIncludeLink) {
        IdentityHashSet<ComponentNode> componentCandidates = this.getComponentsIncludingType(type, hashToIncludeLink);
        ArrayList<ComponentNode> matchingComponents = new ArrayList<ComponentNode>();
        for (ComponentNode component : ComponentNode.sortByDepthDescending(componentCandidates)) {
            if (this.isExplicitlyExcluded(type, component, componentCandidates, (IdentityHashSet<ComponentNode>)new IdentityHashSet())) continue;
            matchingComponents.add(component);
        }
        if (matchingComponents.isEmpty()) {
            return new ArrayList<ComponentNode>();
        }
        if (this.architecture.isStructureOnly()) {
            return matchingComponents;
        }
        ComponentNode matchingComponent = (ComponentNode)matchingComponents.getFirst();
        if (matchingComponents.size() == 1) {
            return List.of(matchingComponent);
        }
        for (ComponentNode component1 : matchingComponents) {
            for (ComponentNode component2 : matchingComponents) {
                if (component1 == component2 || component1.getAncestors().contains(component2) || component2.getAncestors().contains(component1)) continue;
                ListMap<String, String> listMap = this.componentOverlapWarnings;
                synchronized (listMap) {
                    this.componentOverlapWarnings.add((Object)component1.getName(), (Object)("Mappings overlap with those from component '" + component2.getName() + "'. Type '" + type + "' would be mapped to both."));
                }
            }
        }
        return List.of(matchingComponent);
    }

    private IdentityHashSet<ComponentNode> getComponentsIncludingType(String type, ListMap<Long, QuickCheckPattern> hashToIncludeLink) {
        IdentityHashSet componentCandidates = new IdentityHashSet();
        for (long hash : QuickCheckPattern.determinePrefixHashes(type)) {
            List quickCheckPatterns = (List)hashToIncludeLink.getCollectionOrEmpty((Object)hash);
            componentCandidates.addAll(this.getComponentsIncludingType(type, quickCheckPatterns));
        }
        return componentCandidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdentityHashSet<ComponentNode> getComponentsIncludingType(String type, List<QuickCheckPattern> quickCheckPatterns) {
        IdentityHashSet componentCandidates = new IdentityHashSet();
        for (QuickCheckPattern quickCheckPattern : quickCheckPatterns) {
            if (!this.matches(type, quickCheckPattern)) continue;
            ComponentNode component = quickCheckPattern.getComponent();
            if (!this.architecture.isLegacyCodeMapping() && !this.isIncludedInHierarchy(type, component)) continue;
            SetMap<String, String> setMap = this.includePatternsToTypes;
            synchronized (setMap) {
                this.includePatternsToTypes.add((Object)quickCheckPattern.getPattern(), (Object)type);
            }
            componentCandidates.add((Object)component);
        }
        return componentCandidates;
    }

    private boolean matches(String type, String pattern) {
        if (!QuickCheckPattern.extractTypesIfSimplePattern(pattern).isEmpty()) {
            return Objects.requireNonNull(QuickCheckPattern.compileAndCachePattern(pattern, this.compiledPatterns)).matcher(type).matches();
        }
        return Objects.requireNonNull(QuickCheckPattern.compileAndCachePattern(pattern, this.compiledPatterns)).matcher(type).matches();
    }

    private boolean matches(String type, QuickCheckPattern pattern) {
        if (pattern.hasPrecalculatedTypes()) {
            return pattern.matchesType(type, this.compiledPatterns);
        }
        return pattern.matchesType(type, this.compiledPatterns);
    }

    private boolean isIncludedInHierarchy(String type, ComponentNode component) {
        for (ComponentNode parent = component.getParent(); parent != null; parent = parent.getParent()) {
            List includePatterns = (List)this.quickCheckIncludePatternsByComponent.getCollectionOrEmpty((Object)parent);
            if (includePatterns.isEmpty() || !includePatterns.stream().noneMatch(includePattern -> this.matches(type, (QuickCheckPattern)includePattern))) continue;
            return false;
        }
        return true;
    }

    private boolean isExplicitlyExcluded(String type, ComponentNode component, IdentityHashSet<ComponentNode> includingComponents, IdentityHashSet<ComponentNode> seenComponents) {
        boolean componentAlreadySeen;
        boolean bl = componentAlreadySeen = !seenComponents.add((Object)component);
        if (componentAlreadySeen) {
            this.logCircularComponentExclusion(seenComponents);
            return false;
        }
        for (CodeMapping mapping : component.getCodeMappings()) {
            ECodeMappingType mappingType = mapping.getType();
            if (mappingType == ECodeMappingType.EXCLUDE && this.matches(type, mapping.getPattern())) {
                return true;
            }
            if (mappingType != ECodeMappingType.EXCLUDE_COMPONENT) continue;
            String excludedComponentName = mapping.getPattern();
            ComponentNode excludedComponent = this.architecture.getComponentByName(excludedComponentName);
            if (excludedComponent == null) {
                LOGGER.warn("Component {} excluded in component {} does not exist in architecture {}", (Object)excludedComponentName, (Object)component.getId(), (Object)this.architecture.getName());
                continue;
            }
            if (!this.isExplicitlyExcludedViaExcludedComponent(type, includingComponents, seenComponents, excludedComponent)) continue;
            return true;
        }
        return this.isExcludedViaHierarchy(type, component, includingComponents, seenComponents);
    }

    private boolean isExcludedViaHierarchy(String type, ComponentNode component, IdentityHashSet<ComponentNode> includingComponents, IdentityHashSet<ComponentNode> seenComponents) {
        return !this.architecture.isLegacyCodeMapping() && component.getParent() != null && this.isExplicitlyExcluded(type, component.getParent(), includingComponents, seenComponents);
    }

    private boolean isExplicitlyExcludedViaExcludedComponent(String type, IdentityHashSet<ComponentNode> includingComponents, IdentityHashSet<ComponentNode> seenComponents, ComponentNode excludedComponent) {
        ArrayList<ComponentNode> componentsToCheck = new ArrayList<ComponentNode>();
        componentsToCheck.add(excludedComponent);
        componentsToCheck.addAll(excludedComponent.getAllSubComponents());
        for (ComponentNode componentToCheck : componentsToCheck) {
            if (!TypeToComponentMapper.containsComponentWithName(includingComponents, componentToCheck.getName()) || this.isExplicitlyExcluded(type, componentToCheck, includingComponents, (IdentityHashSet<ComponentNode>)new IdentityHashSet(seenComponents))) continue;
            return true;
        }
        return false;
    }

    private void logCircularComponentExclusion(IdentityHashSet<ComponentNode> seenComponents) {
        LOGGER.error("Circular component exclusion for components: {} in architecture {}", (Object)CollectionUtils.map(seenComponents, ComponentNode::getName), (Object)this.architecture.getName());
    }

    private static boolean containsComponentWithName(Collection<ComponentNode> components, String name) {
        return components.stream().anyMatch(component -> name.equals(component.getName()));
    }

    public ListMap<String, String> getComponentOverlapWarnings() {
        return this.componentOverlapWarnings;
    }

    public ListMap<String, String> getRedundantIncludePatterns() {
        return this.redundantIncludePatterns;
    }

    public ListMap<String, Integer> getNumberOfMatches() {
        return this.numberOfMatches;
    }
}

