/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.architecture.incremental.ArchitectureAnalysisUtils;
import com.teamscale.index.architecture.incremental.ArchitectureComponentMapper;
import com.teamscale.index.architecture.incremental.ArchitectureComponentMappingUpdater;
import com.teamscale.index.architecture.incremental.ArchitectureMappingIndex;
import com.teamscale.index.architecture.incremental.TypeComponentMapping;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class ArchitectureAnalysisSynchronizer
extends ChangeProcessorAnalysisStep {
    @IndexAccess(indexName="content", value=EIndexAccessMode.READ_ONLY)
    private TokenElementIndex contentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TypeDependencyIndex typeDependencyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ArchitectureMappingIndex architectureMetaInfoIndex;
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;
    @DeltaSource(value=TypeIndex.class, indexName="types")
    private KeyDelta typeDelta;
    @DeltaSource(value=TypeDependencyIndex.class, indexName="type-dependencies")
    private KeyDelta typeDependencyDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TypeIndex typeIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private TypeDependencyIndex previousRevisionTypeIndex;

    public void execute() throws ConQATException, ExecutionException {
        List<String> changedArchitectures = this.analyzeChangedArchitectures();
        this.updateArchitectures(changedArchitectures);
    }

    private void updateArchitectures(List<String> changedArchitectures) throws ConQATException, ExecutionException {
        if (this.typeDelta.isEmpty() && this.typeDependencyDelta.isEmpty()) {
            return;
        }
        ArchitectureComponentMappingUpdater updater = new ArchitectureComponentMappingUpdater(this.contentIndex, this.architectureMetaInfoIndex, this.typeDelta, this.typeDependencyDelta, this.typeIndex, this.previousRevisionTypeIndex, this.typeDependencyIndex, this.getParallelTaskExecutor());
        List<String> architectures = this.architectureMetaInfoIndex.getAllArchitectures();
        architectures.removeAll(changedArchitectures);
        PairList result = new PairList();
        this.executeInParallelBatches(architectures, architecturesBatch -> {
            String architecturePath = (String)CollectionUtils.getAny((Iterable)architecturesBatch);
            TypeComponentMapping updatedMapping = updater.updateComponentMapping(architecturePath);
            if (updatedMapping != null) {
                Pair tmpResult = Pair.createPair((Object)architecturePath, (Object)updatedMapping);
                PairList pairList = result;
                synchronized (pairList) {
                    result.add(tmpResult);
                }
            }
        }, 1);
        this.architectureMetaInfoIndex.setArchitecturesAndChanges((PairList<String, TypeComponentMapping>)result);
    }

    private List<String> analyzeChangedArchitectures() throws StorageException, ExecutionException {
        this.removeMappingsForDeletedArchitectures();
        List<String> changedArchitectures = ArchitectureAnalysisUtils.filterArchitectureFiles(this.contentDelta.getAddedOrChangedKeysAsStrings());
        if (changedArchitectures.isEmpty()) {
            return changedArchitectures;
        }
        List<TokenElementInfo> changedArchitectureElements = this.contentIndex.getTokenElements(changedArchitectures);
        PairList results = new PairList();
        ArchitectureComponentMapper analyzer = new ArchitectureComponentMapper(this.typeDependencyIndex, this.typeIndex, this.getParallelTaskExecutor());
        this.executeInParallelBatches(changedArchitectureElements, architecturesBatch -> {
            Pair<String, TypeComponentMapping> result = analyzer.createComponentMapping((List<TokenElementInfo>)architecturesBatch);
            if (result != null) {
                PairList pairList = results;
                synchronized (pairList) {
                    results.add(result);
                }
            }
        }, 1);
        this.architectureMetaInfoIndex.setArchitecturesAndChanges((PairList<String, TypeComponentMapping>)results);
        return changedArchitectures;
    }

    private void removeMappingsForDeletedArchitectures() throws StorageException {
        List<String> deletedArchitectures = ArchitectureAnalysisUtils.filterArchitectureFiles(this.contentDelta.getDeletedKeysAsStrings());
        this.architectureMetaInfoIndex.removeArchitectures(deletedArchitectures);
    }
}

