/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.teamscale.index.architecture.assessment.TypeToComponentMapper;
import com.teamscale.index.architecture.scope.ComponentNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class TypeComponentMapping
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    private final List<String> unmatchedTypes = new ArrayList<String>();
    private final ListMap<String, String> redundantIncludePatterns = new ListMap();
    private final ListMap<String, Integer> numberOfMatches = new ListMap();
    private final SetMap<String, String> typesToComponents = new SetMap();
    private final SetMap<String, String> componentsToTypes = new SetMap();
    private final CounterSet<String> thirdPartyDependencyUsageCounter = new CounterSet();

    public TypeComponentMapping(TypeToComponentMapper mapper) {
        Object componentNames;
        this.unmatchedTypes.addAll((Collection<String>)mapper.getUnmatchedTypes());
        this.redundantIncludePatterns.addAll(mapper.getRedundantIncludePatterns());
        this.numberOfMatches.addAll(mapper.getNumberOfMatches());
        for (Map.Entry entry : mapper.getTypesToComponents().entrySet()) {
            componentNames = ((Set)entry.getValue()).stream().map(ComponentNode::getName).collect(Collectors.toSet());
            this.typesToComponents.addAll((Object)((String)entry.getKey()), (Collection)componentNames);
        }
        for (Map.Entry entry : mapper.getComponentsToTypes().entrySet()) {
            componentNames = ((ComponentNode)entry.getKey()).getName();
            this.componentsToTypes.addAll(componentNames, (Collection)entry.getValue());
        }
    }

    public List<String> getUnmatchedTypes() {
        return this.unmatchedTypes;
    }

    public Set<String> getMatchedTypes() {
        return CollectionUtils.asUnmodifiable((Set)this.typesToComponents.getKeys());
    }

    public ListMap<String, String> getRedundantIncludePatterns() {
        return this.redundantIncludePatterns;
    }

    public ListMap<String, Integer> getNumberOfMatches() {
        return this.numberOfMatches;
    }

    public Set<String> getMappedTypes(ComponentNode component) {
        return CollectionUtils.asUnmodifiable((Set)((Set)this.componentsToTypes.getCollectionOrEmpty((Object)component.getName())));
    }

    public @Nullable String getMappedComponentForType(String type) {
        return (String)CollectionUtils.getAny((Iterable)this.typesToComponents.getCollectionOrEmpty((Object)type));
    }

    public void removeType(List<String> deletedTypes, ListMap<String, Integer> numberOfMatches) {
        this.unmatchedTypes.removeAll(deletedTypes);
        this.thirdPartyDependencyUsageCounter.removeAll(deletedTypes);
        for (String deletedType : deletedTypes) {
            List components = ((Set)this.typesToComponents.getCollectionOrEmpty((Object)deletedType)).stream().toList();
            this.typesToComponents.removeCollection((Object)deletedType);
            for (String component : components) {
                this.componentsToTypes.remove((Object)component, (Object)deletedType);
            }
        }
        for (Map.Entry entry : numberOfMatches.entrySet()) {
            List oldValues = (List)this.numberOfMatches.getCollectionOrEmpty((Object)((String)entry.getKey()));
            ArrayList<Integer> newValues = new ArrayList<Integer>();
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                Integer newValue = (Integer)oldValues.get(i) - (Integer)((List)entry.getValue()).get(i);
                newValues.add(newValue);
            }
            this.numberOfMatches.removeCollection((Object)((String)entry.getKey()));
            this.numberOfMatches.addAll((Object)((String)entry.getKey()), newValues);
        }
    }

    public void addThirdPartyDependency(Collection<String> types) {
        this.thirdPartyDependencyUsageCounter.incAll(types);
    }

    public List<String> removeThirdPartyDependency(Collection<String> types) {
        this.thirdPartyDependencyUsageCounter.decAll(types);
        return types.stream().filter(t -> this.thirdPartyDependencyUsageCounter.getValue(t) == 0).toList();
    }

    public void addTypes(SetMap<String, ComponentNode> typesToComponents, List<String> unmatchedTypes, ListMap<String, Integer> addedNumberOfMatches, String architectureName) {
        for (Map.Entry entry : typesToComponents.entrySet()) {
            String type = (String)entry.getKey();
            List<String> componentNames = ((Set)entry.getValue()).stream().map(ComponentNode::getName).toList();
            this.typesToComponents.addAll((Object)type, componentNames);
            for (String componentName : componentNames) {
                boolean resultChanged = this.componentsToTypes.add((Object)componentName, (Object)type);
                if (resultChanged) continue;
                LOGGER.warn("Check mappings for component '{}' in {}:\n{}", (Object)componentName, (Object)architectureName, (Object)type);
            }
        }
        this.unmatchedTypes.addAll(unmatchedTypes);
        for (Map.Entry entry : addedNumberOfMatches.entrySet()) {
            List oldValues = (List)this.numberOfMatches.getCollectionOrEmpty((Object)((String)entry.getKey()));
            ArrayList<Integer> newValues = new ArrayList<Integer>();
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                Integer newValue = (Integer)oldValues.get(i) + (Integer)((List)entry.getValue()).get(i);
                newValues.add(newValue);
            }
            this.numberOfMatches.removeCollection((Object)((String)entry.getKey()));
            this.numberOfMatches.addAll((Object)((String)entry.getKey()), newValues);
        }
    }
}

