/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.scope;

import com.teamscale.index.architecture.assessment.shared.CodeMapping;
import com.teamscale.index.architecture.commons.EStereotype;
import com.teamscale.index.architecture.format.ECodeMappingType;
import com.teamscale.index.architecture.scope.DependencyPolicy;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ComponentNode {
    private final String name;
    private ComponentNode parent = null;
    private final List<ComponentNode> subComponents = new ArrayList<ComponentNode>();
    private String description = "";
    private final Point position;
    private final Dimension dimension;
    private final List<String> includePatterns = new ArrayList<String>();
    private final List<String> excludePatterns = new ArrayList<String>();
    private final Set<String> excludedComponents = new HashSet<String>();
    private final Map<ComponentNode, DependencyPolicy> sourcePolicies = new IdentityHashMap<ComponentNode, DependencyPolicy>();
    private final EStereotype stereotype;
    private final Set<String> matchedTypes = new HashSet<String>();
    private String specItemMapping;
    private static final Logger LOGGER = LogManager.getLogger();

    public ComponentNode(String name, Point position, Dimension dimension, EStereotype stereotype) {
        CCSMAssert.isNotNull((Object)position, (String)"The position must not be null");
        CCSMAssert.isNotNull((Object)dimension, (String)"The dimension must not be null");
        CCSMAssert.isNotNull((Object)((Object)stereotype), (String)"The stereotype must not be null");
        this.name = name;
        this.position = position;
        this.dimension = dimension;
        this.stereotype = stereotype;
    }

    protected void fillNameLookup(Map<String, ComponentNode> nameLookup) {
        nameLookup.put(this.getName(), this);
        if (this.hasSubComponents()) {
            for (ComponentNode child : this.subComponents) {
                child.fillNameLookup(nameLookup);
            }
        }
    }

    public void collectPolicies(Collection<DependencyPolicy> policies) {
        policies.addAll(this.sourcePolicies.values());
        if (this.hasSubComponents()) {
            for (ComponentNode child : this.subComponents) {
                child.collectPolicies(policies);
            }
        }
    }

    public String getId() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public void addIncludePattern(String regex) {
        try {
            Pattern.compile(regex);
            this.includePatterns.add(regex);
        }
        catch (PatternSyntaxException e) {
            LOGGER.error("Invalid pattern in component " + this.name + ": " + regex + " (" + e.getMessage() + ")");
        }
    }

    public void addExcludedComponent(String componentName) {
        this.excludedComponents.add(componentName);
    }

    public void addExcludePattern(String regex) {
        try {
            Pattern.compile(regex);
            this.excludePatterns.add(regex);
        }
        catch (PatternSyntaxException e) {
            LOGGER.error("Invalid pattern in component " + this.name + ": " + regex + " (" + e.getMessage() + ")");
        }
    }

    public void addPolicy(DependencyPolicy policy) throws ConQATException {
        if (policy.getSource() == this) {
            if (this.sourcePolicies.containsKey(policy.getTarget())) {
                throw new ConQATException("Duplicate policy from " + this.getName() + " to " + String.valueOf(policy.getTarget()));
            }
            this.sourcePolicies.put(policy.getTarget(), policy);
        }
    }

    public boolean hasPolicyTo(ComponentNode other) {
        return this.sourcePolicies.containsKey(other);
    }

    public DependencyPolicy getPolicyTo(ComponentNode other) {
        return this.sourcePolicies.get(other);
    }

    public Set<ComponentNode> getAncestors() {
        LinkedHashSet<ComponentNode> result = new LinkedHashSet<ComponentNode>();
        for (ComponentNode node = this; node != null; node = node.getParent()) {
            result.add(node);
        }
        return result;
    }

    public Point getPosition() {
        return this.position;
    }

    public EStereotype getStereotype() {
        return this.stereotype;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public String getSpecItemMapping() {
        return this.specItemMapping;
    }

    public void setSpecItemMapping(String specItemMapping) {
        this.specItemMapping = specItemMapping;
    }

    private static List<CodeMapping> createCodeMappingList(Collection<String> patternList, ECodeMappingType type) {
        ArrayList<CodeMapping> codeMappings = new ArrayList<CodeMapping>();
        for (String pattern : patternList) {
            codeMappings.add(new CodeMapping(pattern, type));
        }
        return codeMappings;
    }

    public UnmodifiableList<CodeMapping> getCodeMappings() {
        ArrayList<CodeMapping> codeMappings = new ArrayList<CodeMapping>();
        codeMappings.addAll(ComponentNode.createCodeMappingList(this.includePatterns, ECodeMappingType.INCLUDE));
        codeMappings.addAll(ComponentNode.createCodeMappingList(this.excludePatterns, ECodeMappingType.EXCLUDE));
        codeMappings.addAll(ComponentNode.createCodeMappingList(this.excludedComponents, ECodeMappingType.EXCLUDE_COMPONENT));
        return CollectionUtils.asUnmodifiable(codeMappings);
    }

    public boolean isDescendant(ComponentNode component) {
        Set<ComponentNode> ancestors = this.getAncestors();
        return ancestors.contains(component);
    }

    public boolean isToplevel() {
        return this.getParent() != null && this.getParent().getParent() == null;
    }

    public List<ComponentNode> getAllSubComponents() {
        List<ComponentNode> subComponents = this.getSubComponents();
        ArrayList<ComponentNode> result = new ArrayList<ComponentNode>(subComponents);
        for (ComponentNode subComponent : subComponents) {
            result.addAll(subComponent.getAllSubComponents());
        }
        return result;
    }

    public List<ComponentNode> getSubComponents() {
        return CollectionUtils.asUnmodifiable(this.subComponents);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<String> getMatchedTypes() {
        return CollectionUtils.asUnmodifiable(this.matchedTypes);
    }

    public void setMatchedTypes(Collection<String> matchedTypes) {
        this.matchedTypes.clear();
        this.matchedTypes.addAll(matchedTypes);
    }

    public ComponentNode getParent() {
        return this.parent;
    }

    public boolean hasSubComponents() {
        return !this.subComponents.isEmpty();
    }

    public void addSubComponent(ComponentNode subComponent) {
        this.subComponents.add(subComponent);
        subComponent.parent = this;
    }

    public PatternList getIncludePatterns() {
        PatternList patternList = new PatternList();
        this.includePatterns.forEach(pattern -> patternList.add((Object)Pattern.compile(pattern)));
        return patternList;
    }

    public PatternList getExcludePatterns() {
        PatternList patternList = new PatternList();
        this.excludePatterns.forEach(pattern -> patternList.add((Object)Pattern.compile(pattern)));
        return patternList;
    }

    public static List<ComponentNode> sortByDepthDescending(Collection<ComponentNode> components) {
        return CollectionUtils.sort(components, Comparator.comparingInt(component -> component.getAncestors().size()).reversed().thenComparing(ComponentNode::getName));
    }
}

