/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.read;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreator;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.TeamscaleVersionContainer;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.StorageMigrator;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.index.backup.BackupUtils;
import com.teamscale.index.backup.EBackupStatus;
import com.teamscale.index.backup.EBackupZipFileVersion;
import com.teamscale.index.backup.MigratedZipFile;
import com.teamscale.index.backup.read.BackupImportOptions;
import com.teamscale.index.backup.read.BackupImportStatus;
import com.teamscale.index.backup.read.BackupReadingParameters;
import com.teamscale.index.backup.read.EncryptionAwareStoreImporter;
import com.teamscale.index.backup.read.GlobalStoreImporter;
import com.teamscale.index.backup.read.ProjectStoreImporter;
import com.teamscale.index.configuration.service.EProjectConfigurationVersion;
import com.teamscale.index.migration.MigrateVersion117WriteSapSystemIdToSapSystemConnection;
import jakarta.ws.rs.WebApplicationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.cache.StorageCacheRegistry;
import org.conqat.engine.persistence.config.DatabaseConfiguration;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.distribution.LocalMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.crypto.AutoEncryptingStorageSystemProvider;
import org.conqat.engine.persistence.store.transaction.TransactionHandler;
import org.conqat.engine.persistence.store.util.StoreFactory;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.ZipFile;

public class BackupReader {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CUSTOM_FINDINGS_FOLDER = "custom-external-findings";
    public static final String PROJECT_CONFIG_SUFFIX = "/Project-Config";
    private final BackupReadingParameters parameters;
    private final ICancelable cancelable;
    private final StoreFactory storeFactory;
    private final MigratedZipFile backupFile;
    private final EStorageSystemVersion sourceVersion;
    private final IParallelTaskExecutor parallelTaskExecutor;
    private final EBackupZipFileVersion filePathVersion;
    private final TransactionHandler transactionHandler;
    private EProjectConfigurationVersion minimumSourceProjectConfigurationVersion = EProjectConfigurationVersion.CURRENT_VERSION;
    private final IndexLayer transactionalMigrationIndexLayer;
    private final EncryptionAwareStoreImporter storeImporter;
    private final Map<PublicProjectId, PublicProjectId> clashingProjectIdMappings = new HashMap<PublicProjectId, PublicProjectId>();

    private BackupReader(BackupReadingParameters parameters, ICancelable cancelable, ZipFile backupFile, StoreFactory storeFactory, IParallelTaskExecutor parallelTaskExecutor) throws IOException, StorageException {
        this.parameters = parameters;
        this.cancelable = cancelable;
        this.storeImporter = new EncryptionAwareStoreImporter(backupFile);
        this.storeFactory = storeFactory;
        this.filePathVersion = BackupReader.extractFilePathVersionEntry(backupFile);
        this.sourceVersion = BackupReader.extractVersionEntry(backupFile);
        this.parallelTaskExecutor = parallelTaskExecutor;
        List<EBackupZipFileVersion> backupFileVersions = BackupReader.getNewerBackupFileVersions(this.filePathVersion);
        this.backupFile = new MigratedZipFile((org.apache.commons.compress.archivers.zip.ZipFile)backupFile, backupFileVersions);
        this.transactionHandler = new TransactionHandler(parameters.getIndexLayer().getStorageCacheProvider(), (IFactory)storeFactory);
        LocalMessageBroker messageBroker = new LocalMessageBroker();
        this.transactionalMigrationIndexLayer = new IndexLayer((IStorageSystemProvider)new AutoEncryptingStorageSystemProvider(this.transactionHandler.decorate(parameters.getIndexLayer().getRawStorageSystemProvider())), StorageCacheRegistry.createCacheProvider((IMessageBroker)messageBroker), (IMessageBroker)messageBroker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackupImportStatus importBackupData(ZipFile backupFile, BackupReadingParameters parameters, ICancelable cancelable, IParallelTaskExecutor parallelTaskExecutor) throws StorageException {
        BackupImportStatus status = new BackupImportStatus(new BackupImportOptions());
        try {
            BackupReader.importBackupData(backupFile, parameters, status, cancelable, parallelTaskExecutor);
        }
        catch (ExecutionCanceledException e) {
            status.setStatusAndMessage(EBackupStatus.FAILURE, e.getMessage());
        }
        finally {
            status.finish();
        }
        return status;
    }

    public static Set<InternalProjectId> importBackupData(ZipFile backupFile, BackupReadingParameters parameters, BackupImportStatus backupImportStatus, ICancelable cancelable, IParallelTaskExecutor parallelTaskExecutor) throws StorageException, ExecutionCanceledException {
        try {
            HashSet<InternalProjectId> updatedProjects = new HashSet<InternalProjectId>();
            StoreFactory.runWithTemporaryOnDiskStoreFactory(storeFactory -> {
                BackupReader backupReader = new BackupReader(parameters, cancelable, backupFile, (StoreFactory)storeFactory, parallelTaskExecutor);
                backupReader.performImport(backupImportStatus);
                updatedProjects.addAll((Collection<InternalProjectId>)backupImportStatus.getUpdateProjects());
            }, (File)StoreFactory.createTemporaryStorageDirectory((File)parameters.getTempDataStorageDirectory(), (String)"__import"), (DatabaseConfiguration)parameters.getInstanceConfiguration().getDatabaseConfiguration());
            return updatedProjects;
        }
        catch (ExecutionCanceledException | StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    private void performImport(BackupImportStatus backupImportStatus) throws IOException, ExecutionCanceledException {
        try {
            this.runImport(backupImportStatus);
        }
        catch (MigrationException | WebApplicationException | ConQATException e) {
            throw new IOException(e);
        }
        IMessageBroker messageBroker = this.parameters.getIndexLayer().getMessageBroker();
        ISchedulerCommunicator.getInstance().sendReloadCommand(messageBroker, null);
        messageBroker.sendMessage("backup-import-finished", backupImportStatus.getStatus().name());
    }

    private void runImport(BackupImportStatus backupImportStatus) throws IOException, ConQATException, MigrationException, ExecutionCanceledException {
        backupImportStatus.info("Backup file version: " + String.valueOf((Object)this.filePathVersion));
        backupImportStatus.info("Backup storage system version: " + String.valueOf(this.sourceVersion));
        if (this.parameters.getBackupImportOptions().isImportGlobalData()) {
            StorageMigrator storageMigrator = new StorageMigrator(this.sourceVersion, (IFactory)this.storeFactory);
            GlobalStoreImporter globalStoreImporter = new GlobalStoreImporter(this.cancelable, this.transactionHandler, this.transactionalMigrationIndexLayer, this.backupFile, this.storeImporter, this.filePathVersion, this.parameters.getIndexLayer(), storageMigrator);
            globalStoreImporter.handleGlobalData(backupImportStatus);
        }
        List<ProjectConfiguration> projectConfigurations = this.getProjectConfigurations(backupImportStatus);
        this.importProjects(projectConfigurations, backupImportStatus);
        this.validateServerOptionsAfterImport(backupImportStatus);
        this.setShadowMode(backupImportStatus);
        backupImportStatus.setStatusMessage("Committing results to storage system...");
        this.commitImportTransaction();
    }

    private void validateServerOptionsAfterImport(BackupImportStatus backupImportStatus) throws StorageException {
        GlobalStorageSystem globalStorageSystem = this.transactionalMigrationIndexLayer.openGlobalStorageSystem();
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)globalStorageSystem.openGlobalIndex(ServerOptionIndex.class);
        PairList serverOptions = serverOptionIndex.getOptionsStartingWith("server:");
        for (IOption option : serverOptions.getSecondList()) {
            String validationError = option.validate(BackupReader.getStorageInfo(globalStorageSystem), this.parameters.getInstanceConfiguration());
            if (validationError == null) continue;
            backupImportStatus.error("Invalid server option value (Go to Admin > Settings to fix them): " + validationError);
        }
    }

    private static IStorageInfo getStorageInfo(final GlobalStorageSystem globalStorageSystem) {
        return new IStorageInfo(){

            public InternalProjectId getInternalId() {
                return null;
            }

            public PublicProjectId getPrimaryPublicId() {
                return null;
            }

            public ProjectStorageSystem getProjectStorageSystem() {
                return null;
            }

            public GlobalStorageSystem getGlobalStorageSystem() {
                return globalStorageSystem;
            }
        };
    }

    private void commitImportTransaction() throws StorageException {
        Lock lock = this.parameters.getLockProvider().obtainLock("ProjectDiscoveryHelperLock");
        lock.lock();
        try {
            this.transactionHandler.commit();
        }
        finally {
            lock.unlock();
        }
    }

    private void setShadowMode(BackupImportStatus backupImportStatus) throws StorageException {
        ServerOptionRegistry serverOptionRegistry = ServerOptionRegistry.getInstance();
        ShadowModeOption shadowModeOption = Optional.ofNullable((ShadowModeOption)serverOptionRegistry.getServerOption("ts.shadow-mode", ShadowModeOption.class, (ServerOptionIndex)this.parameters.getIndexLayer().openGlobalIndex(ServerOptionIndex.class))).orElseGet(ShadowModeOption::new);
        if (!shadowModeOption.enabled && this.parameters.getBackupImportOptions().isEnableShadowMode()) {
            if (serverOptionRegistry.isOverridden("ts.shadow-mode")) {
                backupImportStatus.error("Cannot set shadow mode, as it is overridden by settings file.");
            } else {
                shadowModeOption.enabled = true;
            }
        }
        serverOptionRegistry.putOption("server", "ts.shadow-mode", null, (IOption)shadowModeOption, true, (OptionIndexBase)this.transactionalMigrationIndexLayer.openGlobalIndex(ServerOptionIndex.class));
    }

    private static List<EBackupZipFileVersion> getNewerBackupFileVersions(EBackupZipFileVersion backupZipFileVersion) {
        EBackupZipFileVersion[] versions = EBackupZipFileVersion.values();
        ArrayList<EBackupZipFileVersion> newerVersions = new ArrayList<EBackupZipFileVersion>();
        int currentVersionIndex = backupZipFileVersion.ordinal() + 1;
        while (currentVersionIndex < versions.length) {
            newerVersions.add(versions[currentVersionIndex++]);
        }
        return newerVersions;
    }

    public static EStorageSystemVersion extractVersionEntry(ZipFile backupFile) throws IOException {
        EStorageSystemVersion version;
        ZipArchiveEntry entry = backupFile.getEntry("Teamscale-Version");
        if (entry == null) {
            throw new IOException("Missing version entry!");
        }
        try (InputStream stream = backupFile.getInputStream(entry);){
            version = (EStorageSystemVersion)EnumUtils.valueOf(EStorageSystemVersion.class, (String)FileSystemUtils.readStreamUTF8((InputStream)stream));
        }
        if (version == null) {
            throw new IOException(TeamscaleVersionContainer.createInvalidVersionErrorMessage((String)"backup"));
        }
        return version;
    }

    private static EBackupZipFileVersion extractFilePathVersionEntry(ZipFile backupFile) throws IOException {
        String versionString;
        ZipArchiveEntry entry = backupFile.getEntry("Backup-Zip-File-Version");
        if (entry == null) {
            return EBackupZipFileVersion.FILE_VERSION_V1;
        }
        try (InputStream stream = backupFile.getInputStream(entry);){
            versionString = FileSystemUtils.readStreamUTF8((InputStream)stream);
        }
        EBackupZipFileVersion version = (EBackupZipFileVersion)EnumUtils.valueOf(EBackupZipFileVersion.class, (String)versionString);
        if (version == null) {
            throw new IOException("Unknown/unsupported file path version: " + versionString);
        }
        return version;
    }

    private void importProjects(List<ProjectConfiguration> projectConfigurations, BackupImportStatus backupImportStatus) throws StorageException, ExecutionCanceledException {
        this.createProjectsFromBackup(projectConfigurations, this.transactionalMigrationIndexLayer, this.parameters, backupImportStatus);
        this.importProjectBackupData(backupImportStatus);
    }

    private void createProjectsFromBackup(List<ProjectConfiguration> projectConfigurations, IndexLayer indexLayer, BackupReadingParameters parameters, BackupImportStatus backupImportStatus) throws StorageException, ExecutionCanceledException {
        List projectsWithoutParent = CollectionUtils.filter(projectConfigurations, projectConfiguration -> projectConfiguration.getParentProjectId() == null);
        List projectsWithParent = CollectionUtils.filter(projectConfigurations, projectConfiguration -> projectConfiguration.getParentProjectId() != null);
        this.createProjects(projectsWithoutParent, indexLayer, parameters, backupImportStatus, projectConfigurations.size(), 0);
        this.createProjects(projectsWithParent, indexLayer, parameters, backupImportStatus, projectConfigurations.size(), projectsWithoutParent.size());
    }

    private List<ProjectConfiguration> getProjectConfigurations(BackupImportStatus backupImportStatus) throws IOException, MigrationException, StorageException {
        List<ProjectConfiguration> projectConfigurations = new ArrayList<ProjectConfiguration>();
        for (ZipArchiveEntry entry : this.backupFile.getEntries()) {
            byte[] data;
            if (BackupUtils.isGlobalDataPath(entry.getName()) || !entry.getName().endsWith(PROJECT_CONFIG_SUFFIX)) continue;
            try (InputStream stream = this.backupFile.getInputStream(entry);){
                data = FileSystemUtils.readStreamBinary((InputStream)stream);
            }
            ProjectConfiguration projectConfiguration = (ProjectConfiguration)TeamscaleVersionContainer.fromJson((byte[])data, null, ProjectConfiguration.class, (Enum)EProjectConfigurationVersion.CURRENT_VERSION, (String)"project configuration");
            BackupImportStatus.ImportProgress projectStatus = backupImportStatus.getOrCreateProjectStatus(projectConfiguration.getPrimaryPublicId());
            PublicProjectId publicProjectId = (PublicProjectId)ProjectStoreImporter.parseProjectAndStoreName(entry.getName()).getFirst();
            if (!projectConfiguration.getPrimaryPublicId().equals((Object)publicProjectId)) {
                projectStatus.setFailed("Primary project ID in Project-Config (" + String.valueOf(projectConfiguration.getInternalId()) + ") does not match folder name (" + String.valueOf(publicProjectId) + ")");
                continue;
            }
            projectConfiguration.setPublicIds(projectConfiguration.getPublicIds().stream().distinct().collect(Collectors.toList()));
            this.updateMinimumProjectConfigurationVersion(data);
            projectConfigurations.add(projectConfiguration);
        }
        projectConfigurations = this.resolvePublicIdClashes(projectConfigurations);
        return CollectionUtils.sort(projectConfigurations, Comparator.comparing(ProjectConfiguration::getPrimaryPublicId));
    }

    private void updateMinimumProjectConfigurationVersion(byte[] data) {
        Optional projectConfigurationVersion = TeamscaleVersionContainer.extractVersion((byte[])data, (Enum)EProjectConfigurationVersion.CURRENT_VERSION);
        if (projectConfigurationVersion.isPresent() && ((EProjectConfigurationVersion)((Object)projectConfigurationVersion.get())).ordinal() < this.minimumSourceProjectConfigurationVersion.ordinal()) {
            this.minimumSourceProjectConfigurationVersion = (EProjectConfigurationVersion)((Object)projectConfigurationVersion.get());
        }
    }

    private List<ProjectConfiguration> resolvePublicIdClashes(List<ProjectConfiguration> projectConfigurations) {
        List allPublicIds = projectConfigurations.stream().map(ProjectConfiguration::getPublicIds).flatMap(Collection::stream).collect(Collectors.toList());
        CounterSet idCounterSet = new CounterSet(allPublicIds);
        PublicProjectId clashingProjectId = idCounterSet.getKeys().stream().filter(publicId -> idCounterSet.getValue(publicId) > 1).findFirst().orElse(null);
        if (clashingProjectId == null) {
            return projectConfigurations;
        }
        HashSet<PublicProjectId> existingIds = new HashSet<PublicProjectId>(allPublicIds);
        List result = CollectionUtils.sort(projectConfigurations, Comparator.comparingInt(o -> o.getPublicIds().size()));
        int clashingProjectCount = idCounterSet.getValue((Object)clashingProjectId);
        for (int i = 1; i < clashingProjectCount; ++i) {
            PublicProjectId renamedProjectId = BackupReader.createNonClashingProjectId(clashingProjectId, existingIds);
            ProjectConfiguration clashingConfiguration = result.stream().filter(projectConfiguration -> projectConfiguration.getPublicIds().contains((Object)clashingProjectId)).findFirst().get();
            ArrayList<PublicProjectId> publicIds = new ArrayList<PublicProjectId>((Collection<PublicProjectId>)clashingConfiguration.getPublicIds());
            publicIds.remove(clashingProjectId);
            publicIds.add(renamedProjectId);
            clashingConfiguration.setPublicIds(publicIds);
            existingIds.add(renamedProjectId);
            this.clashingProjectIdMappings.put(clashingProjectId, renamedProjectId);
        }
        return this.resolvePublicIdClashes(result);
    }

    private static PublicProjectId createNonClashingProjectId(PublicProjectId clashingProjectId, Set<PublicProjectId> existingProjectIds) {
        PublicProjectId nonClashingProjectId = new PublicProjectId(String.valueOf(clashingProjectId) + "_shadowed");
        int i = 2;
        while (existingProjectIds.contains(nonClashingProjectId)) {
            nonClashingProjectId = new PublicProjectId(String.valueOf(clashingProjectId) + "_shadowed_" + i++);
        }
        LOGGER.warn("Found clashing project ID: '{}', renaming to '{}'", (Object)clashingProjectId, (Object)nonClashingProjectId);
        return nonClashingProjectId;
    }

    private void createProjects(List<ProjectConfiguration> projectsToCreate, IndexLayer indexLayer, BackupReadingParameters parameters, BackupImportStatus backupImportStatus, int totalNumberOfProjects, int numberOfPreviouslyCreatedProjects) throws StorageException, ExecutionCanceledException {
        ProjectIndex projectIndex = indexLayer.openProjectIndex();
        for (int i = 0; i < projectsToCreate.size(); ++i) {
            this.cancelable.verifyNotCanceled();
            ProjectConfiguration projectToCreate = projectsToCreate.get(i);
            PublicProjectId primaryPublicId = projectToCreate.getPrimaryPublicId();
            Optional projectInfo = projectIndex.tryResolveProject((IProjectId)primaryPublicId);
            BackupImportStatus.ImportProgress projectImportStatus = backupImportStatus.getOrCreateProjectStatus(primaryPublicId);
            String projectDetails = projectToCreate.getName() + " (" + (i + 1 + numberOfPreviouslyCreatedProjects) + "/" + totalNumberOfProjects + ")";
            if (projectInfo.isPresent()) {
                if (((ProjectInfo)projectInfo.get()).getPrimaryPublicId().equals((Object)primaryPublicId)) {
                    backupImportStatus.addUpdatedProject(((ProjectInfo)projectInfo.get()).getInternalId());
                    continue;
                }
                projectImportStatus.setFailed("Project " + String.valueOf(primaryPublicId) + " from backup only matches alternate project ID for project " + String.valueOf(((ProjectInfo)projectInfo.get()).getPrimaryPublicId()) + ". Please ensure that primary public IDs match between the projects or remove the project from the backup.");
                backupImportStatus.error("Failed to import project: " + projectDetails);
                continue;
            }
            Optional projectWithSameInternalId = projectIndex.getProjectWithoutPublicIdResolution(projectToCreate.getInternalId());
            if (projectWithSameInternalId.isPresent()) {
                projectImportStatus.setFailed("Project " + String.valueOf(((ProjectInfo)projectWithSameInternalId.get()).getPrimaryPublicId()) + " already uses the same internal ID " + String.valueOf(projectToCreate.getInternalId()) + ". Please ensure that primary public IDs match between the projects or remove the project from the backup.");
                backupImportStatus.error("Failed to import project: " + projectDetails);
                continue;
            }
            if (parameters.getBackupImportOptions().isSkipNewProjects()) {
                projectImportStatus.setStatusMessage("Skipped creation of new project");
                projectImportStatus.setStatus(EBackupStatus.SUCCESS);
                continue;
            }
            try {
                new ProjectCreator(indexLayer, ConfigurationInitializationContext.EInitializationReason.BACKUP).createProject(projectToCreate, !parameters.getBackupImportOptions().isSkipValidation(), false, !parameters.getBackupImportOptions().isSkipValidation());
                backupImportStatus.addImportedProject(primaryPublicId);
                projectImportStatus.setStatusMessage("Project created, waiting for data import");
                backupImportStatus.info("Imported project: " + projectDetails);
                continue;
            }
            catch (ProjectConfigurationException | TriggerCompilationException e) {
                projectImportStatus.setFailed(e.getMessage());
                LOGGER.error("Exception during project creation.", e);
                BackupReader.logCodeScopeViolationsIfNeeded((Exception)e);
                backupImportStatus.error("Failed to import project: " + projectDetails);
            }
        }
    }

    private static void logCodeScopeViolationsIfNeeded(Exception exception) {
        ProjectConfigurationException pce;
        String message;
        if (exception instanceof ProjectConfigurationException && (message = (pce = (ProjectConfigurationException)((Object)exception)).getCodeScopeViolationsMessage()) != null) {
            LOGGER.error("Code Scope misconfiguration:\n{}", (Object)message);
        }
    }

    private void importProjectBackupData(BackupImportStatus backupImportStatus) throws StorageException, ExecutionCanceledException {
        MigrateVersion117WriteSapSystemIdToSapSystemConnection sapSystemIdMigrator = new MigrateVersion117WriteSapSystemIdToSapSystemConnection(this.storeImporter, this.transactionalMigrationIndexLayer);
        ProjectIndex projectIndex = this.transactionalMigrationIndexLayer.openProjectIndex();
        ArrayList<Callable<Void>> projectImportCalls = new ArrayList<Callable<Void>>();
        for (PublicProjectId projectId : this.getProjectIds()) {
            Optional projectInfo;
            if (this.clashingProjectIdMappings.containsKey(projectId)) {
                projectId = this.clashingProjectIdMappings.get(projectId);
            }
            if ((projectInfo = projectIndex.tryResolveProject((IProjectId)projectId)).isEmpty()) {
                LOGGER.warn("Ignored store for non-existing project {}", (Object)projectId);
                continue;
            }
            if (!((ProjectInfo)projectInfo.get()).getPrimaryPublicId().equals((Object)projectId)) {
                CCSMAssert.isTrue((backupImportStatus.getOrCreateProjectStatus(projectId).getStatus() == EBackupStatus.FAILURE ? 1 : 0) != 0, (String)"Project import for match with alternate ID must fail.");
                continue;
            }
            BackupImportStatus.ImportProgress progress = backupImportStatus.getOrCreateProjectStatus(((ProjectInfo)projectInfo.get()).getPrimaryPublicId());
            if (progress.getStatus() == EBackupStatus.FAILURE) {
                LOGGER.warn("Skipping backup import for failed project: {}", (Object)projectId);
                continue;
            }
            boolean projectExists = backupImportStatus.isUpdatedProject(((ProjectInfo)projectInfo.get()).getInternalId());
            projectImportCalls.add(() -> {
                this.importStoresForProject((ProjectInfo)projectInfo.get(), projectExists, progress, sapSystemIdMigrator);
                return null;
            });
        }
        this.runImportsInParallel(projectImportCalls);
    }

    private void runImportsInParallel(List<Callable<Void>> projectImportCalls) throws ExecutionCanceledException, StorageException {
        try {
            this.parallelTaskExecutor.executeInParallel(projectImportCalls);
            this.cancelable.verifyNotCanceled();
        }
        catch (InterruptedException e) {
            throw new ExecutionCanceledException((Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ExecutionCanceledException) {
                ExecutionCanceledException executionCanceledException = (ExecutionCanceledException)cause;
                throw executionCanceledException;
            }
            if (cause instanceof StorageException) {
                StorageException storageException = (StorageException)cause;
                throw storageException;
            }
            throw new StorageException(cause);
        }
    }

    private void importStoresForProject(ProjectInfo projectInfo, boolean projectExists, BackupImportStatus.ImportProgress progress, MigrateVersion117WriteSapSystemIdToSapSystemConnection sapSystemIdMigrator) throws StorageException {
        if (this.cancelable.isCanceled()) {
            progress.warn("Skipped due to canceled trigger");
            return;
        }
        ProjectStoreImporter projectStoreImporter = new ProjectStoreImporter(this.transactionalMigrationIndexLayer, this.cancelable, this.clashingProjectIdMappings, this.sourceVersion, this.parameters, this.storeFactory, this.storeImporter);
        projectStoreImporter.importStoresForProject(projectInfo, projectExists, progress, sapSystemIdMigrator, this.backupFile);
        ISchedulerCommunicator.getInstance().sendReloadCommand(this.parameters.getIndexLayer().getMessageBroker(), projectInfo.getInternalId());
    }

    private Set<PublicProjectId> getProjectIds() throws StorageException {
        TreeSet<PublicProjectId> result = new TreeSet<PublicProjectId>(Comparator.comparing(ProjectIdBase::toString));
        for (ZipArchiveEntry entry : this.backupFile.getEntries()) {
            String entryName = entry.getName();
            if (!ProjectStoreImporter.isProjectEntry(entry)) continue;
            result.add((PublicProjectId)ProjectStoreImporter.parseProjectAndStoreName(entryName).getFirst());
        }
        return result;
    }
}

