/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.binary_size.common_substrings;

import com.teamscale.index.binary_size.common_substrings.StringLiteralSequence;
import com.teamscale.index.binary_size.common_substrings.SubstringLiteralCloneClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.index.BidirectionalListIndex;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.IndexValueClass;

@Index(name="cpp-string-literals", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={})
public class StringLiteralSubstringCloneIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "cpp-string-literals";
    private final ValueIndex<ArrayList<AbbreviatedStringLiteralSequence>> stringLiteralIndex;
    private final BidirectionalListIndex<Integer, AbbreviatedSubstringLiteralCloneClass> cloneClassesIndex;

    public StringLiteralSubstringCloneIndex(IStore store) {
        super(store, true);
        this.stringLiteralIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, "string-literals"));
        this.cloneClassesIndex = new BidirectionalListIndex((IStore)new DelegatingPartitionStore(store, "clone-classes"));
    }

    public void storeStringLiteralsForUniformPaths(Map<String, List<StringLiteralSequence>> literals) throws StorageException {
        PairList abbreviated = new PairList();
        for (Map.Entry<String, List<StringLiteralSequence>> entry : literals.entrySet()) {
            String uniformPath = entry.getKey();
            List<StringLiteralSequence> literalsInPath = entry.getValue();
            abbreviated.add((Object)uniformPath, StringLiteralSubstringCloneIndex.abbreviateLiteralSequences(literalsInPath));
        }
        this.stringLiteralIndex.setValues(abbreviated);
    }

    public PairList<String, List<StringLiteralSequence>> loadStoredStringLiterals() throws StorageException {
        PairList unabbreviated = new PairList();
        for (Pair pair : this.stringLiteralIndex.getAllEntries()) {
            String uniformPath = (String)pair.getFirst();
            ArrayList literalsInPath = (ArrayList)pair.getSecond();
            unabbreviated.add((Object)uniformPath, StringLiteralSubstringCloneIndex.unabbreviateLiteralSequences(uniformPath, literalsInPath));
        }
        return unabbreviated;
    }

    public void removeStringLiteralsForUniformPaths(List<String> uniformPaths) throws StorageException {
        this.stringLiteralIndex.removeValues(uniformPaths);
    }

    public void updateCloneClasses(Map<String, ArrayList<SubstringLiteralCloneClass>> updatedCloneClasses, List<String> deletedPaths) throws StorageException {
        this.cloneClassesIndex.updateValues(this.abbreviateCloneClasses(updatedCloneClasses), this.abbreviateStrings(deletedPaths));
    }

    public List<String> getPathsThatShareCloneClassesWithPaths(List<String> inputPaths) throws StorageException {
        Set abbreviatedKeys = this.cloneClassesIndex.getKeysThatShareValuesWith(this.abbreviateStrings(inputPaths));
        return this.unAbbreviateStrings(new ArrayList<Integer>(abbreviatedKeys));
    }

    private List<Integer> abbreviateStrings(List<String> strings) throws StorageException {
        return this.store.getAbbreviator().abbreviate(strings);
    }

    private List<String> unAbbreviateStrings(List<Integer> abbreviatedStrings) throws StorageException {
        return this.store.getAbbreviator().unabbreviate(abbreviatedStrings);
    }

    private Map<Integer, ArrayList<AbbreviatedSubstringLiteralCloneClass>> abbreviateCloneClasses(Map<String, ArrayList<SubstringLiteralCloneClass>> cloneClasses) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        HashMap<Integer, ArrayList<AbbreviatedSubstringLiteralCloneClass>> abbreviatedCloneClasses = new HashMap<Integer, ArrayList<AbbreviatedSubstringLiteralCloneClass>>(cloneClasses.size());
        for (Map.Entry<String, ArrayList<SubstringLiteralCloneClass>> entry : cloneClasses.entrySet()) {
            String uniformPath = entry.getKey();
            ArrayList<SubstringLiteralCloneClass> cloneClassList = entry.getValue();
            ArrayList<AbbreviatedSubstringLiteralCloneClass> abbreviatedCloneClassList = new ArrayList<AbbreviatedSubstringLiteralCloneClass>(cloneClassList.size());
            for (SubstringLiteralCloneClass cloneClass : cloneClassList) {
                Integer abbreviatedComponentName = abbreviator.abbreviate(cloneClass.architectureComponent());
                Integer abbreviatedClonedText = abbreviator.abbreviate(cloneClass.clonedText());
                abbreviatedCloneClassList.add(new AbbreviatedSubstringLiteralCloneClass(abbreviatedComponentName, abbreviatedClonedText));
            }
            abbreviatedCloneClasses.put(abbreviator.abbreviate(uniformPath), abbreviatedCloneClassList);
        }
        return abbreviatedCloneClasses;
    }

    private static ArrayList<AbbreviatedStringLiteralSequence> abbreviateLiteralSequences(List<StringLiteralSequence> literalsInPath) {
        ArrayList<AbbreviatedStringLiteralSequence> abbreviatedSequences = new ArrayList<AbbreviatedStringLiteralSequence>();
        for (StringLiteralSequence sequence : literalsInPath) {
            abbreviatedSequences.add(new AbbreviatedStringLiteralSequence(sequence.literalText, sequence.positioningInfos));
        }
        return abbreviatedSequences;
    }

    private static List<StringLiteralSequence> unabbreviateLiteralSequences(String uniformPath, ArrayList<AbbreviatedStringLiteralSequence> literalsInPath) {
        ArrayList<StringLiteralSequence> unAbbreviatedSequences = new ArrayList<StringLiteralSequence>();
        for (AbbreviatedStringLiteralSequence sequence : literalsInPath) {
            unAbbreviatedSequences.add(new StringLiteralSequence(sequence.literalText, uniformPath, sequence.positioningInfos));
        }
        return unAbbreviatedSequences;
    }

    @IndexValueClass
    private record AbbreviatedSubstringLiteralCloneClass(Integer abbreviatedArchitectureComponent, Integer abbreviatedClonedText) implements Serializable,
    Comparable<AbbreviatedSubstringLiteralCloneClass>
    {
        private static final long serialVersionUID = 1L;

        @Override
        public int compareTo(@NonNull AbbreviatedSubstringLiteralCloneClass o) {
            int compare = this.abbreviatedArchitectureComponent.compareTo(o.abbreviatedArchitectureComponent);
            if (compare != 0) {
                return compare;
            }
            return this.abbreviatedClonedText.compareTo(o.abbreviatedClonedText);
        }
    }

    @IndexValueClass
    private record AbbreviatedStringLiteralSequence(String literalText, StringLiteralSequence.StringLiteralPositioningInfo[] positioningInfos) implements Serializable
    {
        private static final long serialVersionUID = 1L;
    }
}

