/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.blacklisting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.teamscale.core.user.User;
import com.teamscale.index.blacklisting.EFindingBlacklistUpdateType;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.user.UserAliasLookup;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class UserResolvedFindingBlacklistInfo {
    @JsonUnwrapped
    private FindingBlacklistInfo info;
    @JsonProperty(value="resolvedUser")
    private @Nullable User resolvedUser;
    @JsonProperty(value="resolvedApprover")
    private @Nullable User resolvedApprover;
    @JsonProperty(value="updateType")
    private EFindingBlacklistUpdateType updateType = EFindingBlacklistUpdateType.ADD;

    public UserResolvedFindingBlacklistInfo(FindingBlacklistInfo info, EFindingBlacklistUpdateType updateType, UserAliasLookup userAliasLookup) {
        this.info = info;
        this.resolvedUser = userAliasLookup.resolveUser(info.getUser()).orElse(null);
        this.resolvedApprover = UserResolvedFindingBlacklistInfo.getResolvedApprover(info, userAliasLookup);
        this.updateType = updateType;
    }

    private static User getResolvedApprover(FindingBlacklistInfo info, UserAliasLookup userAliasLookup) {
        FindingBlacklistInfo.IApprovalState iApprovalState = info.getApprovalState();
        if (iApprovalState instanceof FindingBlacklistInfo.IApprovalState.IResolvedState) {
            FindingBlacklistInfo.IApprovalState.IResolvedState resolvedState = (FindingBlacklistInfo.IApprovalState.IResolvedState)iApprovalState;
            return userAliasLookup.resolveUser(resolvedState.by()).orElse(null);
        }
        return null;
    }

    @VisibleForTesting
    public UserResolvedFindingBlacklistInfo() {
    }

    @VisibleForTesting
    public UserResolvedFindingBlacklistInfo(FindingBlacklistInfo info) {
        this.info = info;
    }

    public User getResolvedUser() {
        return this.resolvedUser;
    }

    public FindingBlacklistInfo getInfo() {
        return this.info;
    }
}

