/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change;

import com.teamscale.index.code_change.ChangeRegion;
import com.teamscale.index.code_change.ChangeRegions;
import com.teamscale.index.code_change.LineBasedChangeRegion;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class CodeChangeUtils {
    public static List<LineBasedChangeRegion> filterAndConvertToLineRegions(ChangeRegions changes, String text, long baselineTimestamp) {
        LineOffsetConverter lineOffsetConverter = new LineOffsetConverter(text);
        ArrayList<LineBasedChangeRegion> result = new ArrayList<LineBasedChangeRegion>();
        for (ChangeRegion change : changes.getRegions()) {
            if (baselineTimestamp != -1L && baselineTimestamp >= change.getLastChangeTimestamp()) continue;
            result.add(CodeChangeUtils.convertToLineRegion(change, lineOffsetConverter));
        }
        return result;
    }

    private static LineBasedChangeRegion convertToLineRegion(ChangeRegion changeRegion, LineOffsetConverter lineOffsetConverter) {
        int startLine = lineOffsetConverter.getLine(changeRegion.getStart());
        int endLine = lineOffsetConverter.getLine(changeRegion.getEnd());
        return new LineBasedChangeRegion(startLine, endLine, changeRegion.getLastChangeTimestamp());
    }
}

