/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change.refactoring_detection;

import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.conqat.lib.commons.algo.Diff;
import org.conqat.lib.commons.collections.PairList;

public class MethodRefactoringDetectionUtils {
    private static final int NO_MATCH = -1;

    public static void filterAddedAndModifiedLinesFromDelta(Diff.Delta<ShallowEntity> delta, PairList<ShallowEntity, Boolean> addedOrRemoved, PairList<ShallowEntity, ShallowEntity> modified) {
        HashSet<ShallowEntity> matchedEntities = new HashSet<ShallowEntity>();
        int linesAddedWithoutCorrespondingDeletion = 0;
        for (int i = 0; i < delta.getSize(); ++i) {
            int matchPos;
            boolean currentDeltaItemIsOnLeftSide;
            boolean bl = currentDeltaItemIsOnLeftSide = delta.getPosition(i) < 0;
            if (currentDeltaItemIsOnLeftSide && (matchPos = MethodRefactoringDetectionUtils.matchRemovedShallowEntityWithCounterpart(delta, i, matchedEntities, linesAddedWithoutCorrespondingDeletion)) != -1) {
                modified.add((Object)((ShallowEntity)delta.getT(i)), (Object)((ShallowEntity)delta.getT(matchPos)));
                matchedEntities.add((ShallowEntity)delta.getT(matchPos));
                continue;
            }
            if (matchedEntities.contains(delta.getT(i))) continue;
            linesAddedWithoutCorrespondingDeletion = currentDeltaItemIsOnLeftSide ? ++linesAddedWithoutCorrespondingDeletion : --linesAddedWithoutCorrespondingDeletion;
            addedOrRemoved.add((Object)((ShallowEntity)delta.getT(i)), (Object)currentDeltaItemIsOnLeftSide);
            matchedEntities.add((ShallowEntity)delta.getT(i));
        }
    }

    private static int matchRemovedShallowEntityWithCounterpart(Diff.Delta<ShallowEntity> delta, int currentIndex, Set<ShallowEntity> matched, int linesAddedWithoutCorrespondingDeletion) {
        int matchIndex;
        for (matchIndex = currentIndex + 1; matchIndex < delta.getSize() && MethodRefactoringDetectionUtils.areCounterpartsDeletions(delta, matchIndex); ++matchIndex) {
        }
        while (matchIndex < delta.getSize() && !MethodRefactoringDetectionUtils.areCounterpartsDeletions(delta, matchIndex)) {
            if (MethodRefactoringDetectionUtils.areEntitiesOnCorrespondingPositions(delta, currentIndex, linesAddedWithoutCorrespondingDeletion, matchIndex) && MethodRefactoringDetectionUtils.shallowEntitiesEqual((ShallowEntity)delta.getT(currentIndex), (ShallowEntity)delta.getT(matchIndex))) {
                return matchIndex;
            }
            if (!matched.contains(delta.getT(matchIndex))) {
                --linesAddedWithoutCorrespondingDeletion;
            }
            ++matchIndex;
        }
        return -1;
    }

    private static boolean areEntitiesOnCorrespondingPositions(Diff.Delta<ShallowEntity> delta, int currentIndex, int linesAddedWithoutCorrespondingDeletion, int matchIndex) {
        return -delta.getPosition(currentIndex) == delta.getPosition(matchIndex) + linesAddedWithoutCorrespondingDeletion;
    }

    private static boolean areCounterpartsDeletions(Diff.Delta<ShallowEntity> delta, int matchIndex) {
        return delta.getPosition(matchIndex) < 0;
    }

    private static boolean shallowEntitiesEqual(ShallowEntity firstEntity, ShallowEntity secondEntity) {
        return Objects.equals(firstEntity.getType(), secondEntity.getType()) && Objects.equals(firstEntity.getSubtype(), secondEntity.getSubtype()) && Objects.equals(firstEntity.getName(), secondEntity.getName());
    }
}

