/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import com.teamscale.index.comment_analysis.AstPositionCalculator;
import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.comment_analysis.classification.MethodFinder;
import com.teamscale.index.comment_analysis.utils.CommentTaggingUtils;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class CommentExtractor {
    public static List<Comment> extractComments(List<IToken> tokens, TokenElementInfo element, boolean removeCommentTags) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        UnmodifiableList<ShallowEntity> entities = element.getShallowEntitiesWithoutPreprocessorTokens();
        MethodFinder methodFinder = new MethodFinder((List<ShallowEntity>)entities, tokens);
        for (int i = 0; i < tokens.size(); ++i) {
            if (tokens.get(i).getType().getTokenClass() != ETokenType.ETokenClass.COMMENT) continue;
            comments.add(CommentExtractor.createComment(tokens, entities, element, i, methodFinder, removeCommentTags));
        }
        return comments;
    }

    private static Comment createComment(List<IToken> tokens, List<ShallowEntity> entities, TokenElementInfo element, int position, MethodFinder methodFinder, boolean removeCommentTags) {
        AstPositionCalculator.EAstPosition astPosition = AstPositionCalculator.getAstPosition(tokens.get(position), entities);
        String text = tokens.get(position).getText();
        if (removeCommentTags) {
            text = CommentTaggingUtils.removeTags(text);
        }
        return new Comment(text, position, astPosition, element.getUniformPath(), tokens, methodFinder);
    }
}

