/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.index.resource.CodeScopesMappingIndex;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class CodeScopeUtils {
    public static <T extends BasicTokenElementInfo> CodeScopeAware<List<@NonNull T>> groupElementsByCodeScope(List<T> elements) {
        return CodeScopeUtils.groupElementsByCodeScope(elements, ArrayList::new);
    }

    public static <T extends BasicTokenElementInfo> CodeScopeAware<Set<@NonNull T>> groupElementsByCodeScope(Set<T> elements) {
        return CodeScopeUtils.groupElementsByCodeScope(elements, HashSet::new);
    }

    public static <T extends BasicTokenElementInfo, I extends Collection<T>, O extends Collection<T>> CodeScopeAware<O> groupElementsByCodeScope(I elements, Supplier<O> emptyCollectionSupplier) {
        CodeScopeAware elementsPerCodeScope = CodeScopeAware.empty();
        for (BasicTokenElementInfo element : elements) {
            CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(element);
            if (!elementsPerCodeScope.contains(codeScopeName)) {
                elementsPerCodeScope.setValue(codeScopeName, (Object)((Collection)emptyCollectionSupplier.get()));
            }
            ((Collection)elementsPerCodeScope.getValue(codeScopeName)).add(element);
        }
        return elementsPerCodeScope;
    }

    public static @NonNull Set<CodeScopeName> determineRelevantCodeScopeNames(List<? extends BasicTokenElementInfo> elementInfos) {
        HashSet<CodeScopeName> set = new HashSet<CodeScopeName>();
        for (BasicTokenElementInfo basicTokenElementInfo : elementInfos) {
            set.add(CodeScopeDetail.getCodeScopeNameFromTokenElement(basicTokenElementInfo));
        }
        return set;
    }

    public static boolean isMetricEnabled(CodeScopeAware<MetricDescriptor> metricPerCodeScope) {
        return metricPerCodeScope.getValues().stream().anyMatch(MetricDescriptor::isMetricEnabled);
    }

    public static @NonNull Set<CodeScopeName> getCodeScopesWithDisabledMetric(CodeScopeAware<MetricDescriptor> metricDescriptor) {
        HashSet<CodeScopeName> codeScopesWithDisabledMetric = new HashSet<CodeScopeName>();
        metricDescriptor.forEach(metricDescriptorByCodeScopeName -> {
            if (!((MetricDescriptor)metricDescriptorByCodeScopeName.getValue()).isMetricEnabled()) {
                codeScopesWithDisabledMetric.add((CodeScopeName)metricDescriptorByCodeScopeName.getKey());
            }
        });
        return codeScopesWithDisabledMetric;
    }

    public static boolean isOptionEnabled(CodeScopeAware<Boolean> optionPerCodeScope) {
        return optionPerCodeScope.getValues().stream().anyMatch(Boolean::booleanValue);
    }

    public static <T> Map<String, T> getValuesForPaths(Collection<String> uniformPaths, CodeScopesMappingIndex codeScopesMappingIndex, CodeScopeAware<T> valuesPerCodeScope) throws StorageException {
        Map uniformPathMap = UniformPathCompatibilityUtil.createPathMapping(uniformPaths);
        Map<UniformPath, CodeScopeName> codeScopeMappings = codeScopesMappingIndex.getMappings(uniformPathMap.keySet());
        return codeScopeMappings.entrySet().stream().collect(Collectors.toMap(entry -> (String)uniformPathMap.get(entry.getKey()), entry -> valuesPerCodeScope.getValue((CodeScopeName)entry.getValue())));
    }
}

