/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.log.parse.ParseLogIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryIndexSynchronizer;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.source.IMetricSource;
import com.teamscale.core.metrics.source.IndexMetricSource;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.index.abap.AbapFileMetadataSynchronizer;
import com.teamscale.index.architecture.external.ArchitectureUploadAnalysisStateIndex;
import com.teamscale.index.architecture.external.ExternalArchitectureUploadIndex;
import com.teamscale.index.audit.analysis.xclones.ExternalXCloneIndex;
import com.teamscale.index.baseline.BaselineIndex;
import com.teamscale.index.blacklisting.BlacklistAwareMetricSynchronizer;
import com.teamscale.index.blacklisting.BranchAgnosticFindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistChangePersister;
import com.teamscale.index.blacklisting.FindingBlacklistChangeRetriever;
import com.teamscale.index.blacklisting.FindingBlacklistCommitIndexSynchronizer;
import com.teamscale.index.blacklisting.FindingBlacklistCommitsIndex;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistStagingIndex;
import com.teamscale.index.blacklisting.FindingsBlacklistMerger;
import com.teamscale.index.code_change.CodeChangeIndex;
import com.teamscale.index.code_change.CodeChangeIndexSynchronizer;
import com.teamscale.index.commit_alert.CommitAlertIndex;
import com.teamscale.index.dependencies.ExternalDependencyIndex;
import com.teamscale.index.dependencies.TypeDeltaIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.external.ExternalAnalysisDeletionIndex;
import com.teamscale.index.external.ExternalAnalysisPartitionIndex;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.external.update.ExternalAnalysisResultsChangeRetriever;
import com.teamscale.index.external.update.ExternalAnalysisResultsPersister;
import com.teamscale.index.external.update.ExternalAnalysisResultsUpdater;
import com.teamscale.index.external.update.ExternalMetricsLastUpdateIndex;
import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.external.update.ExternalUploadChangeRetrieverBase;
import com.teamscale.index.findings.cross_file_analysis.CrossFileAnalysisFindingsIndex;
import com.teamscale.index.findings.cross_file_analysis.CrossFileFindingsSynchronizer;
import com.teamscale.index.findings.sonarlint.analysis_step.SonarLintFindingCacheProjectIndex;
import com.teamscale.index.issue_reference.IssueReferenceIndex;
import com.teamscale.index.issue_reference.SpecItemCodeReferenceIndex;
import com.teamscale.index.issues.IssueHistoryIndex;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.issues.IssueUnmanagedKeysHistoryIndex;
import com.teamscale.index.issues.IssueUnmanagedKeysSynchronizer;
import com.teamscale.index.merge_request.MergeBaseCacheIndex;
import com.teamscale.index.metadata.TokenElementMetadataIndex;
import com.teamscale.index.notifications.NotificationTrigger;
import com.teamscale.index.portfolio.PortfolioManualAssessmentIndex;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.report.AnalysisReportIntegrator;
import com.teamscale.index.report.AnalysisReportPersister;
import com.teamscale.index.report.CompileCommandIntegrator;
import com.teamscale.index.report.ParsedReportIndex;
import com.teamscale.index.report.ReportResultByCodePathIndex;
import com.teamscale.index.report.UsageDataReportIntegrator;
import com.teamscale.index.repository.RepositoryLogFileIndexSynchronizer;
import com.teamscale.index.repository.artifact_store.ArtifactStoreContentUpdaterBase;
import com.teamscale.index.repository.tfs.UniformPathCasingIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemHistoryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemLatestRevisionCacheIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemUnmanagedKeysHistoryIndex;
import com.teamscale.index.resource.ContainerIndexSynchronizer;
import com.teamscale.index.resource.ExternalAnalysisReportArchiveIndex;
import com.teamscale.index.resource.SimulinkDataDictionaryIndex;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import com.teamscale.index.resource.SimulinkSignalLabelIndex;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.index.search.CodeSearchIndex;
import com.teamscale.index.search.CodeSearchIndexInverter;
import com.teamscale.index.search.CodeSearchSynchronizer;
import com.teamscale.index.search.InvertedCodeSearchIndex;
import com.teamscale.index.simulink.content.SimulinkFileSynchronizer;
import com.teamscale.index.simulink.signal_type.SimulinkOutputDataTypeExtractionStep;
import com.teamscale.index.simulink.signal_type.SimulinkOutputDataTypeIndex;
import com.teamscale.index.simulink.signal_type.dimensions.SimulinkDimensionalityIndex;
import com.teamscale.index.simulink.subsystems.SimulinkFileReferenceIndex;
import com.teamscale.index.simulink.tracing.DerivedTestCoverageIndex;
import com.teamscale.index.simulink.tracing.SimulinkGeneratedCodeCoverageSynchronizer;
import com.teamscale.index.simulink.tracing.SimulinkGeneratedCodeFindingsSynchronizer;
import com.teamscale.index.simulink.tracing.SimulinkPlcCoderTraceIndex;
import com.teamscale.index.simulink.tracing.TracelinkAbbreviationIndex;
import com.teamscale.index.simulink.tracing.TracelinkAbbreviationIndexSynchronizer;
import com.teamscale.index.task.TaskIndex;
import com.teamscale.index.testcoverage.LineCoverageIndex;
import com.teamscale.index.testcoverage.ProbeCoverageIndex;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testimpact.PrioritizedTestListIndex;
import com.teamscale.index.testimpact.TestListIndex;
import com.teamscale.index.testimpact.TestMinimizationJobOptionsIndex;
import com.teamscale.index.testimpact.TestMinimizationJobsIndex;
import com.teamscale.index.tests.SpecItemTestReferenceIndex;
import com.teamscale.index.tests.TestExecutionDeltaIndex;
import com.teamscale.index.tests.TestExecutionDeltaIndexSynchronizer;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionIndexes;
import com.teamscale.index.tests.TestHistoryIndex;
import com.teamscale.index.tests.TestImplementationPathToExecutionPathIndex;
import com.teamscale.index.tests.extractor.TestCaseExtractionSynchronizer;
import com.teamscale.index.tests.extractor.TestPathLookupIndex;
import com.teamscale.index.tracking.FindingsTracker;
import com.teamscale.index.tracking.index.FindingChurnCountIndex;
import com.teamscale.index.tracking.index.FindingChurnListIndex;
import com.teamscale.index.tracking.index.FindingIdentificationIndex;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.index.tracking.index.TrackedFindingsIndex;
import com.teamscale.index.usage.MethodUsageCountIndex;
import com.teamscale.index.user.UserRecentlyCommittedBranchesSynchronizer;
import com.teamscale.index.user.UserRecentlyInteractedBranchesIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.VisibleForTesting;

public class CoreConfiguration
extends AnalysisConfigurationBase {
    private static final String USAGE_ANALYSIS_ENABLED_OPTION_NAME = "Enable Method Usage Tracking";
    private static final String TEST_IDENTIFICATION_PATTERNS_OPTION_NAME = "Test identification patterns";
    @ConfigExposed(name="Enable search", description="Enables search in source code, commits and issues.", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private boolean searchEnabled = true;
    @ConfigExposed(name="Include all tokens in search", description="Includes all source code tokens in the search. Otherwise, search will be limited to comments, string literals, and method names.", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private boolean searchAllTokens = false;
    @ConfigExposed(name="Enable Simulink tracing", description="Enables support for tracing from generated code to simulink models.", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private boolean simulinkTracingEnabled = false;
    @ConfigExposed(name="Enable Method Usage Tracking", description="Enables usage tracking for methods (ABAP only).", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private boolean methodUsageAnalysisEnabled = false;
    @ConfigExposed(name="Test identification patterns", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="This enables to analyze tests implemented in a custom test framework, where the test entities can be detected via regular expressions in the code. A list of mappings from test properties to regular expressions should be provided. There must be at least one mapping for the test's name i.e. `Name -> @test: ID-(.*)`. The regular expressions are matched against the raw content of the file. The nearest function to the matched name is picked as the corresponding code entity. The left side of the mappings specifies the name of a test's property. The first capture group in the regular expression should match the value of the corresponding field.\nMake sure to escape reserved characters like '(', ')' or '.' as well as commas properly with the escape character '\\\\'. \nLines starting with '##' are ignored.", multilineText=true)
    private final PairList<String, String> testIdentifierPattern = new PairList();
    @VisibleForTesting
    public static final String DISABLE_PLAUSIBILITY_CHECK_FOR_PATH_MAPPING = "Disable covered lines plausibility check";
    private static final String DISABLE_PLAUSIBILITY_CHECK_FOR_PATH_MAPPING_DESCRIPTION = "Teamscale uses a heuristic to decide to which file within Teamscale a path within a coverage report is mapped to. The heuristic also considers the number of lines a file has compared to the lines hat are claimed to be covered in the coverage report. In some cases it is known that the line numbers reported by the coverage reporting tool are way larger than the actual lines within the files. Setting this option to true disables this heuristic within the path mapping.";
    @ConfigExposed(name="Disable covered lines plausibility check", description="Teamscale uses a heuristic to decide to which file within Teamscale a path within a coverage report is mapped to. The heuristic also considers the number of lines a file has compared to the lines hat are claimed to be covered in the coverage report. In some cases it is known that the line numbers reported by the coverage reporting tool are way larger than the actual lines within the files. Setting this option to true disables this heuristic within the path mapping.", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private boolean disablePlausibilityCheckForPathMapping = false;

    public CoreConfiguration() {
        this.autoExpose();
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        this.validateOptions();
        CoreConfiguration.configureTestExecutionSupport(proxy);
        CoreConfiguration.configureDependencySupport(proxy);
        CoreConfiguration.configureFindingSupport(proxy);
        CoreConfiguration.configureCodeChangeSupport(proxy);
        this.configureCodeSearch(proxy);
        CoreConfiguration.configureParseErrorLog(proxy);
        CoreConfiguration.configureExternalAnalysisSupport(proxy);
        CoreConfiguration.configureFindingBlacklistingSupport(proxy);
        CoreConfiguration.configureCoreIndexes(proxy);
        this.configureSimulinkSupport(proxy);
        CoreConfiguration.configureNotifications(proxy);
        this.configureReportSupport(proxy);
        CoreConfiguration.configureServiceSupportIndices(proxy);
        CoreConfiguration.configureAuditSupport(proxy);
        CoreConfiguration.configureIssueSupport(proxy);
        this.configureSpecItemSupport(proxy);
        CoreConfiguration.configureTestMinimizationSupport(proxy);
        CoreConfiguration.configureUserRecentActivitySupport(proxy);
        CoreConfiguration.configureMetadataSupport(proxy);
        CoreConfiguration.configureCrossFileFindingsAnalysisSupport(proxy);
    }

    private static void configureIssueSupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(IssueIndex.class);
        proxy.createProjectIndex(IssueHistoryIndex.class);
        proxy.createProjectIndex(IssueUnmanagedKeysHistoryIndex.class);
        proxy.createTrigger(new TriggerBuilder(IssueUnmanagedKeysSynchronizer.class));
    }

    private void validateOptions() throws ProjectConfigurationException {
        for (Pair pattern : this.testIdentifierPattern) {
            try {
                Pattern compiledPattern = Pattern.compile((String)pattern.getSecond());
                Matcher matcher = compiledPattern.matcher("");
                if (matcher.groupCount() >= 1) continue;
                throw new ProjectConfigurationException("The Test identification patterns contain an invalid pattern for " + (String)pattern.getFirst() + "! It needs to contain one capture group!");
            }
            catch (PatternSyntaxException e) {
                throw new ProjectConfigurationException("The Test identification patterns contain an invalid regex pattern for " + (String)pattern.getFirst() + "!", (Throwable)e);
            }
        }
    }

    private static void configureTestExecutionSupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(TestExecutionIndex.class);
        proxy.createProjectIndex(TestExecutionDeltaIndex.class);
        proxy.createProjectIndex(TestHistoryIndex.class);
        proxy.createProjectIndex(TestImplementationPathToExecutionPathIndex.class);
        proxy.createProjectIndex(SpecItemTestReferenceIndex.class);
        proxy.createProjectIndex(TestExecutionIndexes.TEST_EXECUTION_CONTENT_INDEX_TYPE, "test-executions-content");
        proxy.createProjectIndex(TestExecutionIndexes.TEST_EXECUTION_DIRECTORY_INDEX_TYPE, "test-execution-dir");
        proxy.createProjectIndex(TestExecutionIndexes.TEST_EXECUTION_METRICS_INDEX_TYPE, "test-execution-metrics");
        proxy.createProjectIndex(TestExecutionIndexes.TEST_EXECUTION_METRIC_SCHEMA_INDEX_TYPE, TestExecutionIndexes.TEST_EXECUTION_METRIC_SCHEMA_INDEX_NAME);
        proxy.createProjectIndex(TestExecutionIndexes.TEST_EXECUTION_METRICS_DIRECTORY_INDEX_TYPE, "test-execution-metrics-dir");
        proxy.createProjectIndex(TestExecutionIndexes.TEST_EXECUTION_METRICS_TREND_INDEX_TYPE, "test-execution-metric-trend");
        TriggerBuilder containerIndexSynchronizerTrigger = new TriggerBuilder(ContainerIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED).setCost(ETriggerCost.CHEAP);
        containerIndexSynchronizerTrigger.renameIndex("content", "test-executions-content");
        containerIndexSynchronizerTrigger.renameIndex("dir", "test-execution-dir");
        proxy.createTrigger(containerIndexSynchronizerTrigger, "test-execution");
        TriggerBuilder testExecutionDirSynchronizer = new TriggerBuilder(MetricDirectoryIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED);
        testExecutionDirSynchronizer.renameIndex("metrics", "test-execution-metrics");
        testExecutionDirSynchronizer.renameIndex("metrics-dir", "test-execution-metrics-dir");
        testExecutionDirSynchronizer.renameIndex("metric-trend", "test-execution-metric-trend");
        testExecutionDirSynchronizer.renameIndex("metric-schema", TestExecutionIndexes.TEST_EXECUTION_METRIC_SCHEMA_INDEX_NAME);
        testExecutionDirSynchronizer.setTriggerParameter("use-hidden-metrics-index", false);
        testExecutionDirSynchronizer.setCost(ETriggerCost.CHEAP);
        proxy.createTrigger(testExecutionDirSynchronizer, "test-execution");
        proxy.createTrigger(new TriggerBuilder(TestExecutionDeltaIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        CoreConfiguration.configureTestExecutionMetrics(proxy.getTestExecutionMetricsSchema());
    }

    private static void configureTestExecutionMetrics(MetricSchemaProxy schema) throws ProjectConfigurationException {
        schema.addMetric("count", schema.createMetricIndexSource("count"), "Count", "The number of test cases", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[]{EMetricProperty.SIZE_METRIC, EMetricProperty.LOW_IS_BAD});
        schema.addMetric("failed", schema.createMetricIndexSource("failed"), "Failed", "The number of failed tests", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[0]);
        schema.addMetric("skipped", schema.createMetricIndexSource("skipped"), "Skipped/Ignored", "The number of skipped tests", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[0]);
        schema.addMetric("successful", schema.createMetricIndexSource("successful"), "Successful", "The number of successful tests", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[0]);
        schema.addMetric("inconclusive", schema.createMetricIndexSource("inconclusive"), "Inconclusive", "The number of inconclusive tests", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[0]);
        schema.addMetric("result", schema.createMetricIndexSource("result"), "Result", "The result of this test execution", EMetricValueType.ASSESSMENT, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[]{EMetricProperty.EMPTY_ASSESSMENT_IS_NEUTRAL});
        schema.addMetric("duration", schema.createMetricIndexSource("duration"), "Duration", "The duration of this test execution", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[]{EMetricProperty.SIZE_METRIC});
    }

    private static void configureTestMinimizationSupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(TestMinimizationJobsIndex.class);
        proxy.createProjectIndex(TestMinimizationJobOptionsIndex.class);
        proxy.createProjectIndex(PrioritizedTestListIndex.class);
    }

    private static void configureAuditSupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(ExternalXCloneIndex.class);
    }

    private static void configureNotifications(ProjectCreationProxy proxy) {
        proxy.addPostRevisionAnalysisTrigger(EAnalysisState.LIVE_ANALYSIS, NotificationTrigger.class);
        proxy.addPostRevisionAnalysisTrigger(EAnalysisState.CATCHUP_LIVE_ANALYSIS, NotificationTrigger.class);
    }

    private static void configureDependencySupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(TypeIndex.class);
        proxy.createProjectIndex(TypeDeltaIndex.class);
    }

    private static void configureCoreIndexes(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(LineCoverageIndex.class);
        proxy.createProjectIndex(ProbeCoverageIndex.class);
        proxy.createProjectIndex(UniformPathCasingIndex.class);
        proxy.createProjectIndex(TaskIndex.class);
        proxy.createProjectIndex(BaselineIndex.class);
        proxy.createProjectIndex(ProjectOptionIndex.class);
        proxy.createProjectIndex(CommitAlertIndex.class);
        proxy.createProjectIndex(MetricsToArchitectureMetricsMappingIndex.class);
        proxy.createProjectIndex(ExternalArchitectureUploadIndex.class);
        proxy.createProjectIndex(ArchitectureUploadAnalysisStateIndex.class);
        proxy.createProjectIndex(MethodUsageCountIndex.class);
        proxy.createProjectIndex(TestPathLookupIndex.class);
        proxy.createProjectIndex(SimulinkOutputDataTypeIndex.class);
        proxy.createProjectIndex(SimulinkDimensionalityIndex.class);
        proxy.createProjectIndex(SimulinkSignalLabelIndex.class);
        proxy.createProjectIndex(SimulinkDataDictionaryIndex.class);
        proxy.createProjectIndex(SimulinkFileReferenceIndex.class);
        proxy.createProjectIndex(TestListIndex.class);
        proxy.createProjectIndex(TokenElementMetadataIndex.class);
        proxy.createProjectIndex(PortfolioManualAssessmentIndex.class);
        for (StoredQueryIndex.EStoredQueryType storedQueryType : StoredQueryIndex.EStoredQueryType.values()) {
            proxy.createProjectIndex(StoredQueryIndex.class, storedQueryType.getIndexName());
        }
    }

    private void configureSpecItemSupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(SpecItemCodeReferenceIndex.class);
        proxy.createProjectIndex(IssueReferenceIndex.class);
        proxy.createProjectIndex(SpecItemIndex.class);
        proxy.createProjectIndex(SpecItemHistoryIndex.class);
        proxy.createProjectIndex(SpecItemUnmanagedKeysHistoryIndex.class);
        proxy.createProjectIndex(SpecItemLatestRevisionCacheIndex.class);
        this.createTestExtractionTrigger(proxy);
    }

    private static void configureServiceSupportIndices(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(MergeBaseCacheIndex.class);
    }

    private static void configureParseErrorLog(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(ParseLogIndex.class);
    }

    private void configureCodeSearch(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(CodeSearchIndex.class);
        proxy.createProjectIndex(InvertedCodeSearchIndex.class);
        if (this.searchEnabled) {
            proxy.createTrigger(new TriggerBuilder(CodeSearchSynchronizer.class, ETriggerConcurrency.PARALLEL).setTriggerParameter("index-all-tokens", this.searchAllTokens));
            proxy.createTrigger(new TriggerBuilder(CodeSearchIndexInverter.class, ETriggerConcurrency.OUTPUT_ISOLATED).setCost(ETriggerCost.EXPENSIVE));
        }
    }

    private void createTestExtractionTrigger(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        TriggerBuilder trigger = new TriggerBuilder(TestCaseExtractionSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED);
        trigger.setTriggerParameter("custom-framework-test-detection-patterns", ITriggerParameter.of(this.testIdentifierPattern));
        proxy.createTrigger(trigger);
    }

    private static void configureFindingSupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(TrackedFindingsIndex.class);
        proxy.createProjectIndex(TrackedFindingsByIdIndex.class);
        proxy.createProjectIndex(FindingChurnListIndex.class);
        proxy.createProjectIndex(FindingChurnCountIndex.class);
        proxy.createProjectIndex(FindingIdentificationIndex.class);
        proxy.createProjectIndex(SonarLintFindingCacheProjectIndex.class);
        proxy.createTrigger(new TriggerBuilder(FindingsTracker.class, ETriggerConcurrency.OUTPUT_ISOLATED).setCost(ETriggerCost.EXPENSIVE));
    }

    private static void configureCodeChangeSupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(CodeChangeIndex.class);
        proxy.createProjectIndex(MethodInfoIndex.class);
        proxy.createTrigger(new TriggerBuilder(CodeChangeIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED).setCost(ETriggerCost.EXPENSIVE));
    }

    private static void configureExternalAnalysisSupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(ExternalAnalysisImportSessionIndex.class);
        proxy.createProjectIndex(ExternalAnalysisResultIndex.class);
        proxy.createProjectIndex(ExternalAnalysisPartitionIndex.class);
        proxy.createProjectIndex(ExternalAnalysisDeletionIndex.class);
        proxy.createProjectIndex(ExternalAnalysisStatusIndex.class);
        proxy.createProjectIndex(ExternalAnalysisReportArchiveIndex.class);
        proxy.createProjectIndex(ExternalResultsPartitionLastUpdateIndex.class);
        proxy.createProjectIndex(ExternalMetricsLastUpdateIndex.class);
        proxy.createProjectIndex(CommitTreeIndex.class, "external-analysis-commit-tree");
        proxy.createProjectIndex(SimulinkPlcCoderTraceIndex.class);
        TriggerBuilder externalAnalysisResultsChangeRetrieverTriggerBuilder = ExternalUploadChangeRetrieverBase.configurePeriodicTrigger(ExternalAnalysisResultsChangeRetriever.class);
        proxy.createTrigger(externalAnalysisResultsChangeRetrieverTriggerBuilder);
        proxy.addPostBuildCompletenessAnalysisTrigger(externalAnalysisResultsChangeRetrieverTriggerBuilder);
        proxy.createProjectIndex(ExternalDependencyIndex.class);
        proxy.createTrigger(new TriggerBuilder(ExternalAnalysisResultsPersister.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(ExternalAnalysisResultsUpdater.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(RepositoryLogFileIndexSynchronizer.class, ETriggerConcurrency.PARALLEL));
    }

    private static void configureFindingBlacklistingSupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(FindingBlacklistIndex.class);
        proxy.createProjectIndex(FindingBlacklistCommitsIndex.class);
        proxy.createProjectIndex(FindingBlacklistStagingIndex.class);
        proxy.createProjectIndex(CommitTreeIndex.class, "finding-blacklist-commit-tree");
        proxy.createProjectIndex(BranchAgnosticFindingBlacklistIndex.class);
        TriggerBuilder findingsBlacklistChangeRetrieverTriggerBuilder = ExternalUploadChangeRetrieverBase.configurePeriodicTrigger(FindingBlacklistChangeRetriever.class);
        proxy.createTrigger(findingsBlacklistChangeRetrieverTriggerBuilder);
        proxy.addPostBuildCompletenessAnalysisTrigger(findingsBlacklistChangeRetrieverTriggerBuilder);
        proxy.createTrigger(new TriggerBuilder(FindingBlacklistChangePersister.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(FindingsBlacklistMerger.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(BlacklistAwareMetricSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        proxy.createTrigger(new TriggerBuilder(FindingBlacklistCommitIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
    }

    private void configureSimulinkSupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(SimulinkModelInfoIndex.class);
        proxy.createProjectIndex(SimulinkDataDictionaryIndex.class);
        proxy.createProjectIndex(SimulinkFileReferenceIndex.class);
        proxy.createProjectIndex(DerivedTestCoverageIndex.class);
        if (!proxy.getAllConfiguredLanguages().contains(ELanguage.SIMULINK)) {
            return;
        }
        proxy.createTrigger(new TriggerBuilder(SimulinkFileSynchronizer.class, ETriggerConcurrency.PARALLEL));
        if (this.simulinkTracingEnabled) {
            proxy.createProjectIndex(TracelinkAbbreviationIndex.class);
            proxy.createTrigger(new TriggerBuilder(TracelinkAbbreviationIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
            proxy.createTrigger(new TriggerBuilder(SimulinkGeneratedCodeFindingsSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
            proxy.createTrigger(new TriggerBuilder(SimulinkGeneratedCodeCoverageSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
            CoreConfiguration.addModelCoverageMetrics(proxy.getCodeMetricSchema());
        }
        proxy.createProjectIndex(SimulinkOutputDataTypeIndex.class);
        proxy.createProjectIndex(SimulinkDimensionalityIndex.class);
        proxy.createProjectIndex(SimulinkSignalLabelIndex.class);
        proxy.createTrigger(new TriggerBuilder(SimulinkOutputDataTypeExtractionStep.class));
    }

    private static void addModelCoverageMetrics(MetricSchemaProxy schema) throws ProjectConfigurationException {
        schema.addMetric("model-coverable-lines", (IMetricSource)new IndexMetricSource("model-coverable-lines"), "Model Coverable Lines", "internal", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[]{EMetricProperty.HIDDEN});
        schema.addMetric("model-covered-lines", (IMetricSource)new IndexMetricSource("model-covered-lines"), "Model Covered Lines", "internal", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[]{EMetricProperty.HIDDEN});
        schema.addMetric("model-line-coverage", schema.createDivisionMetricSource("model-covered-lines", "model-coverable-lines", 0.0, Collections.emptySet()), "Model Line Coverage", "The line coverage of the model determined from test coverage of generated code.", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.NONE, new EMetricProperty[]{EMetricProperty.RATIO_METRIC, EMetricProperty.LOW_IS_BAD});
    }

    private void configureReportSupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(ParsedReportIndex.class);
        proxy.createProjectIndex(ReportResultByCodePathIndex.class);
        proxy.createProjectIndex(ArtifactStoreContentUpdaterBase.ReportCommitDeltaIndex.class);
        if (this.methodUsageAnalysisEnabled) {
            proxy.createTrigger(new TriggerBuilder(UsageDataReportIntegrator.class, ETriggerConcurrency.PARALLEL));
        }
        proxy.createTrigger(new TriggerBuilder(CompileCommandIntegrator.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(AnalysisReportPersister.class));
        TriggerBuilder analysisReportIntegratorTriggerBuilder = new TriggerBuilder(AnalysisReportIntegrator.class, ETriggerConcurrency.PARALLEL).setTriggerParameter("disable-plausibility-check", this.disablePlausibilityCheckForPathMapping).setCost(ETriggerCost.EXPENSIVE);
        proxy.createTrigger(analysisReportIntegratorTriggerBuilder);
    }

    private static void configureUserRecentActivitySupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(UserRecentlyInteractedBranchesIndex.class);
        proxy.createTrigger(new TriggerBuilder(UserRecentlyCommittedBranchesSynchronizer.class, ETriggerConcurrency.PARALLEL));
    }

    private static void configureMetadataSupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        if (proxy.getAllConfiguredLanguages().stream().anyMatch(LanguageGroups.SAP_LANGUAGES::contains)) {
            proxy.createTrigger(new TriggerBuilder(AbapFileMetadataSynchronizer.class, ETriggerConcurrency.PARALLEL));
        }
    }

    private static void configureCrossFileFindingsAnalysisSupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(CrossFileAnalysisFindingsIndex.class);
        proxy.createTrigger(new TriggerBuilder(CrossFileFindingsSynchronizer.class, ETriggerConcurrency.PARALLEL));
    }

    public boolean isCoreConfiguration() {
        return true;
    }

    public List<Class<? extends AnalysisConfigurationBase>> getRequiredConfigurations() {
        return List.of(com.teamscale.core.runtime.impl.analysis.CoreConfiguration.class);
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
        template.registerGlobalOption(this.getOptionForField("searchEnabled"));
        template.registerGlobalOption(this.getOptionForField("searchAllTokens"));
        template.registerGlobalOption(this.getOptionForField("testIdentifierPattern"));
        if (!languages.isEmpty()) {
            template.registerConfigurationItems("Test Coverage", "Testing", List.of(this.getOptionForField("disablePlausibilityCheckForPathMapping")));
        }
        if (languages.contains(ELanguage.SIMULINK)) {
            template.registerGlobalOption(this.getOptionForField("simulinkTracingEnabled"));
        }
        if (languages.contains(ELanguage.ABAP)) {
            template.registerGlobalOption(this.getOptionForField("methodUsageAnalysisEnabled"));
        }
    }

    public static boolean hasDisabledImplausibleLinesCheck(ProjectStorageSystem projectStorageSystem) throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((ProjectStorageSystem)projectStorageSystem);
        if (projectConfiguration == null) {
            return false;
        }
        AnalysisProfile embeddedProfile = projectConfiguration.getEmbeddedDefaultProfile();
        CCSMAssert.isNotNull((Object)embeddedProfile, (String)"Embedded profile must not be null");
        AnalysisGroup testCoverageGroup = embeddedProfile.getGroup("Test Coverage");
        if (testCoverageGroup == null) {
            return false;
        }
        String optionValue = testCoverageGroup.getOptionValue(DISABLE_PLAUSIBILITY_CHECK_FOR_PATH_MAPPING);
        return Boolean.parseBoolean(optionValue);
    }
}

