/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.index.MetricThresholdConfigurationIndex;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.TeamscaleVersionContainer;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.configuration.ProjectValidationUtils;
import com.teamscale.index.configuration.service.EMetricThresholdConfigurationVersion;
import jakarta.ws.rs.ForbiddenException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class MetricThresholdConfigurationUtils {
    static MetricThresholdConfiguration parseAndMigrateThresholdConfiguration(byte[] xmlContent) throws MigrationException {
        return (MetricThresholdConfiguration)TeamscaleVersionContainer.fromJson((byte[])xmlContent, null, MetricThresholdConfiguration.class, (Enum)EMetricThresholdConfigurationVersion.CURRENT_VERSION, (String)"metric threshold configuration");
    }

    public static MetricThresholdConfiguration createMetricThresholdConfiguration(byte[] data, MetricThresholdConfigurationIndex metricThresholdIndex, @Nullable ServicePermissions permissions, boolean validate, GlobalStorageSystem globalStorageSystem) throws MigrationException {
        MetricThresholdConfiguration metricThresholdConfiguration = MetricThresholdConfigurationUtils.parseAndMigrateThresholdConfiguration(data);
        try {
            if (validate) {
                MetricThresholdConfigurationUtils.validateMetricThresholdConfiguration(metricThresholdConfiguration, metricThresholdIndex, globalStorageSystem);
            }
            if (permissions != null) {
                MetricThresholdConfiguration currentMetricThresholdConfiguration = metricThresholdIndex.getConfigurationWithoutLoadingBaseConfiguration(metricThresholdConfiguration.getName());
                if (currentMetricThresholdConfiguration == null) {
                    permissions.checkGlobalPermission(EGlobalPermission.CREATE_METRIC_THRESHOLD_CONFIGURATIONS);
                } else {
                    permissions.checkBasicPermission(EBasicPermissionScope.METRIC_THRESHOLD_CONFIGURATIONS, metricThresholdConfiguration.getName(), EBasicPermission.EDIT);
                }
            }
            metricThresholdIndex.setThresholdConfiguration(metricThresholdConfiguration);
            return metricThresholdConfiguration;
        }
        catch (MetricThresholdConfigurationException e) {
            throw new MigrationException("Configuration is invalid: " + e.getMessage(), (Throwable)e);
        }
        catch (StorageException e) {
            throw new MigrationException("Storage error during creation of metric threshold configuration: " + e.getMessage(), (Throwable)e);
        }
        catch (ForbiddenException e) {
            throw new MigrationException("Permission issues during creation of metric threshold configuration: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void validateMetricThresholdConfiguration(MetricThresholdConfiguration metricThresholdConfiguration, MetricThresholdConfigurationIndex metricThresholdIndex, GlobalStorageSystem globalStorageSystem) throws StorageException, MetricThresholdConfigurationException {
        metricThresholdIndex.loadBaseConfigurations(metricThresholdConfiguration);
        metricThresholdConfiguration.adjustAndValidateData();
        ProjectValidationUtils.validateMetricThresholdConfiguration(metricThresholdConfiguration, globalStorageSystem);
    }
}

