/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.index.configuration.ExternalAnalysisGroup;
import com.teamscale.index.configuration.ExternalFindingsDescription;
import com.teamscale.index.configuration.tools.message.ExternalAnalysisToolMessageManager;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;

public class ExternalAnalysisFindingsConfiguration
extends ToolConfigurationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<ExternalAnalysisGroup> groups = new ArrayList<ExternalAnalysisGroup>();
    private final EAnalysisTool externalAnalysisTool;
    private final ExternalFindingsGroupDescriptionIndex index;
    private final List<ExternalFindingsDescription> findingDescriptions;

    public ExternalAnalysisFindingsConfiguration(EAnalysisTool externalAnalysisTool, GlobalStorageSystem globalStorageSystem) throws ProjectConfigurationException {
        super(externalAnalysisTool, externalAnalysisTool.getReadableName());
        this.externalAnalysisTool = externalAnalysisTool;
        try {
            this.index = (ExternalFindingsGroupDescriptionIndex)globalStorageSystem.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
            this.readGroups();
            this.findingDescriptions = this.index.getDescriptions(externalAnalysisTool);
            ExternalAnalysisToolMessageManager.initializeMessageManagerFor(externalAnalysisTool, this.findingDescriptions);
        }
        catch (ConQATException e) {
            throw new ProjectConfigurationException((Throwable)e);
        }
    }

    private void readGroups() throws ConQATException {
        this.groups.addAll(this.index.getGroups(this.externalAnalysisTool));
    }

    private void registersGroupsAndDescriptions(List<ExternalFindingsDescription> descriptions, CodeScopeName codeScopeName) {
        for (ExternalFindingsDescription description : descriptions) {
            FindingDescriptor findingDescriptor = new FindingDescriptor(description.getTypeId(), description.getName(), this.externalAnalysisTool, EnumSet.allOf(ELanguage.class), description.getEnablement(), description.getDescription());
            Optional<ExternalAnalysisGroup> externalGroup = this.findMatchingGroup(description.getTypeId());
            if (externalGroup.isPresent()) {
                String groupDescriptor = this.getGroup(externalGroup.get().getGroupName());
                this.registerFinding(findingDescriptor, groupDescriptor, description.getTypeId(), codeScopeName);
                continue;
            }
            LOGGER.warn("No matching ExternalAnalysisGroup found for the ExternalFindingDescription type id " + description.getTypeId());
        }
    }

    private Optional<ExternalAnalysisGroup> findMatchingGroup(String findingId) {
        return ExternalAnalysisFindingsConfiguration.findMatchingGroup(this.groups, findingId);
    }

    private static Optional<ExternalAnalysisGroup> findMatchingGroup(List<ExternalAnalysisGroup> groups, String findingId) {
        return groups.stream().filter(group -> group.contains(findingId)).findFirst();
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        this.registersGroupsAndDescriptions(this.findingDescriptions, template.getCodeScope());
        super.registerQualityIndicators(template, languages, tools);
        for (ExternalAnalysisGroup group : this.groups) {
            String groupName = group.getGroupName();
            if (template.getAnalysisGroup(groupName) != null) continue;
            AnalysisGroupDescriptor analysisGroupDescriptor = new AnalysisGroupDescriptor(groupName, new ConfigurationItemBase[0]);
            template.registerAnalysisGroup(analysisGroupDescriptor);
        }
    }

    protected String determineQualityIndicator(String groupName, CodeScopeName codeScopeName) {
        return null;
    }
}

