/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.index.configuration.tools.AnalysisToolsConfigurationUtils;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.error.FormatException;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.system.SystemUtils;
import org.conqat.lib.commons.version.Version;
import org.jetbrains.annotations.VisibleForTesting;

public class NodeJsLinterUtils {
    @VisibleForTesting
    public static final String NODE_EXECUTABLE_UNIX = "node";
    @VisibleForTesting
    public static final String NODE_EXECUTABLE_WINDOWS = "node.exe";
    public static final String NODE_EXECUTABLE = SystemUtils.isWindows() ? "node.exe" : "node";

    public static NodeJsInfo getNodeJSFromSystem() throws ProjectConfigurationException {
        return NodeJsLinterUtils.getNodeJSFromSystem(NODE_EXECUTABLE);
    }

    @VisibleForTesting
    static NodeJsInfo getNodeJSFromSystem(String executable) throws ProjectConfigurationException {
        try {
            Predicate<ProcessUtils.ExecutionResult> availabilityPredicate = result -> result.getReturnCode() == 0 && result.getStdout().startsWith("v");
            ProcessUtils.ExecutionResult processResult = AnalysisToolsConfigurationUtils.checkProgramAvailability(executable, null, availabilityPredicate, false, false);
            Path nodeLocation = ProcessUtils.getLocationForExecutableOnPath((String)executable);
            return new NodeJsInfo(NodeJsLinterUtils.parseVersion(processResult.getStdout()), nodeLocation);
        }
        catch (ConQATException e) {
            throw new ProjectConfigurationException((Throwable)e);
        }
    }

    @VisibleForTesting
    static Version parseVersion(String versionString) throws ProjectConfigurationException {
        try {
            return Version.parseVersion((String)StringUtils.stripPrefix((String)StringUtils.emptyIfNull((String)versionString).trim(), (String)"v"));
        }
        catch (FormatException e) {
            throw new ProjectConfigurationException("Encountered unexpected Node.JS version string: %s".formatted(versionString), (Throwable)e);
        }
    }

    public record NodeJsInfo(Version version, Path nodeJsPath) {
    }
}

