/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.google.common.collect.ImmutableSet;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.index.configuration.tools.Rule;
import com.teamscale.index.report.parser.ESpCopSeverity;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.EnumSet;
import java.util.Set;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.resources.ResourceException;

public class SPCopConfiguration
extends ToolConfigurationBase {
    private static final Set<String> DISABLED_RULES = ImmutableSet.of((Object)"SPC042104", (Object)"SPC082101", (Object)"SPC150207", (Object)"SPC155501", (Object)"SPC155701", (Object)"SPC155702", (Object[])new String[]{"SPC155703", "SPC156101"});
    private static final Set<String> DISABLED_CATEGORIES = ImmutableSet.of((Object)"Customization", (Object)"Sandboxed Compatibility", (Object)"SharePoint 2007 Compatibility", (Object)"SharePoint 2010 Compatibility");
    private static final String SPCOP_RULES_JSON_FILE = "spcop/spcop-rules.json";

    public SPCopConfiguration() throws ProjectConfigurationException {
        super(EAnalysisTool.SPCOP, "SPCop", "SPCop");
        String resourceContent = Resource.of(SPCopConfiguration.class, (String)SPCOP_RULES_JSON_FILE).getContent();
        try {
            Rule[] rules;
            for (Rule rule : rules = (Rule[])JsonUtils.deserializeFromJsonWithNullCheck((String)resourceContent, Rule[].class)) {
                FindingDescriptor finding = new FindingDescriptor(rule.message, this.tool, EnumSet.of(ELanguage.XML), SPCopConfiguration.getEnablement(rule), rule.description);
                String findingsGroupName = rule.type + " (" + rule.id + ") [" + rule.severity + ", " + rule.category + "]";
                this.registerFinding(finding, this.getGroup(rule.category), findingsGroupName, CodeScopeAware.DEFAULT_CODE_SCOPE);
            }
        }
        catch (ConQATException | ResourceException e) {
            throw new ProjectConfigurationException(e);
        }
    }

    protected String determineQualityIndicator(String groupName, CodeScopeName codeScopeName) {
        if (DISABLED_CATEGORIES.contains(groupName)) {
            return null;
        }
        return super.determineQualityIndicator(groupName, codeScopeName);
    }

    private static EFindingEnablement getEnablement(Rule rule) {
        if (DISABLED_RULES.contains(rule.id)) {
            return EFindingEnablement.OFF;
        }
        ETrafficLightColor color = ((ESpCopSeverity)EnumUtils.valueOf(ESpCopSeverity.class, (String)rule.severity)).getColor();
        switch (color) {
            case RED: {
                return EFindingEnablement.RED;
            }
            case YELLOW: {
                return EFindingEnablement.YELLOW;
            }
        }
        throw new IllegalStateException("Unexpected color '" + String.valueOf(color) + "' for severity:" + rule.severity);
    }
}

