/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.configuration.tools.NodeJsLinterUtils;
import com.teamscale.index.configuration.tools.message.SonarLintMessageManager;
import com.teamscale.index.findings.sonarlint.SonarLintEnginePool;
import com.teamscale.index.findings.sonarlint.analysis_step.SonarLintAnalysisStep;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisPull;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisPush;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisSessionsIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CodeScopeName;

public class SonarLintConfiguration
extends ToolConfigurationBase {
    public static final String FINDING_CATEGORY = "sonarlint";
    public static final String SONARLINT_MAPPINGS_TSV = "message/sonarlint/check-mappings.tsv";
    public static final String SONARLINT_OPTIONS_TSV = "message/sonarlint/check-options.tsv";
    private static final String DESCRIPTIONS_PATH = "sonarlint";
    @ConfigExposed(name="SonarLint Java Source Level", description="The Java source code level to be used for the analysis with SonarLint. Format: 1.X or X for Java X, e.g. 1.8, or 8. More information can be found at https://docs.sonarqube.org/latest/analysis/languages/java/#header-4", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private CodeScopeAware<String> javaSourceLevel = CodeScopeAware.defaultCodeScopeWithValue((Object)"");

    public SonarLintConfiguration() throws ProjectConfigurationException, IllegalArgumentException {
        super(EAnalysisTool.SONAR_LINT, "sonarlint", "sonarlint", SONARLINT_MAPPINGS_TSV, SONARLINT_OPTIONS_TSV, "");
        this.declareCodeScopeAware();
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        CodeScopeAware activeChecksPerCodeScope = this.getActiveCheckPerCodeScope(proxy.getCodeScopeNames());
        if (activeChecksPerCodeScope == null) {
            return;
        }
        this.createTriggers(proxy, (CodeScopeAware<Collection<String>>)activeChecksPerCodeScope);
        super.configureProject(proxy);
    }

    public void validateTools() throws ProjectConfigurationException {
        NodeJsLinterUtils.NodeJsInfo nodeJsOnSystem;
        super.validateTools();
        Set checkIds = this.getActiveFindingGroupNamesForAllCodeScopes();
        if (checkIds.stream().noneMatch(checkId -> checkId.startsWith("javascript:S") || checkId.startsWith("typescript:S"))) {
            return;
        }
        try {
            nodeJsOnSystem = NodeJsLinterUtils.getNodeJSFromSystem();
        }
        catch (ProjectConfigurationException e) {
            throw new ProjectConfigurationException("Node.JS was not found on system's PATH. SonarLint for JavaScript / TypeScript requires Node.JS in version %s or higher".formatted(SonarLintEnginePool.REQUIRED_MIN_NODE_JS_VERSION_FOR_JS), (Throwable)e);
        }
        if (!nodeJsOnSystem.version().isGreaterOrEqual(SonarLintEnginePool.REQUIRED_MIN_NODE_JS_VERSION_FOR_JS)) {
            throw new ProjectConfigurationException("SonarLint for JavaScript/TypeScript requires Node.JS version " + String.valueOf(SonarLintEnginePool.REQUIRED_MIN_NODE_JS_VERSION_FOR_JS) + " or higher. The Node.JS version found on the system's PATH is " + String.valueOf(nodeJsOnSystem.version()));
        }
    }

    private void createTriggers(ProjectCreationProxy proxy, CodeScopeAware<Collection<String>> activeChecksPerCodeScope) throws ProjectConfigurationException {
        if (EFeatureToggle.ENABLE_INDEPENDENT_SONAR_LINT_ANALYSIS.isEnabled()) {
            this.createSonarLintIndependentAnalysisSteps(proxy, activeChecksPerCodeScope);
        } else {
            proxy.createTrigger(this.createSonarLintAnalysisStepBuilder(activeChecksPerCodeScope));
        }
    }

    private void createSonarLintIndependentAnalysisSteps(ProjectCreationProxy proxy, CodeScopeAware<Collection<String>> activeChecksPerCodeScope) throws ProjectConfigurationException {
        proxy.createProjectIndex(SonarLintIndependentAnalysisSessionsIndex.class);
        proxy.createTrigger(this.createPushTrigger(activeChecksPerCodeScope));
        proxy.createTrigger(SonarLintConfiguration.createPullTrigger());
    }

    private TriggerBuilder createPushTrigger(CodeScopeAware<Collection<String>> activeChecksPerCodeScope) {
        TriggerBuilder triggerBuilder = new TriggerBuilder(SonarLintIndependentAnalysisPush.class, ETriggerConcurrency.PARALLEL);
        this.addSonarLintAnalysisParameters(triggerBuilder, activeChecksPerCodeScope);
        return triggerBuilder;
    }

    private static TriggerBuilder createPullTrigger() {
        return new TriggerBuilder(SonarLintIndependentAnalysisPull.class, ETriggerConcurrency.PARALLEL);
    }

    private TriggerBuilder createSonarLintAnalysisStepBuilder(CodeScopeAware<Collection<String>> activeChecksPerCodeScope) {
        TriggerBuilder triggerBuilder = new TriggerBuilder(SonarLintAnalysisStep.class, ETriggerConcurrency.PARALLEL);
        this.addSonarLintAnalysisParameters(triggerBuilder, activeChecksPerCodeScope);
        return triggerBuilder;
    }

    private void addSonarLintAnalysisParameters(TriggerBuilder triggerBuilder, CodeScopeAware<Collection<String>> activeChecksPerCodeScope) {
        triggerBuilder.setTriggerParameter("checks", activeChecksPerCodeScope);
        CodeScopeAware selectedOptionsPerCodeScope = CodeScopeAware.empty();
        CodeScopeAware optionValuesPerCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : activeChecksPerCodeScope.getCodeScopeNames()) {
            if (((Collection)activeChecksPerCodeScope.getValue(codeScopeName)).isEmpty()) continue;
            ArrayList<String> selectedOptions = new ArrayList<String>();
            ArrayList<String> optionValues = new ArrayList<String>();
            for (Map.Entry entry : ((Map)this.valueByOptionsId.getValue(codeScopeName)).entrySet()) {
                String optionValue = entry.getValue() == null ? "" : String.valueOf(entry.getValue());
                selectedOptions.add((String)entry.getKey());
                optionValues.add(optionValue);
            }
            selectedOptionsPerCodeScope.setValue(codeScopeName, selectedOptions);
            optionValuesPerCodeScope.setValue(codeScopeName, optionValues);
        }
        triggerBuilder.setTriggerParameter("check-options", (ITriggerParameter)selectedOptionsPerCodeScope);
        triggerBuilder.setTriggerParameter("check-option-values", (ITriggerParameter)optionValuesPerCodeScope);
        triggerBuilder.setTriggerParameter("java-source-level", this.javaSourceLevel);
    }

    protected String getDescriptionFileName(String ruleId) {
        return ruleId.replace(':', '_') + ".md";
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        this.autoExpose(template.getCodeScope());
        super.registerQualityIndicators(template, languages, tools);
        template.registerConfiguration((AnalysisConfigurationBase)this);
        if (tools.contains(EAnalysisTool.SONAR_LINT) && languages.contains(ELanguage.JAVA)) {
            template.registerGlobalOptionCodeScopeAware(this.getOptionForField("javaSourceLevel", template.getCodeScope()));
        }
    }

    protected Set<ELanguage> determineLanguages(String ruleId) {
        try {
            ELanguage language = SonarLintMessageManager.getRuleLanguage(ruleId);
            return Set.of(language);
        }
        catch (ProjectConfigurationException e) {
            throw new AssertionError("Unsupported language! Please define the mapping in SonarLintMessageManager.", e);
        }
    }
}

