/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.SingleTokenPatternBase;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;

public class CDataflowUtils {
    private static final Pattern NULL_LITERAL_PATTERN = Pattern.compile("0[UL]*", 2);
    private static final TokenPattern STRUCTURED_BINDING_PATTERN = new TokenPattern().repeated(new Object[]{new TokenPattern().alternative(new Object[]{ETokenType.CONST, ETokenType.VOLATILE})}).group(0).sequence(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.AUTO}).optional(new Object[]{ETokenType.AND}).optional(new Object[]{ETokenType.AND})}).group(1).sequence(new Object[]{ETokenType.LBRACK}).sequence(new Object[]{ETokenType.IDENTIFIER}).repeated(new Object[]{ETokenType.COMMA, ETokenType.IDENTIFIER}).sequence(new Object[]{ETokenType.RBRACK});
    public static final SingleTokenPatternBase NULL_MATCHER = new SingleTokenPatternBase(){

        public boolean matchesToken(IToken token) {
            return token.getType() == ETokenType.INTEGER_LITERAL && NULL_LITERAL_PATTERN.matcher(token.getText()).matches() || token.getText().equalsIgnoreCase("NULL");
        }

        public String toString() {
            return "NULL";
        }
    };
    public static final TokenPattern NULL_VALUE_PATTERN = new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.LPAREN}).optional(new Object[]{ETokenType.LPAREN, ETokenType.VOID, ETokenType.MULT, ETokenType.RPAREN}).alternative(new Object[]{ETokenType.NULL_LITERAL, ETokenType.NULL, ETokenType.NULLPTR, NULL_MATCHER}).sequence(new Object[]{ETokenType.RPAREN}), new TokenPattern().optional(new Object[]{ETokenType.LPAREN, ETokenType.VOID, ETokenType.MULT, ETokenType.RPAREN}).alternative(new Object[]{ETokenType.NULL_LITERAL, ETokenType.NULL, ETokenType.NULLPTR, NULL_MATCHER})});

    public static boolean isPointerOrReferenceWithMutableValue(String variable, ControlFlowGraph cfg) {
        if (!cfg.getDefinedVariables().contains(variable)) {
            return false;
        }
        List<IToken> parameterDeclarationTokens = CDataflowUtils.getParameterDeclarationTokensForVariable(variable, cfg);
        if (!parameterDeclarationTokens.isEmpty()) {
            return CDataflowUtils.isMutablePointerOrReferenceType(parameterDeclarationTokens);
        }
        return CDataflowUtils.isPointerOrReferenceVariableWithMutableValue(variable, cfg);
    }

    private static List<IToken> getParameterDeclarationTokensForVariable(String variable, ControlFlowGraph cfg) {
        if (cfg.getEntities().isEmpty()) {
            return CollectionUtils.emptyList();
        }
        Optional languageFeatureParser = CLikeLanguageFeatureParserBase.getInstance((ELanguage)TokenStreamUtils.getLanguage((Collection)cfg.getEntities().getFirst().getAllTokensOfFile()));
        if (languageFeatureParser.isEmpty()) {
            return Collections.emptyList();
        }
        for (List parameterDeclarationTokens : ((CLikeLanguageFeatureParserBase)languageFeatureParser.get()).getSplitParameterTokens(cfg.getEntities().getFirst())) {
            if (!TokenStreamTextUtils.contains((List)parameterDeclarationTokens, (String)variable)) continue;
            return parameterDeclarationTokens;
        }
        return CollectionUtils.emptyList();
    }

    private static boolean isPointerOrReferenceVariableWithMutableValue(String variable, ControlFlowGraph cfg) {
        return cfg.getDeclarationTokens(variable).filter(CDataflowUtils::isMutablePointerOrReferenceType).isPresent();
    }

    private static boolean isMutablePointerOrReferenceType(List<IToken> declarationTokens) {
        if (declarationTokens.isEmpty()) {
            return false;
        }
        ELanguage language = TokenStreamUtils.getLanguage(declarationTokens);
        boolean isCpp = language == ELanguage.CPP || language == ELanguage.CPP_MS_CLI;
        Optional<Pair<List<IToken>, String>> modifiersAndTypeOfStructuredBinding = CDataflowUtils.getStructuredBindingModifiersAndType(declarationTokens);
        Pair<List<IToken>, String> modifiersAndType = isCpp && modifiersAndTypeOfStructuredBinding.isPresent() ? modifiersAndTypeOfStructuredBinding.get() : LanguageFeatureParser.C.getModifiersAndTypeFromTokens(declarationTokens);
        return CDataflowUtils.isMutablePointerOrReferenceType(declarationTokens, (String)modifiersAndType.getSecond(), (List)modifiersAndType.getFirst());
    }

    private static boolean isMutablePointerOrReferenceType(List<IToken> declarationTokens, String type, List<IToken> modifiers) {
        if (type == null || !type.contains("*") && !type.contains("&")) {
            return false;
        }
        if (!TokenStreamUtils.contains(modifiers, (ETokenType)ETokenType.CONST)) {
            return true;
        }
        int constIndex = TokenStreamUtils.firstTokenMatching(declarationTokens, (ITokenMatcher)ETokenType.CONST);
        int pointerIndex = TokenStreamUtils.firstTokenMatching(declarationTokens, (ITokenMatcher)ETokenType.MULT);
        int referenceIndex = TokenStreamUtils.firstTokenMatching(declarationTokens, (ITokenMatcher)ETokenType.AND);
        boolean isPointerByReference = pointerIndex != -1 && referenceIndex != -1;
        boolean isNonConstantPointer = pointerIndex != -1 && pointerIndex < constIndex;
        boolean isPointerToPointer = TokenStreamUtils.count(declarationTokens, (ETokenType)ETokenType.MULT) > 1;
        return isPointerByReference || isPointerToPointer || isNonConstantPointer;
    }

    private static Optional<Pair<List<IToken>, String>> getStructuredBindingModifiersAndType(List<IToken> tokens) {
        TokenPatternMatch match = STRUCTURED_BINDING_PATTERN.findFirstMatch(tokens);
        if (match == null) {
            return Optional.empty();
        }
        return Optional.of(Pair.createPair((Object)match.groupTokens(0), (Object)match.groupString(1)));
    }
}

