/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.java;

import com.teamscale.index.dataflow.controlflowgraph.Condition;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ConditionTreeNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IDefUseHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.clike.CLikeConditionHeuristic;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;

public class JavaConditionHeuristic
extends CLikeConditionHeuristic {
    public JavaConditionHeuristic(IDefUseHeuristic defUseHeuristic) {
        super(defUseHeuristic, ETokenType.INSTANCEOF);
    }

    @Override
    protected void addSpecialNullCheckInformation(ConditionTreeNode node, Condition condition) {
        this.addJavaObjectsNonNullCheckInformation(node, condition);
    }

    private void addJavaObjectsNonNullCheckInformation(ConditionTreeNode node, Condition condition) {
        TokenPattern nonNullPattern = new TokenPattern().optional(new Object[]{new TokenPattern().regex("^Objects$"), ETokenType.DOT}).regex("^nonNull$").skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false).group(0);
        TokenPatternMatch match = nonNullPattern.findFirstMatch(node.getTokens());
        if (match == null) {
            return;
        }
        if (match.hasGroup(0)) {
            String matchString = match.groupString(0);
            String variableName = matchString.substring(1, matchString.length() - 1);
            if (this.isUnknown(variableName)) {
                return;
            }
            condition.getYesBranchInfo().add((Object)variableName, (Object)false);
            condition.getNoBranchInfo().add((Object)variableName, (Object)true);
            condition.getNullCheckedVariables().add(variableName);
        }
    }
}

