/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.abap;

import com.teamscale.index.dependencies.DependencyExtractorBase;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.abap.AbapCallDependencyExtractor;
import com.teamscale.index.dependencies.abap.AbapDependencyCollection;
import com.teamscale.index.dependencies.abap.AbapGlobalTypeResolutionUtils;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.abap.OpenSqlWriteStatement;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.preprocessor.abap.AbapPreprocessor;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.ParsedAbapElementPath;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.pattern.EnumPatternMatcher;
import org.conqat.engine.sourcecode.pattern.TokenTypePattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class AbapDependencyExtractor
extends DependencyExtractorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final TokenTypePattern INCLUDE_PATTERN = new TokenTypePattern("<INCLUDE><IDENTIFIER>(<IF><FOUND>)?<DOT>");
    private static final TokenTypePattern TYPE_PATTERN = new TokenTypePattern("(<TYPE>|<CATCH>|<RAISING>)<IDENTIFIER>");
    private static final TokenTypePattern REFERENCE_PATTERN = new TokenTypePattern("<TYPE><REF><TO><IDENTIFIER>");
    private static final TokenTypePattern TYPE_CAST_PATTERN = new TokenTypePattern("<CAST><IDENTIFIER><LPAREN>");
    private static final TokenTypePattern INHERITANCE_PATTERN = new TokenTypePattern("<INHERITING><FROM><IDENTIFIER>");
    private static final TokenTypePattern INTERFACE_PATTERN = new TokenTypePattern("<INTERFACES><IDENTIFIER>");
    private static final TokenTypePattern BEHAVIOR_PATTERN = new TokenTypePattern("<FOR><BEHAVIOR><OF><IDENTIFIER>");
    private static final TokenTypePattern TABLE_OF_PATTERN = new TokenTypePattern("<TABLE><OF><IDENTIFIER>");
    private static final int TABLE_OF_PATTERN_TOKEN_LENGTH = 3;
    private AbapDependencyCollection dependencyCollection = null;

    @Override
    protected List<TypeDependencies> extractDependencies(TokenElementInfo tokenElementInfo) throws StorageException {
        ParsedAbapElementPath parsedUniformPath = this.getParsedAbapElementPath();
        this.dependencyCollection = new AbapDependencyCollection(this.uniformPath, this.settings, this.typeLookupEnvironment, this.dependencyExtractionIndexes.abapThirdPartyPathsIndex, AbapDependencyExtractor.collectOwnInnerTypes(tokenElementInfo));
        AbapCallDependencyExtractor callDependencyExtractor = new AbapCallDependencyExtractor(parsedUniformPath, this.settings, this.dependencyCollection, this.typeLookupEnvironment);
        List<IToken> tokens = AbapDependencyExtractor.getTokens(tokenElementInfo);
        this.processIncludes(tokens);
        callDependencyExtractor.processFunctionCalls(tokens);
        List<ShallowEntity> entities = AbapDependencyExtractor.getEntities(tokenElementInfo, tokens);
        if (entities != null) {
            ITypeResolution typeResolution = AbapGlobalTypeResolutionUtils.createGlobalTypeResolution(entities, this.typeLookupEnvironment);
            callDependencyExtractor.processClassMethodCalls(entities, this.typeLookupEnvironment);
            callDependencyExtractor.processInstanceMethodCall(entities, this.typeLookupEnvironment, typeResolution);
            this.processOpenSQLStatements(entities, typeResolution);
        }
        this.processTypeSpecifications(tokens);
        this.processRefToTypeSpecifications(tokens);
        this.processTypeCasts(tokens);
        this.processInheritance(tokens);
        this.processTypePoolReferences(tokens);
        this.processAuthorityCheckObjectReferences(tokens);
        this.processCallTransactionReferences(tokens);
        this.processBehaviorDependency(tokens);
        this.processTableReferences(tokens, entities);
        return Collections.singletonList(new TypeDependencies(parsedUniformPath.getElementName().getUniqueName(), this.dependencyCollection.getDependencies()));
    }

    private static List<ShallowEntity> getEntities(TokenElementInfo tokenElementInfo, List<IToken> tokens) {
        List entities = null;
        try {
            entities = ShallowParserFactory.createParser((ELanguage)ELanguage.ABAP).parseTopLevel(tokens);
        }
        catch (ShallowParserException e) {
            LOGGER.warn("Parsing Exception while extracting dependencies from " + tokenElementInfo.getUniformPath(), (Throwable)e);
        }
        return entities;
    }

    private ParsedAbapElementPath getParsedAbapElementPath() throws StorageException {
        ParsedAbapElementPath parsedUniformPath;
        try {
            parsedUniformPath = new ParsedAbapElementPath(this.uniformPath, false);
        }
        catch (ConQATException e) {
            throw new StorageException("Unable to parse " + this.uniformPath + " as ABAP element path", (Throwable)e);
        }
        return parsedUniformPath;
    }

    private static Set<String> collectOwnInnerTypes(TokenElementInfo tokenElementInfo) {
        HashSet<String> ownInnerTypeNames = new HashSet<String>();
        for (ShallowEntity attributeEntity : ShallowEntityTraversalUtils.listEntitiesOfType(tokenElementInfo.getShallowEntitiesWithPreprocessorTokens(), (EShallowEntityType)EShallowEntityType.ATTRIBUTE)) {
            if (!attributeEntity.getSubtype().equals("types")) continue;
            ownInnerTypeNames.add(attributeEntity.getName().toUpperCase());
        }
        return ownInnerTypeNames;
    }

    private void processOpenSQLStatements(List<ShallowEntity> entities, ITypeResolution typeResolution) throws StorageException {
        for (ShallowEntity statement : ShallowEntityTraversalUtils.listEntitiesOfType(entities, (EShallowEntityType)EShallowEntityType.STATEMENT)) {
            OpenSqlWriteStatement openSqlWriteStatement;
            UnmodifiableList tokens = statement.ownStartTokens();
            if (AbapDependencyExtractor.isQueryStatement((List<IToken>)tokens)) {
                List<Integer> nameIndices = TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.FROM, ETokenType.IDENTIFIER}).stream().map(index -> index + 1).collect(Collectors.toList());
                this.dependencyCollection.addDependenciesForTokenTexts(nameIndices, (List<IToken>)tokens, EAbapObjectType.ALL_DATABASE_ENTITY_TYPES);
                continue;
            }
            if (!AbapDependencyExtractor.isPossibleDatabaseWriteAccessStatement((UnmodifiableList<IToken>)tokens) || (openSqlWriteStatement = OpenSqlWriteStatement.create((ShallowEntity)statement, (List)tokens, (ITypeResolution)typeResolution)) == null || openSqlWriteStatement.targetsInternalTable()) continue;
            this.dependencyCollection.addDependency(openSqlWriteStatement.getTableNameToken(), EAbapObjectType.ALL_DATABASE_ENTITY_TYPES);
        }
    }

    private static boolean isPossibleDatabaseWriteAccessStatement(UnmodifiableList<IToken> tokens) {
        return TokenStreamUtils.containsAny(tokens, (int)0, (int)1, (ETokenType[])new ETokenType[]{ETokenType.INSERT, ETokenType.MODIFY, ETokenType.UPDATE, ETokenType.DELETE});
    }

    private static boolean isQueryStatement(List<IToken> tokens) {
        return TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.SELECT}) || TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.WITH}) || TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.OPEN, ETokenType.CURSOR});
    }

    private void processCallTransactionReferences(List<IToken> tokens) throws StorageException {
        List<Integer> nameIndices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.CALL, ETokenType.TRANSACTION, ETokenType.CHARACTER_LITERAL}).stream().map(index -> index + 2).collect(Collectors.toList());
        this.dependencyCollection.addDependenciesForTokenTexts(nameIndices, tokens, EnumSet.of(EAbapObjectType.TRAN));
    }

    private void processAuthorityCheckObjectReferences(List<IToken> tokens) throws StorageException {
        List<Integer> nameIndices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.AUTHORITY_CHECK, ETokenType.OBJECT, ETokenType.CHARACTER_LITERAL}).stream().map(index -> index + 2).collect(Collectors.toList());
        this.dependencyCollection.addDependenciesForTokenTexts(nameIndices, tokens, EnumSet.of(EAbapObjectType.SUSO));
    }

    private void processTypePoolReferences(List<IToken> tokens) throws StorageException {
        List<Integer> nameIndices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.TYPE_POOLS, ETokenType.IDENTIFIER, ETokenType.DOT}).stream().map(index -> index + 1).collect(Collectors.toList());
        this.dependencyCollection.addDependenciesForTokenTexts(nameIndices, tokens, EnumSet.of(EAbapObjectType.TYPE));
    }

    private void processIncludes(List<IToken> tokens) throws StorageException {
        for (List match : INCLUDE_PATTERN.matchAll(tokens)) {
            String includedProgram = ((IToken)match.get(1)).getText();
            this.dependencyCollection.addDependency(includedProgram, (IToken)match.get(1), (EnumSet<EAbapObjectType>)EAbapObjectType.ALL_INCLUDE_TYPES);
        }
    }

    private void processRefToTypeSpecifications(List<IToken> tokens) throws StorageException {
        EnumPatternMatcher matcher = REFERENCE_PATTERN.matcher(tokens);
        while (matcher.find()) {
            this.processTypeReference(matcher.end() - 1, tokens);
        }
    }

    private void processTypeReference(int typeStartIndex, List<IToken> tokens) throws StorageException {
        IToken typeStartToken = tokens.get(typeStartIndex);
        IToken possibleAccessOperator = tokens.get(typeStartIndex + 1);
        if (EnumSet.of(ETokenType.EQGT, ETokenType.ARROW, ETokenType.TILDE).contains(possibleAccessOperator.getType())) {
            IToken[] typeTokens = new IToken[]{typeStartToken, possibleAccessOperator, tokens.get(typeStartIndex + 2)};
            this.dependencyCollection.processTypeReference(TokenStreamTextUtils.concatTokenTexts(Arrays.asList(typeTokens)), typeTokens);
            return;
        }
        this.dependencyCollection.processTypeReference(typeStartToken.getText(), typeStartToken);
    }

    private void processTypeSpecifications(List<IToken> tokens) throws StorageException {
        EnumPatternMatcher matcher = TYPE_PATTERN.matcher(tokens);
        while (matcher.find()) {
            this.processTypeReference(matcher.end() - 1, tokens);
        }
    }

    private void processTypeCasts(List<IToken> tokens) throws StorageException {
        EnumPatternMatcher matcher = TYPE_CAST_PATTERN.matcher(tokens);
        while (matcher.find()) {
            String targetName;
            int matchIndex = matcher.start();
            if (!ETokenType.CAST.name().equalsIgnoreCase(tokens.get(matchIndex).getText()) || (targetName = tokens.get(matchIndex + 1).getText()).equals("#")) continue;
            this.processTypeReference(matchIndex + 1, tokens);
        }
    }

    private void processInheritance(List<IToken> tokens) throws StorageException {
        String targetName;
        IToken token;
        for (List match : INHERITANCE_PATTERN.matchAll(tokens)) {
            token = (IToken)CollectionUtils.getLast((List)match);
            targetName = token.getText();
            this.dependencyCollection.processTypeReference(targetName, token);
        }
        for (List match : INTERFACE_PATTERN.matchAll(tokens)) {
            token = (IToken)CollectionUtils.getLast((List)match);
            targetName = token.getText();
            this.dependencyCollection.processTypeReference(targetName, token);
        }
    }

    private void processBehaviorDependency(List<IToken> tokens) throws StorageException {
        for (List match : BEHAVIOR_PATTERN.matchAll(tokens)) {
            IToken token = (IToken)CollectionUtils.getLast((List)match);
            String targetName = token.getText();
            this.dependencyCollection.addDependency(targetName, token, EnumSet.of(EAbapObjectType.BDEF));
        }
    }

    private void processTableReferences(List<IToken> tokens, List<ShallowEntity> entities) throws StorageException {
        Iterator iterator = TABLE_OF_PATTERN.matchAllStartIndices(tokens).iterator();
        while (iterator.hasNext()) {
            int matchStartIndex = (Integer)iterator.next();
            int dependencyTargetTokenIndex = matchStartIndex + 3 - 1;
            IToken dependencyTargetToken = tokens.get(dependencyTargetTokenIndex);
            String targetName = dependencyTargetToken.getText();
            if (tokens.size() > dependencyTargetTokenIndex + 2 && tokens.get(dependencyTargetTokenIndex + 1).getType() == ETokenType.EQGT && tokens.get(dependencyTargetTokenIndex + 2).getType() == ETokenType.IDENTIFIER) {
                this.dependencyCollection.addDependency(targetName, dependencyTargetToken, (EnumSet<EAbapObjectType>)EAbapObjectType.ALL_OO_TYPES);
                continue;
            }
            this.dependencyCollection.addDependency(targetName, dependencyTargetToken, (EnumSet<EAbapObjectType>)EAbapObjectType.ALL_DATABASE_ENTITY_TYPES);
        }
        for (ShallowEntity methodEntity : ShallowEntityTraversalUtils.listEntitiesOfType(entities, (EShallowEntityType)EShallowEntityType.METHOD)) {
            UnmodifiableList methodStartTokens;
            int usingIndex;
            if (!methodEntity.getSubtype().equals("method implementation") || (usingIndex = TokenStreamUtils.findFirstTopLevel((List)(methodStartTokens = methodEntity.ownStartTokens()), (ITokenMatcher)ETokenType.USING, (List)TokenStreamUtils.STANDARD_OPENING_TOKEN_TYPES, (List)TokenStreamUtils.STANDARD_CLOSING_TOKEN_TYPES)) == -1) continue;
            for (int i = usingIndex + 1; i < tokens.size() && ((IToken)methodStartTokens.get(i)).getType() == ETokenType.IDENTIFIER; ++i) {
                IToken usedItemToken = (IToken)methodStartTokens.get(i);
                this.dependencyCollection.addDependency(usedItemToken.getText(), usedItemToken, (EnumSet<EAbapObjectType>)EAbapObjectType.ALL_DATABASE_ENTITY_TYPES);
            }
        }
    }

    private static List<IToken> getTokens(TokenElementInfo tokenElementInfo) {
        return new AbapPreprocessor().preprocess(tokenElementInfo.getUniformPath(), AbapDependencyExtractor.getRawTokensWithoutComments(tokenElementInfo));
    }
}

