/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.abap;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.ParsedAbapElementPath;
import org.conqat.engine.abap.UniqueAbapElementName;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assertion.CCSMAssert;

final class AbapTypeNameUtils {
    private static final Map<String, EAbapObjectType> SUBTYPE_TO_OBJECTTYPE_MAP = Stream.of(new AbstractMap.SimpleEntry<String, EAbapObjectType>("interface definition", EAbapObjectType.INTF), new AbstractMap.SimpleEntry<String, EAbapObjectType>("class definition", EAbapObjectType.CLAS), new AbstractMap.SimpleEntry<String, EAbapObjectType>("types", EAbapObjectType.TYPE)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    private static final String INNER_TYPE_SEPARATOR = ".";

    private AbapTypeNameUtils() {
    }

    public static String buildTypeName(String uniformPath, ShallowEntity typeEntity) throws ConQATException {
        String typeName = AbapTypeNameUtils.getTypeEntityName(typeEntity);
        EAbapObjectType typeKind = SUBTYPE_TO_OBJECTTYPE_MAP.get(typeEntity.getSubtype());
        ParsedAbapElementPath pathOfContainingElement = new ParsedAbapElementPath(uniformPath, false);
        UniqueAbapElementName elementName = pathOfContainingElement.getElementName();
        if (typeName.toUpperCase().equals(elementName.getObjectName()) && typeKind == elementName.getObjectType()) {
            return elementName.getUniqueName();
        }
        return AbapTypeNameUtils.buildInnerTypeName(pathOfContainingElement, typeName, typeKind);
    }

    public static String buildInnerTypeName(String outerTypeUniqueName, String innerTypeName, EAbapObjectType innerTypeKind) {
        Object fullInnerTypeName = innerTypeName.toUpperCase();
        if (innerTypeKind != null) {
            fullInnerTypeName = (String)fullInnerTypeName + "@" + innerTypeKind.name();
        }
        return outerTypeUniqueName + INNER_TYPE_SEPARATOR + (String)fullInnerTypeName;
    }

    public static String buildInnerTypeName(ParsedAbapElementPath pathOfContainingElement, String localTypeName, EAbapObjectType localTypeKind) {
        UniqueAbapElementName elementName = pathOfContainingElement.getElementName();
        if (pathOfContainingElement.isClassOrInterface()) {
            elementName = new UniqueAbapElementName(pathOfContainingElement.getClassName(), pathOfContainingElement.getElementName().getObjectType());
        } else if (pathOfContainingElement.isFunctionGroup()) {
            elementName = new UniqueAbapElementName(pathOfContainingElement.getFunctionGroup(), EAbapObjectType.FUGR);
        }
        return AbapTypeNameUtils.buildInnerTypeName(elementName.getUniqueName(), localTypeName, localTypeKind);
    }

    private static String getTypeEntityName(ShallowEntity typeEntity) throws ConQATException {
        CCSMAssert.isTrue((boolean)SUBTYPE_TO_OBJECTTYPE_MAP.keySet().contains(typeEntity.getSubtype()), (String)("Entity of subtype " + typeEntity.getSubtype() + " not expected as type entity"));
        if (typeEntity.getName() != null) {
            return typeEntity.getName().toUpperCase();
        }
        if (TokenStreamUtils.startsWith((List)typeEntity.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.TYPES, ETokenType.IDENTIFIER})) {
            return ((IToken)typeEntity.ownStartTokens().get(1)).getText().toUpperCase();
        }
        throw new ConQATException("Unable to identify name of type entity " + String.valueOf(typeEntity));
    }
}

