/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.cpp;

import com.teamscale.index.dependencies.TypeExtractorBase;
import com.teamscale.index.dependencies.cpp.CppDependencyUtils;
import com.teamscale.index.dependencies.type.Type;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.cpp.CppCheckUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.sourcecode.shallowparser.ShallowParserUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class CppTypeExtractor
extends TypeExtractorBase {
    private static final String METHOD_TYPE_PREFIX = "cpp-method:";
    @VisibleForTesting
    static final String RESOLVED_HEADER_TYPE_PREFIX = "cpp-header:";
    @VisibleForTesting
    static final String UNRESOLVED_HEADER_TYPE_PREFIX = "cpp-header*:";
    private boolean performCaseSensitiveHeaderResolution = false;
    private boolean findCppDependenciesInExcludedCode;
    private final TokenElementIndex contentIndex;

    public CppTypeExtractor(TokenElementIndex contentIndex) {
        this.contentIndex = contentIndex;
    }

    public void setPerformCaseSensitiveHeaderResolution(boolean value) {
        this.performCaseSensitiveHeaderResolution = value;
    }

    public void setFindCppDependenciesInExcludedCode(boolean findCppDependenciesInExcludedCode) {
        this.findCppDependenciesInExcludedCode = findCppDependenciesInExcludedCode;
    }

    @Override
    public List<Type> extractTypes(String uniformPath, String content, ELanguage language) throws ConQATException {
        ArrayList<String> typeNames = new ArrayList<String>();
        if (CppCheckUtils.isHeaderFile((String)uniformPath)) {
            typeNames.add(CppTypeExtractor.getResolvedHeaderType(uniformPath, this.performCaseSensitiveHeaderResolution));
            for (String suffix : CppTypeExtractor.getAllPathSuffixes(uniformPath)) {
                typeNames.add(CppTypeExtractor.getUnresolvedHeaderType(suffix, this.performCaseSensitiveHeaderResolution));
            }
        }
        typeNames.addAll(this.extractTypesForMethodImplementations(uniformPath, content, language));
        return CppTypeExtractor.toTypes(typeNames);
    }

    private List<String> extractTypesForMethodImplementations(String uniformPath, String content, ELanguage language) throws ConQATException {
        TokenElementInfo elementInfo = this.contentIndex.getTokenElement(uniformPath);
        UnmodifiableList<ShallowEntity> entitiesAfterPreprocessing = elementInfo.getShallowEntitiesWithPreprocessorTokens();
        HashSet<String> typeNames = new HashSet<String>(CppTypeExtractor.extractTypesForNonStaticMethodImplementations(entitiesAfterPreprocessing));
        if (this.findCppDependenciesInExcludedCode) {
            List dirtyEntities = ShallowParserUtils.createParser((ELanguage)language).parseTopLevel(ScannerUtils.getTokens((String)content, (ELanguage)language, (String)uniformPath));
            dirtyEntities.removeIf(entity -> !entity.isCompleted());
            typeNames.addAll(CppTypeExtractor.extractTypesForNonStaticMethodImplementations(dirtyEntities));
        }
        return typeNames.stream().sorted().toList();
    }

    private static @NonNull List<String> extractTypesForNonStaticMethodImplementations(List<ShallowEntity> entities) {
        ArrayList<String> typeNames = new ArrayList<String>();
        ArrayList<String> namespacePrefixes = new ArrayList<String>();
        for (ShallowEntity entity : ShallowEntityTraversalUtils.listEntitiesOfTypes(entities, EnumSet.of(EShallowEntityType.METHOD, EShallowEntityType.META))) {
            String name;
            if (entity.getType() == EShallowEntityType.META) {
                if (!"using namespace".equals(entity.getSubtype()) || StringUtils.isEmpty((String)entity.getName())) continue;
                namespacePrefixes.add(entity.getName());
                continue;
            }
            if (entity.getSubtype().endsWith("declaration") || CppDependencyUtils.isStaticMethod(entity) || StringUtils.isEmpty((String)(name = CppDependencyUtils.getMethodName(entity)))) continue;
            typeNames.add(CppTypeExtractor.getMethodType(name));
            for (String prefix : namespacePrefixes) {
                typeNames.add(CppTypeExtractor.getMethodType(prefix + "::" + name));
            }
        }
        return typeNames;
    }

    public static String getResolvedHeaderType(String headerPath, boolean caseSensitive) {
        return CppTypeExtractor.getHeaderType(RESOLVED_HEADER_TYPE_PREFIX, headerPath, caseSensitive);
    }

    public static String getUnresolvedHeaderType(String headerPath, boolean caseSensitive) {
        return CppTypeExtractor.getHeaderType(UNRESOLVED_HEADER_TYPE_PREFIX, headerPath, caseSensitive);
    }

    private static String getHeaderType(String prefix, String headerPath, boolean caseSensitive) {
        if (!caseSensitive) {
            headerPath = CppDependencyUtils.normalizeHeaderPath(headerPath);
        }
        return prefix + headerPath;
    }

    public static String getMethodType(String methodName) {
        return METHOD_TYPE_PREFIX + methodName;
    }
}

