/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input;

import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.index.external.ExternalAnalysisDeletionIndex;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndexUtils;
import com.teamscale.index.external.tools.ExternalUploadIndexModifier;
import com.teamscale.index.resource.ExternalAnalysisReportArchiveIndex;
import com.teamscale.index.testgap.trend.TestCoverageDeltaIndex;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.config.DatabaseConfiguration;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StoreFactory;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.factory.IFactory;

public class DeleteExternalAnalysisResultsTrigger
extends PrivilegedTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private InternalProjectId internalProjectId;

    public void execute() throws StorageException, IOException {
        File temporaryStorageDirectory;
        CCSMAssert.isTrue((this.jobDescriptor.getSchedulingCommit() == null ? 1 : 0) != 0, (String)"Must not be scheduled with commit");
        this.internalProjectId = this.jobDescriptor.getInternalProjectId();
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)this.internalProjectId);
        ExternalAnalysisDeletionIndex externalAnalysisDeletionIndex = (ExternalAnalysisDeletionIndex)projectStorageSystem.openProjectIndex(ExternalAnalysisDeletionIndex.class, null);
        Set<CommitDescriptor> commits = externalAnalysisDeletionIndex.getCommits();
        if (commits.isEmpty()) {
            return;
        }
        try {
            temporaryStorageDirectory = StoreFactory.createTemporaryStorageDirectory((File)this.getTemporaryDirectory(), (String)"__delete");
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
        StoreFactory.runWithTemporaryOnDiskStoreFactory(storeFactory -> this.deleteFromExternalUploadAndTestCoverageDelta((StoreFactory)storeFactory, commits), (File)temporaryStorageDirectory, (DatabaseConfiguration)this.instanceConfiguration.getDatabaseConfiguration());
        DeleteExternalAnalysisResultsTrigger.deleteFromExternalAnalysisStatus((ProjectStorageSystem)projectStorageSystem, commits);
        DeleteExternalAnalysisResultsTrigger.deleteFromExternalAnalysisReportArchiveIndex((ProjectStorageSystem)projectStorageSystem, commits);
        externalAnalysisDeletionIndex.removeCommits(commits);
    }

    private static void deleteFromExternalAnalysisStatus(ProjectStorageSystem projectStorageSystem, Set<CommitDescriptor> commits) throws StorageException {
        ExternalAnalysisStatusIndex statusIndex = (ExternalAnalysisStatusIndex)projectStorageSystem.openProjectIndex(ExternalAnalysisStatusIndex.class, null);
        ExternalAnalysisImportSessionIndex sessionIndex = (ExternalAnalysisImportSessionIndex)projectStorageSystem.openProjectIndex(ExternalAnalysisImportSessionIndex.class, null);
        ExternalAnalysisStatusIndexUtils.deleteCommitStatusInfo(new ArrayList<CommitDescriptor>(commits), statusIndex, sessionIndex);
    }

    private static void deleteFromExternalAnalysisReportArchiveIndex(ProjectStorageSystem projectStorageSystem, Set<CommitDescriptor> commits) throws StorageException {
        ExternalAnalysisReportArchiveIndex archiveIndex = (ExternalAnalysisReportArchiveIndex)projectStorageSystem.openProjectIndex(ExternalAnalysisReportArchiveIndex.class, null);
        archiveIndex.removeEntriesForCommits(commits);
    }

    private void deleteFromExternalUploadAndTestCoverageDelta(StoreFactory storeFactory, Set<CommitDescriptor> commits) throws StorageException {
        IStorageSystem rawProjectStorageSystem = this.indexLayer.openRawProjectStorageSystem(this.internalProjectId);
        ExternalUploadIndexModifier modifier = new ExternalUploadIndexModifier(rawProjectStorageSystem, this.indexLayer.getStorageCacheProvider().getCacheProvider(this.internalProjectId.toString()), (IFactory<IStore, StorageException>)storeFactory, "external-analysis-results", ExternalAnalysisResultIndex.class);
        this.deleteFromTestCoverageDelta(rawProjectStorageSystem, commits);
        modifier.deleteCommits(commits);
        modifier.scheduleRollbackIfNeeded(this.internalProjectId, this.indexLayer);
    }

    private void deleteFromTestCoverageDelta(IStorageSystem rawProjectStorageSystem, Collection<CommitDescriptor> commits) throws StorageException {
        ProjectStorageSystem projectStorageSystem = new ProjectStorageSystem(rawProjectStorageSystem, this.indexLayer.getStorageCacheProvider().getCacheProvider(this.internalProjectId.toString()));
        TestCoverageDeltaIndex index = (TestCoverageDeltaIndex)projectStorageSystem.openProjectIndex(TestCoverageDeltaIndex.class, null);
        for (CommitDescriptor commit : commits) {
            LOGGER.info("Deleting " + commit.toString());
            index.removeEntry(commit);
        }
    }

    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.PRIORITY_FULLY_ISOLATED;
    }
}

