/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.update;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.UniformPathSerializer;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.engine.persistence.store.util.IStorageAbbreviator;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Index(name="external-metrics-last-update", options={EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={Long.class})
public class ExternalMetricsLastUpdateIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "external-metrics-last-update";
    private final ConvenientStore store;

    public ExternalMetricsLastUpdateIndex(IStore store) {
        this.store = new ConvenientStore(store, false);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void setMetricInPartitionLastUpdated(PairList<PartitionAndPath, String> metricsForPartitionAndPath, long timestamp) throws StorageException {
        List<UniformPath> distinctPaths = metricsForPartitionAndPath.getFirstList().stream().map(PartitionAndPath::toUniformPath).distinct().toList();
        List<byte[]> keysAsBytes = this.getKeysForPaths(distinctPaths);
        @Nullable List values = this.store.get(keysAsBytes);
        HashMap<UniformPath, byte[]> entriesByUniformPath = new HashMap<UniformPath, byte[]>();
        for (int i = 0; i < values.size(); ++i) {
            if (values.get(i) == null) continue;
            entriesByUniformPath.put(distinctPaths.get(i), (byte[])values.get(i));
        }
        for (Pair entry : metricsForPartitionAndPath) {
            String partition = ((PartitionAndPath)entry.getFirst()).getPartition();
            String metricId = (String)entry.getSecond();
            UniformPath uniformPath = ((PartitionAndPath)entry.getFirst()).toUniformPath();
            LastUpdateInfo lastUpdateInfo = new LastUpdateInfo();
            if (entriesByUniformPath.containsKey(uniformPath)) {
                lastUpdateInfo = (LastUpdateInfo)StorageUtils.deserialize((byte[])((byte[])entriesByUniformPath.get(uniformPath)));
            }
            lastUpdateInfo.setLastUpdate(metricId, partition, timestamp);
            entriesByUniformPath.put(uniformPath, StorageUtils.serialize((Serializable)lastUpdateInfo));
        }
        PairList entriesToPut = new PairList();
        for (Map.Entry entry : entriesByUniformPath.entrySet()) {
            entriesToPut.add((Object)this.abbreviateSegments((UniformPath)entry.getKey()), (Object)((byte[])entry.getValue()));
        }
        this.store.put(entriesToPut);
    }

    private List<byte[]> getKeysForPaths(List<UniformPath> distinctPaths) throws StorageException {
        ArrayList<byte[]> keysAsBytes = new ArrayList<byte[]>();
        for (UniformPath path : distinctPaths) {
            byte[] bytes = this.abbreviateSegments(path);
            keysAsBytes.add(bytes);
        }
        return keysAsBytes;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void removeDeletedMetrics(SetMap<PartitionAndPath, String> pathToMetricIdsToDelete) throws StorageException {
        if (pathToMetricIdsToDelete.isEmpty()) {
            return;
        }
        SetMap pathToPartitionInInput = new SetMap();
        pathToMetricIdsToDelete.getKeys().forEach(partitionPath -> pathToPartitionInInput.add((Object)partitionPath.toUniformPath(), (Object)partitionPath.getPartition()));
        ArrayList<UniformPath> inputPaths = new ArrayList<UniformPath>((Collection<UniformPath>)pathToPartitionInInput.getKeys());
        List<byte[]> list = this.getKeysForPaths(inputPaths);
        @Nullable List existingEntries = this.store.get(list);
        ArrayList<byte[]> keysOfEntriesToRemove = new ArrayList<byte[]>();
        HashMap<byte[], byte[]> entriesToUpdate = new HashMap<byte[], byte[]>();
        for (int i = 0; i < inputPaths.size(); ++i) {
            UniformPath inputPath = (UniformPath)inputPaths.get(i);
            byte[] existingEntry = (byte[])existingEntries.get(i);
            if (existingEntry == null) continue;
            LastUpdateInfo lastUpdateInfo = (LastUpdateInfo)StorageUtils.deserialize((byte[])existingEntry);
            for (String partition : (Set)pathToPartitionInInput.getCollectionOrEmpty((Object)inputPath)) {
                Set metricIdsToDelete = (Set)pathToMetricIdsToDelete.getCollection((Object)new PartitionAndPath(partition, inputPath));
                if (metricIdsToDelete == null) continue;
                for (String metricId : metricIdsToDelete) {
                    lastUpdateInfo.removeUpdate(metricId, partition);
                }
            }
            byte[] currentKey = this.abbreviateSegments(inputPath);
            if (lastUpdateInfo.isEmpty()) {
                keysOfEntriesToRemove.add(currentKey);
                continue;
            }
            entriesToUpdate.put(currentKey, StorageUtils.serialize((Serializable)lastUpdateInfo));
        }
        if (!keysOfEntriesToRemove.isEmpty()) {
            this.store.remove(keysOfEntriesToRemove);
        }
        if (!entriesToUpdate.isEmpty()) {
            this.store.put(PairList.fromMap(entriesToUpdate));
        }
    }

    public void removeEntries(List<MetricIdPathAndPartition> metricIdPathAndPartitionsToDelete) throws StorageException {
        SetMap entriesToDelete = new SetMap();
        metricIdPathAndPartitionsToDelete.forEach(wrapper -> entriesToDelete.add((Object)new PartitionAndPath(wrapper.partition, wrapper.path), (Object)wrapper.metricId));
        this.removeDeletedMetrics((SetMap<PartitionAndPath, String>)entriesToDelete);
    }

    private byte @NonNull [] abbreviateSegments(UniformPath uniformPath) throws StorageException {
        return (byte[])UniformPathSerializer.segmentAbbreviatingSerializer((IStorageAbbreviator)this.store.getAbbreviator().getDelegate()).serialize((Object)uniformPath);
    }

    public Set<PartitionUpdateEntry> getLastPartitionUpdates(String metricId, UniformPath prefix) throws StorageException {
        PairList entriesStartingWith = this.store.getEntriesStartingWith(this.abbreviateSegments(prefix));
        HashMap<String, Long> oldestUpdateByPartition = new HashMap<String, Long>();
        for (Pair entry2 : entriesStartingWith) {
            LastUpdateInfo valuesForPath = (LastUpdateInfo)StorageUtils.deserialize((byte[])((byte[])entry2.getSecond()));
            for (String partition : valuesForPath.getPartitionsForMetric(metricId)) {
                Long partitionTimestamp = valuesForPath.getTimestamp(metricId, partition);
                if (partitionTimestamp == null) continue;
                oldestUpdateByPartition.merge(partition, partitionTimestamp, Math::min);
            }
        }
        return oldestUpdateByPartition.entrySet().stream().map(entry -> new PartitionUpdateEntry((String)entry.getKey(), (Long)entry.getValue())).collect(Collectors.toSet());
    }

    private static class LastUpdateInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final TwoDimHashMap<String, String, PartitionUpdateEntry> metricIdAndPartitionToEntry = new TwoDimHashMap();

        private LastUpdateInfo() {
        }

        private void setLastUpdate(String metricId, String partition, long timestamp) {
            this.metricIdAndPartitionToEntry.putValue((Object)metricId, (Object)partition, (Object)new PartitionUpdateEntry(partition, timestamp));
        }

        private PartitionUpdateEntry getUpdateEntry(String metricId, String partition) {
            return (PartitionUpdateEntry)this.metricIdAndPartitionToEntry.getValue((Object)metricId, (Object)partition);
        }

        private @Nullable Long getTimestamp(String metricId, String partition) {
            PartitionUpdateEntry entry = this.getUpdateEntry(metricId, partition);
            if (entry != null) {
                return entry.timestamp();
            }
            return null;
        }

        private Set<String> getPartitionsForMetric(String metricId) {
            return this.metricIdAndPartitionToEntry.getSecondKeys((Object)metricId);
        }

        private void removeUpdate(String metricId, String partition) {
            this.metricIdAndPartitionToEntry.remove((Object)metricId, (Object)partition);
        }

        private boolean isEmpty() {
            return this.metricIdAndPartitionToEntry.isEmpty();
        }
    }

    public record PartitionUpdateEntry(String partition, long timestamp) implements Serializable
    {
    }

    public record MetricIdPathAndPartition(String metricId, UniformPath path, String partition) {
    }
}

