/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.update;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.RepositoryNeedsRollbackException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.analysis.trigger.IPreAnnouncingAnalysisStep;
import com.teamscale.core.analysis.trigger.RichCommitDescriptor;
import com.teamscale.core.analysis.trigger.configuration.ESchedulingParameter;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.utils.HistoryUtils;
import com.teamscale.index.external.update.SkipNodesBeforeFirstCodeCommit;
import com.teamscale.index.precommit.PreCommitUploadChangeRetriever;
import com.teamscale.index.repository.FirstCodeCommitIndex;
import com.teamscale.index.repository.RepositoryChangeRetrieverUtils;
import com.teamscale.index.repository.TimestampAdjustmentIndex;
import com.teamscale.index.repository.base.CommitTreeExpansionResult;
import com.teamscale.index.repository.committree.ICommitTreeNodeAdjuster;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.lib.commons.date.DateTimeUtils;

public abstract class ExternalUploadChangeRetrieverBase
extends ChangeRetrieverAnalysisStep
implements IPreAnnouncingAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    public TimestampAdjustmentIndex timestampAdjustmentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected FirstCodeCommitIndex firstCodeCommitIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    public CommitDescriptorIndex commitDescriptorIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MetaIndex projectMetaIndex;
    protected String defaultBranchName;

    protected CommitDescriptor executeAndReturnCommitResult() throws StorageException, RescheduleRequestedException {
        CommitDescriptor originalInputCommit = this.getSchedulingCommit();
        this.init();
        try {
            ICommitTreeNodeAdjuster commitTreeNodeAdjuster;
            CommitTreeNode commitTreeNode;
            CommitTree commitTree = this.getCommitTreeIndex().loadTree();
            if (originalInputCommit == null) {
                commitTree.resetLastExpandedTimestamp();
            }
            if ((commitTreeNode = RepositoryChangeRetrieverUtils.extractNextCommitTreeNode((IChangeRetrieverCommitTree)commitTree, originalInputCommit, this::expandCommitTree, commitTreeNodeAdjuster = this.getCommitTreeNodeAdjuster(), 60)) == null) {
                commitTree.persist();
                return null;
            }
            if (originalInputCommit == null) {
                return ExternalUploadChangeRetrieverBase.createHintsOnlyCommitResult(commitTree);
            }
            if (this.isCodeUpload()) {
                this.firstCodeCommitIndex.insertCodeCommit(commitTreeNode.getAdjustedCommitDescriptor());
            }
            return this.processCommitTreeNode(commitTreeNode, commitTree, commitTreeNodeAdjuster, 60);
        }
        catch (RepositoryNeedsRollbackException e) {
            return this.createOutputCommitForRollbackException(originalInputCommit, e);
        }
        catch (RepositoryException | StorageException e) {
            LOGGER.error(e.getMessage(), e);
            return null;
        }
    }

    protected ICommitTreeNodeAdjuster getCommitTreeNodeAdjuster() throws StorageException {
        Map<String, Long> branchToFirstCodeCommit = this.firstCodeCommitIndex.getBranchToFirstCodeCommitMapping();
        return new SkipNodesBeforeFirstCodeCommit(this.timestampAdjustmentIndex, branchToFirstCodeCommit, this::reportSkippedNode);
    }

    private static CommitDescriptor createHintsOnlyCommitResult(CommitTree commitTree) throws StorageException {
        ArrayList schedulingHints = new ArrayList();
        ArrayList schedulingPreAnnouncements = new ArrayList();
        commitTree.extractAndUpdateSchedulableCommits(schedulingHints, schedulingPreAnnouncements);
        commitTree.persist();
        return RichCommitDescriptor.createHintsOnlyDescriptor(schedulingHints, schedulingPreAnnouncements);
    }

    private CommitDescriptor createOutputCommitForRollbackException(CommitDescriptor originalInputCommit, RepositoryNeedsRollbackException rollbackException) throws StorageException {
        return RepositoryChangeRetrieverUtils.resetCommitTreeWithOutputCommit(originalInputCommit, this.getCommitTreeIndex(), null, rollbackException);
    }

    private void init() throws StorageException {
        LOGGER.debug("Input commit is " + String.valueOf(this.getSchedulingCommit()));
        this.defaultBranchName = this.projectMetaIndex.getDefaultBranchName();
    }

    protected void reportSkippedNode(CommitTreeNode node) {
    }

    protected boolean isCodeUpload() {
        return false;
    }

    private CommitDescriptor processCommitTreeNode(CommitTreeNode commitTreeNode, CommitTree commitTree, ICommitTreeNodeAdjuster commitTreeNodeAdjuster, int pollingIntervalSeconds) throws StorageException, RepositoryException, RescheduleRequestedException {
        commitTreeNode.setProcessed();
        commitTreeNodeAdjuster.adjustTimestamps(commitTree.getAllRawNodes());
        return RepositoryChangeRetrieverUtils.extractResultCommitAndPersist(commitTreeNode, (IChangeRetrieverCommitTree)commitTree, commitTreeNodeAdjuster, x -> false, this::expandCommitTree, pollingIntervalSeconds);
    }

    private CommitTreeExpansionResult expandCommitTree(ICommitTree commitTree) throws RepositoryException {
        try {
            return this.expandCommitTreeFromBaseStore(commitTree);
        }
        catch (StorageException e) {
            throw new RepositoryException("Had changes in underlying storage system: " + e.getMessage(), (Throwable)e);
        }
    }

    private CommitTreeExpansionResult expandCommitTreeFromBaseStore(ICommitTree commitTree) throws StorageException, RepositoryNeedsRollbackException {
        IBranchingLayer rawUploadBranchingLayer = this.getUploadBranchingLayer();
        List commits = HistoryUtils.extractCommitDescriptorsFromRawBranchedStore((IBranchingLayer)rawUploadBranchingLayer);
        boolean exhausted = true;
        ArrayList<ParentedCommitDescriptor> commitsThatNodesWereAddedFor = new ArrayList<ParentedCommitDescriptor>();
        HashSet<ICommitTreeNode> addedCommitTreeNodes = new HashSet<ICommitTreeNode>();
        for (ParentedCommitDescriptor commit : commits) {
            String branchName = commit.getBranchName();
            Optional latestContainedRevisionForBranch = commitTree.getLatestContainedRevisionForBranch(branchName);
            this.validateLatestContainedRevisionForBranch(latestContainedRevisionForBranch, commit);
            if (commit.getTimestamp() <= Long.parseLong(latestContainedRevisionForBranch.orElse("0"))) continue;
            ArrayList<CommitTreeRevision> parentRevisions = new ArrayList<CommitTreeRevision>();
            if (commit.getFirstParentCommit() != null) {
                CommitTreeRevision parentRevision = ExternalUploadChangeRetrieverBase.toCommitTreeRevision(commit.getFirstParentCommit());
                if (!commitTree.nodeExists(parentRevision)) {
                    LOGGER.debug("Parent with revision {} on branch {} does not exist in the commit tree (has not been processed yet). Skipping for now.", (Object)parentRevision.getRevision(), (Object)parentRevision.getBranchName());
                    continue;
                }
                parentRevisions.add(parentRevision);
                if (latestContainedRevisionForBranch.isPresent() && !parentRevision.getBranchName().equals(branchName)) {
                    parentRevisions.add(0, new CommitTreeRevision((String)latestContainedRevisionForBranch.get(), branchName));
                    LOGGER.warn("The branch {} already exists for the commit with the timestamp {} and there is a newer revision ({}). Adding this commit as first parent.", (Object)branchName, (Object)commit.getTimestamp(), latestContainedRevisionForBranch.get());
                }
            }
            exhausted = false;
            ICommitTreeNode addedNode = this.addNode(commitTree, commit, parentRevisions);
            if (addedNode != null) {
                addedCommitTreeNodes.add(addedNode);
            }
            commitsThatNodesWereAddedFor.add(commit);
        }
        this.processCommitsAfterNodesWereAdded(commitsThatNodesWereAddedFor);
        return CommitTreeExpansionResult.builder().withFullyExpanded(exhausted).withPerformedActualWork(!commitsThatNodesWereAddedFor.isEmpty()).withAddedNodes(addedCommitTreeNodes).build();
    }

    protected void processCommitsAfterNodesWereAdded(List<ParentedCommitDescriptor> commitsThatNodesWereAddedFor) throws StorageException {
    }

    protected void validateLatestContainedRevisionForBranch(Optional<String> latestContainedRevisionForBranch, ParentedCommitDescriptor commit) throws RepositoryNeedsRollbackException {
    }

    protected ICommitTreeNode addNode(ICommitTree commitTree, ParentedCommitDescriptor commit, List<CommitTreeRevision> parentRevisions) throws StorageException, RepositoryNeedsRollbackException {
        try {
            return commitTree.addNode(ExternalUploadChangeRetrieverBase.toCommitTreeRevision((CommitDescriptor)commit), commit.getTimestamp(), parentRevisions);
        }
        catch (AssertionError e) {
            LOGGER.error("Encountered inconsistency for external upload commit " + commit.toStringWithParents() + ". External upload occurred on " + DateTimeUtils.getUiFormattedDateString((long)commit.getTimestamp()) + ". Default branch name is " + this.defaultBranchName + ".", (Throwable)((Object)e));
            return null;
        }
    }

    protected static CommitTreeRevision toCommitTreeRevision(CommitDescriptor commit) {
        return new CommitTreeRevision(commit.getTimestamp(), commit.getBranchName());
    }

    protected abstract CommitTreeIndex getCommitTreeIndex();

    protected abstract IBranchingLayer getUploadBranchingLayer();

    protected abstract String getRepositoryIdentifier();

    public static TriggerBuilder configurePeriodicTrigger(Class<? extends ExternalUploadChangeRetrieverBase> triggerClass) {
        TriggerBuilder changeTrigger = new TriggerBuilder(triggerClass);
        changeTrigger.setSchedulingParameter(ESchedulingParameter.PERIOD, (Object)ExternalUploadChangeRetrieverBase.getPeriodicSchedulingInterval());
        changeTrigger.setSchedulingParameter(ESchedulingParameter.WARM_UP_ITERATIONS, (Object)2);
        changeTrigger.setSchedulingParameter(ESchedulingParameter.RUN_POST_BUILD_COMPLETENESS, (Object)true);
        changeTrigger.setSchedulingParameter(ESchedulingParameter.CONCURRENCY, (Object)ETriggerConcurrency.OUTPUT_ISOLATED);
        if (!PreCommitUploadChangeRetriever.class.equals(triggerClass)) {
            changeTrigger.setSchedulingParameter(ESchedulingParameter.LOW_PRIO, (Object)true);
        }
        return changeTrigger;
    }

    private static Duration getPeriodicSchedulingInterval() {
        if (EFeatureToggle.ENABLE_TEST_MODE.isEnabled()) {
            return Duration.ofMinutes(1L);
        }
        return Duration.ofMinutes(10L);
    }
}

