/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings;

import java.io.File;
import java.io.IOException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.system.SystemUtils;

public class CppFileUtils {
    public static void saveFile(String uniformPath, String fileContent, File codeDirectory) throws IOException {
        String systemDependentPath = CppFileUtils.makeOsSpecificPath(uniformPath);
        File targetFile = new File(codeDirectory, systemDependentPath);
        FileSystemUtils.writeFileUTF8((File)targetFile, (String)fileContent);
    }

    public static String determineTargetFilePathForProcessBuilder(String uniformPath, File codeDirectory) {
        String systemDependentPath = CppFileUtils.makeOsSpecificPath(uniformPath);
        File targetFile = new File(codeDirectory, systemDependentPath);
        if (SystemUtils.isWindows()) {
            return ".\\" + systemDependentPath;
        }
        return targetFile.getAbsolutePath().replace(" ", "\\ ");
    }

    public static String makeOsSpecificPath(String uniformPath) {
        return uniformPath.replace('/', File.separatorChar);
    }

    public static String makeUnixPath(String uniformPath) {
        return uniformPath.replace(File.separatorChar, '/');
    }
}

