/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class IntegratedToolUpdateUtils {
    private static final Set<Character> MARKDOWN_ESCAPE_CHARACTERS = new HashSet<Character>(Arrays.asList(Character.valueOf('['), Character.valueOf(']'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('#'), Character.valueOf('_'), Character.valueOf('~'), Character.valueOf('^'), Character.valueOf('+'), Character.valueOf('='), Character.valueOf('>')));

    public static String makeMarkdownUnambiguous(String inputMarkdown) {
        boolean changed = false;
        boolean inSingleQuote = false;
        boolean inBackticks = false;
        StringBuilder builder = new StringBuilder();
        char[] chars = inputMarkdown.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '`') {
                inBackticks = !inBackticks;
                builder.append(c);
                continue;
            }
            if (c == '\'') {
                inSingleQuote = !inSingleQuote;
                builder.append(c);
                continue;
            }
            if (inSingleQuote || inBackticks) {
                builder.append(c);
                continue;
            }
            if (MARKDOWN_ESCAPE_CHARACTERS.contains(Character.valueOf(c)) || IntegratedToolUpdateUtils.isDotEnclosedByLettersOrDigits(i, chars)) {
                builder.append('\\');
                builder.append(c);
                changed = true;
                continue;
            }
            builder.append(c);
        }
        if (!changed) {
            return inputMarkdown;
        }
        return builder.toString();
    }

    private static boolean isDotEnclosedByLettersOrDigits(int arrayIndex, char[] chars) {
        return arrayIndex > 0 && arrayIndex < chars.length - 1 && chars[arrayIndex] == '.' && Character.isLetterOrDigit(chars[arrayIndex - 1]) && Character.isLetterOrDigit(chars[arrayIndex + 1]);
    }
}

