/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings;

import com.teamscale.core.accounts.ExternalCredentials;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public class OutsourcedAnalysisUtils {
    public static ExternalCredentials findFirstCredentialsForTeamscaleServerAt(String targetAddress, List<ExternalCredentials> knownCredentials) throws StorageException {
        URI target = URI.create(OutsourcedAnalysisUtils.ensurePathHasTrailingSlash(targetAddress));
        for (ExternalCredentials credentials : knownCredentials) {
            URI uri;
            try {
                uri = new URI(OutsourcedAnalysisUtils.ensurePathHasTrailingSlash(credentials.uri));
            }
            catch (URISyntaxException e) {
                LogManager.getLogger().debug("Can't parse URI of external credential " + credentials.credentialsName + ": " + credentials.uri);
                continue;
            }
            if (!uri.equals(target)) continue;
            return credentials;
        }
        throw new StorageException("Computing \"outsourced\" analyses for other Teamscale servers was enabled, but credentials for the Teamscale server are not configured on this execution server. Please create an external account with the uri '" + targetAddress + "' (that is the url of the Teamscale server that requested the analysis). It is required to notify the Teamscale server that the results are ready.");
    }

    private static String ensurePathHasTrailingSlash(String path) {
        return StringUtils.ensureEndsWith((String)path, (String)"/");
    }
}

