/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.URIish;

public class UpdaterUtils {
    public static File cloneOrUpdateRepository(String repoUrl, Path targetDir, String version) throws IOException {
        System.out.println("Cloning: " + repoUrl + " to " + String.valueOf(targetDir));
        try (Git git = Git.init().setDirectory(targetDir.toFile()).call();){
            git.remoteAdd().setName("origin").setUri(new URIish(repoUrl)).call();
            git.fetch().setRefSpecs(new String[]{"refs/tags/" + version}).call();
            git.checkout().setName(version).call();
        }
        catch (URISyntaxException | GitAPIException e) {
            throw new IOException("Failed to clone: %s".formatted(repoUrl), e);
        }
        return targetDir.toFile();
    }

    public static JsonNode downloadJsonSchemaFromUrl(String url, boolean preserveNewLine) throws IOException, JsonSerializationException {
        String schema = UpdaterUtils.downloadContentFromUrl(url, preserveNewLine);
        return JsonUtils.deserializeFromJson((String)schema);
    }

    public static String downloadContentFromUrl(String rawUrl, boolean preserveNewLine) throws IOException {
        String content;
        URL url = new URL(rawUrl);
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("accept-encoding", "gzip, deflate, br");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            StringBuilder result = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                result.append(line);
                if (preserveNewLine) {
                    result.append("\n");
                }
                line = reader.readLine();
            }
            content = result.toString();
        }
        return content;
    }
}

