/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.findings.calculation.IFindingsRetriever;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.FindingDelta;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;

public class FindingDeltaCalculator {
    public static FindingDelta computeUnfilteredDelta(String uniformPath, CommitDescriptor start, CommitDescriptor end, boolean numericDeltaOnly, IFindingsRetriever findingsRetriever, FindingsCalculationInfo calculationInfo) throws StorageException {
        Map<String, TrackedFinding> endFindingsAtUniformPath = findingsRetriever.getFindingsById(uniformPath, end);
        Set<String> endFindingIDsExistingAtStart = FindingDeltaCalculator.calculateEndFindingsAtStart(start, findingsRetriever, endFindingsAtUniformPath);
        Map<String, TrackedFinding> startFindingsAtUniformPath = findingsRetriever.getFindingsById(uniformPath, start);
        HashSet commonStartAndEndFindings = CollectionUtils.intersectionSet(startFindingsAtUniformPath.keySet(), (Collection[])new Collection[]{endFindingsAtUniformPath.keySet()});
        Map addedFindings = CollectionUtils.copyWithEntriesRemoved(endFindingsAtUniformPath, endFindingIDsExistingAtStart);
        Map removedFindings = CollectionUtils.copyWithEntriesRemoved(startFindingsAtUniformPath, (Set)commonStartAndEndFindings);
        List<TrackedFinding> findingsInChangedCodeOrSpecItems = FindingDeltaCalculator.getFindingsInChangedCodeOrSpecItems(start.getTimestamp(), end, findingsRetriever, endFindingsAtUniformPath, endFindingIDsExistingAtStart);
        if (!numericDeltaOnly) {
            FindingDeltaCalculator.updateDeathCommits(end, addedFindings.values(), findingsInChangedCodeOrSpecItems, findingsRetriever.getFindingIds(uniformPath, CommitDescriptor.latestOnBranch((String)end.getBranchName())), calculationInfo);
        }
        return FindingDelta.create(addedFindings.values(), findingsInChangedCodeOrSpecItems, removedFindings.values());
    }

    private static @NonNull Set<String> calculateEndFindingsAtStart(CommitDescriptor start, IFindingsRetriever findingsRetriever, Map<String, TrackedFinding> endFindings) throws StorageException {
        List<TrackedFinding> endFindingsThatExistedAtStart = findingsRetriever.getFindings(endFindings.keySet().stream().toList(), start);
        return endFindingsThatExistedAtStart.stream().filter(finding -> finding != null && finding.isAlive()).map(TrackedFinding::getId).collect(Collectors.toSet());
    }

    private static void updateDeathCommits(CommitDescriptor end, Collection<TrackedFinding> filteredAddedFindings, Collection<TrackedFinding> filteredChangedCodeFindings, Set<String> headFindings, FindingsCalculationInfo calculationInfo) throws StorageException {
        HistoryAccessOption accessBranchHead = HistoryAccessOption.readHead((String)end.getBranchName());
        List findingsToUpdate = CollectionUtils.unionList(filteredAddedFindings, (Collection[])new Collection[]{filteredChangedCodeFindings});
        findingsToUpdate = CollectionUtils.filter((Collection)findingsToUpdate, finding -> !headFindings.contains(finding.getId()));
        ((TrackedFindingsByIdIndex)calculationInfo.projectStorageSystem().openProjectIndex(TrackedFindingsByIdIndex.class, accessBranchHead)).updateDeathCommits(findingsToUpdate);
    }

    private static List<TrackedFinding> getFindingsInChangedCodeOrSpecItems(long startTimestamp, CommitDescriptor end, IFindingsRetriever findingsRetriever, Map<String, TrackedFinding> findings, Set<String> commonFindingIDs) throws StorageException {
        List<TrackedFinding> commonFindings = commonFindingIDs.stream().map(findings::get).toList();
        return findingsRetriever.getFindingsInChangedCode(startTimestamp, end, commonFindings);
    }
}

