/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.findings.calculation.AffectedFileDeltaCalculator;
import com.teamscale.index.findings.calculation.TokenElementChurnWithOriginInfo;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.resource.CodeScopesMappingIndex;
import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.index.tracking.index.FindingChurnListIndex;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.index.tracking.index.TrackedFindingsIndex;
import com.teamscale.wia.TeamscaleIssueId;
import com.teamscale.wia.WiaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class FindingsServiceUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    private static Map<UniformPath, List<TrackedFinding>> getFindingsForArchitecture(ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption, UniformPath uniformPath) throws StorageException {
        MetricsToArchitectureMetricsMappingIndex mappingIndex = (MetricsToArchitectureMetricsMappingIndex)projectStorageSystem.openProjectIndex(MetricsToArchitectureMetricsMappingIndex.class, historyAccessOption);
        ContainerIndex containerIndex = (ContainerIndex)projectStorageSystem.openProjectIndex(ContainerIndex.class, "dir", historyAccessOption);
        String codePath = ResourceServiceUtils.getUniformPathPrefixContainerAware(containerIndex, uniformPath.toStringAsMigrationFrontier());
        List<UniformPath> files = ArchitectureMetricsUtils.getLeafPaths(mappingIndex, codePath).stream().map(UniformPathCompatibilityUtil::convert).toList();
        TrackedFindingsIndex findingsIndex = (TrackedFindingsIndex)projectStorageSystem.openProjectIndex(TrackedFindingsIndex.class, historyAccessOption);
        return FindingsServiceUtils.createFindingsResult(files, findingsIndex.getFindings(files));
    }

    private static Map<UniformPath, List<TrackedFinding>> getFindingsForCodeScope(ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption, UniformPath uniformPath) throws StorageException {
        if (uniformPath.isRoot()) {
            return FindingsServiceUtils.getFindingsForCodePath(projectStorageSystem, historyAccessOption, UniformPath.codeRoot());
        }
        CodeScopesMappingIndex codeScopesMappingIndex = (CodeScopesMappingIndex)projectStorageSystem.openProjectIndex(CodeScopesMappingIndex.class, historyAccessOption);
        Set<UniformPath> pathsInCodeScope = codeScopesMappingIndex.getPathsInCodeScope(uniformPath.getCodeScope());
        ArrayList<UniformPath> files = new ArrayList<UniformPath>();
        UniformPath codePath = uniformPath.resolveToCodePath();
        for (UniformPath path : pathsInCodeScope) {
            if (!codePath.equals((Object)path) && !codePath.hasDescendant(path)) continue;
            files.add(path);
        }
        TrackedFindingsIndex findingsIndex = (TrackedFindingsIndex)projectStorageSystem.openProjectIndex(TrackedFindingsIndex.class, historyAccessOption);
        return FindingsServiceUtils.createFindingsResult(files, findingsIndex.getFindings(files));
    }

    private static Map<UniformPath, List<TrackedFinding>> createFindingsResult(List<UniformPath> files, List<List<TrackedFinding>> findingsForFiles) {
        LinkedHashMap<UniformPath, List<TrackedFinding>> findings = LinkedHashMap.newLinkedHashMap(files.size());
        CollectionUtils.forEach(files, findingsForFiles, (file, findingsList) -> {
            if (findingsList == null) {
                LOGGER.warn("Encountered null entry in TrackedFindingsIndex for path: " + String.valueOf(file) + ". Did the FindingsTracker crash previously? Using empty list.");
                findings.put((UniformPath)file, (List<TrackedFinding>)CollectionUtils.emptyList());
                return;
            }
            findings.put((UniformPath)file, (List<TrackedFinding>)findingsList);
        });
        return findings;
    }

    public static Map<UniformPath, List<TrackedFinding>> getFindingsVirtualPathAware(ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption, UniformPath uniformPath) throws StorageException {
        if (uniformPath.isCodeScopePath()) {
            return FindingsServiceUtils.getFindingsForCodeScope(projectStorageSystem, historyAccessOption, uniformPath);
        }
        if (uniformPath.isArchitecturePath()) {
            return FindingsServiceUtils.getFindingsForArchitecture(projectStorageSystem, historyAccessOption, uniformPath);
        }
        return FindingsServiceUtils.getFindingsForCodePath(projectStorageSystem, historyAccessOption, uniformPath);
    }

    private static Map<UniformPath, List<TrackedFinding>> getFindingsForCodePath(ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption, UniformPath uniformPath) throws StorageException {
        TrackedFindingsIndex findingsIndex = (TrackedFindingsIndex)projectStorageSystem.openProjectIndex(TrackedFindingsIndex.class, historyAccessOption);
        return findingsIndex.getFindingsWithKeyPrefix(uniformPath);
    }

    public static Optional<FindingChurnList> getBlacklistAwareFindingChurnForIssue(ProjectStorageSystem projectStorageSystem, TeamscaleIssueId issueId, String branch, RepositoryCommitIssueMappingIndex mappingIndex, boolean removeResolvedFindings) throws StorageException {
        List<CommitDescriptor> issueCommits = mappingIndex.getCommitsForIssue(issueId);
        if (issueCommits == null || issueCommits.isEmpty()) {
            return Optional.empty();
        }
        FindingChurnListIndex findingChurnListIndex = (FindingChurnListIndex)projectStorageSystem.openProjectIndex(FindingChurnListIndex.class, null);
        List findingChurnLists = findingChurnListIndex.getEntries(issueCommits);
        Optional<FindingChurnList> aggregated = FindingChurnList.aggregate(findingChurnLists);
        if (aggregated.isEmpty()) {
            return aggregated;
        }
        FindingBlacklistIndex blacklistIndex = (FindingBlacklistIndex)projectStorageSystem.openProjectIndex(FindingBlacklistIndex.class, HistoryAccessOption.readHead((String)branch));
        aggregated = Optional.of(FindingsServiceUtils.removeBlacklistedFindings(aggregated.get(), blacklistIndex));
        if (removeResolvedFindings) {
            FindingsServiceUtils.updateDeathCommitsAndLocations(projectStorageSystem, branch, aggregated.get());
            aggregated.get().removeResolvedFindings();
        }
        return aggregated;
    }

    public static Optional<FindingChurnList> getFindingChurnForIssue(TeamscaleIssueId issueId, FindingChurnListIndex findingChurnListIndex, RepositoryCommitIssueMappingIndex mappingIndex) throws StorageException {
        List<CommitDescriptor> issueCommits = mappingIndex.getCommitsForIssue(issueId);
        if (issueCommits == null || issueCommits.isEmpty()) {
            return Optional.empty();
        }
        List findingChurnLists = findingChurnListIndex.getEntries(new ArrayList<CommitDescriptor>(issueCommits));
        return FindingChurnList.aggregate(findingChurnLists);
    }

    private static FindingChurnList removeBlacklistedFindings(FindingChurnList findingChurnList, FindingBlacklistIndex blacklistIndex) {
        try {
            HashSet<String> idsOfBlacklistedFindings = new HashSet<String>(blacklistIndex.getAllFindingIds());
            return FindingChurnList.cloneWithRemovedFindings(findingChurnList, idsOfBlacklistedFindings);
        }
        catch (StorageException e) {
            LOGGER.error("Could not retrieve flagged findings", (Throwable)e);
            return findingChurnList;
        }
    }

    public static String buildFindingURL(TrackedFinding finding, IProjectId projectId, GlobalStorageSystem globalStorageSystem) throws StorageException {
        String baseUrl = BaseUrlOption.getBaseUrl((GlobalStorageSystem)globalStorageSystem);
        if (baseUrl != null) {
            PublicProjectId primaryPublicId = ProjectUtils.resolveToPrimaryPublicId((IProjectId)projectId, (GlobalStorageSystem)globalStorageSystem);
            return new TeamscaleCommitLinkProvider(baseUrl, primaryPublicId, null).createFindingsDetailLink(finding.getId());
        }
        return null;
    }

    public static void updateDeathCommitsAndLocations(ProjectStorageSystem projectStorageSystem, String branch, FindingChurnList findingChurnList) throws StorageException {
        UnmodifiableList<TrackedFinding> addedFindings = findingChurnList.getAddedFindings();
        UnmodifiableList<TrackedFinding> findingsInChangedCode = findingChurnList.getFindingsInChangedCode();
        if (addedFindings.isEmpty() && findingsInChangedCode.isEmpty()) {
            return;
        }
        ArrayList allFindings = CollectionUtils.unionList(addedFindings, (Collection[])new Collection[]{findingsInChangedCode});
        HistoryAccessOption accessBranchHead = HistoryAccessOption.readHead((String)branch);
        ((TrackedFindingsByIdIndex)projectStorageSystem.openProjectIndex(TrackedFindingsByIdIndex.class, accessBranchHead)).updateFindingProperties(allFindings, (oldFinding, currentFinding) -> {
            TrackedFindingsByIdIndex.updateDeathCommitIfSet(oldFinding, currentFinding);
            oldFinding.setLocation(currentFinding.getLocation());
        });
    }

    public static @Nullable FindingChurnList getFindingChurnListForCommits(List<CommitDescriptor> commits, FindingChurnListIndex findingChurnListIndex) throws StorageException {
        return FindingChurnList.aggregate(findingChurnListIndex.getEntries(commits)).orElse(null);
    }

    public static List<TokenElementChurnWithOriginInfo> getSpecItemChurn(Set<String> possibleSpecItemBranches, ProjectStorageSystem projectStorageSystem, long startTimestamp, long endTimestamp) throws StorageException {
        ArrayList<TokenElementChurnWithOriginInfo> result = new ArrayList<TokenElementChurnWithOriginInfo>();
        for (String specItemBranch : possibleSpecItemBranches) {
            EChangeEntryOrigin modifiedChangeOrigin = FindingsServiceUtils.getChangeEntryOrigin(specItemBranch);
            result.addAll(AffectedFileDeltaCalculator.calculateTokenElementChurnWithOriginInfo(UniformPath.ofSegments((UniformPath.EType)UniformPath.EType.SPEC_ITEM, (String[])new String[0]), new CommitDescriptor(specItemBranch, startTimestamp), new CommitDescriptor(specItemBranch, endTimestamp), modifiedChangeOrigin, projectStorageSystem));
        }
        return result;
    }

    private static EChangeEntryOrigin getChangeEntryOrigin(String specItemBranch) {
        if (WiaUtils.isWorkItemConnectorBranch((String)specItemBranch)) {
            return EChangeEntryOrigin.ISSUE_UPDATE;
        }
        return EChangeEntryOrigin.REPOSITORY_COMMIT;
    }
}

