/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.findings.calculation.FindingsServiceUtils;
import com.teamscale.index.findings.calculation.IFindingsRetriever;
import com.teamscale.index.findings.calculation.SpecItemUtils;
import com.teamscale.index.findings.calculation.TokenElementChurnInfo;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.index.tracking.index.TrackedFindingsIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class SpecItemFindingsRetriever
implements IFindingsRetriever {
    private final ProjectStorageSystem projectStorageSystem;
    private final Set<String> possibleSpecItemBranches;

    public static SpecItemFindingsRetriever create(String codeBranch, PublicProjectId publicProjectId, IndexLayer indexLayer, ProjectStorageSystem projectStorageSystem) throws StorageException {
        Set<String> possibleSpecItemBranches = SpecItemUtils.getPossibleSpecItemBranches(codeBranch, publicProjectId, indexLayer);
        return new SpecItemFindingsRetriever(projectStorageSystem, possibleSpecItemBranches);
    }

    private SpecItemFindingsRetriever(ProjectStorageSystem projectStorageSystem, Set<String> possibleSpecItemBranches) {
        this.projectStorageSystem = projectStorageSystem;
        this.possibleSpecItemBranches = possibleSpecItemBranches;
    }

    @Override
    public List<TrackedFinding> getFindings(@NonNull String uniformPath, @NonNull CommitDescriptor commit) throws StorageException {
        if (uniformPath.isEmpty()) {
            uniformPath = UniformPath.EType.SPEC_ITEM.getPrefix();
        }
        UniformPath finalUniformPath = UniformPathCompatibilityUtil.convert((String)uniformPath);
        ArrayList<TrackedFinding> findings = new ArrayList<TrackedFinding>();
        this.forEachSpecItemBranch(commit, historyAccessOption -> {
            TrackedFindingsIndex findingsIndex = (TrackedFindingsIndex)this.projectStorageSystem.openProjectIndex(TrackedFindingsIndex.class, historyAccessOption);
            List specItemFindingsForCommit = findingsIndex.getFindingsWithKeyPrefix(finalUniformPath).values().stream().flatMap(Collection::stream).toList();
            findings.addAll(specItemFindingsForCommit);
        });
        return findings;
    }

    @Override
    public List<@Nullable TrackedFinding> getFindings(List<String> findingIds, @NonNull CommitDescriptor commit) throws StorageException {
        ArrayList<TrackedFinding> result = new ArrayList<TrackedFinding>();
        this.forEachSpecItemBranch(commit, historyAccessOption -> {
            TrackedFindingsByIdIndex index = (TrackedFindingsByIdIndex)this.projectStorageSystem.openProjectIndex(TrackedFindingsByIdIndex.class, historyAccessOption);
            List<TrackedFinding> findings = index.getFindings(findingIds);
            result.addAll(findings.stream().filter(Objects::nonNull).toList());
        });
        return result;
    }

    @Override
    public <T extends TrackedFinding> List<T> getFindingsInChangedCode(long startTimestamp, @NonNull CommitDescriptor end, List<T> commonFindings) throws StorageException {
        return this.getFindingsInChangedSpecItems(startTimestamp, end.getTimestamp(), commonFindings);
    }

    @Override
    public Map<String, FindingBlacklistInfo> getFlaggedFindings(Collection<TrackedFinding> findings, @NonNull CommitDescriptor commit) throws StorageException {
        List findingIds = CollectionUtils.map(findings, TrackedFinding::getId);
        HashMap<String, FindingBlacklistInfo> blackListedEntries = new HashMap<String, FindingBlacklistInfo>();
        this.forEachSpecItemBranch(commit, historyAccessOption -> {
            FindingBlacklistIndex blacklistIndex = (FindingBlacklistIndex)this.projectStorageSystem.openProjectIndex(FindingBlacklistIndex.class, historyAccessOption);
            List blacklistInfos = CollectionUtils.filter(blacklistIndex.getBlacklistInfos(findingIds), Objects::nonNull);
            for (FindingBlacklistInfo blacklistInfo : blacklistInfos) {
                blackListedEntries.put(blacklistInfo.getFindingId(), blacklistInfo);
            }
        });
        return blackListedEntries;
    }

    private <T extends TrackedFinding> List<T> getFindingsInChangedSpecItems(long startTimestamp, long endTimestamp, List<T> commonFindings) throws StorageException {
        Map uniformPathToSpecItemChurnMapping = FindingsServiceUtils.getSpecItemChurn(this.possibleSpecItemBranches, this.projectStorageSystem, startTimestamp, endTimestamp).stream().collect(Collectors.toMap(TokenElementChurnInfo::getUniformPath, Function.identity()));
        EnumSet<EElementHistoryChangeType> specItemChangeTypes = EnumSet.of(EElementHistoryChangeType.EDIT, EElementHistoryChangeType.MOVE, EElementHistoryChangeType.COPY);
        ArrayList<TrackedFinding> findingsInChangedSpecItems = new ArrayList<TrackedFinding>();
        for (TrackedFinding finding : commonFindings) {
            TokenElementChurnInfo specItemChurn = (TokenElementChurnInfo)uniformPathToSpecItemChurnMapping.get(finding.getLocation().getUniformPath());
            if (specItemChurn == null || !specItemChangeTypes.contains((Object)specItemChurn.getChangeType())) continue;
            findingsInChangedSpecItems.add(finding);
        }
        return findingsInChangedSpecItems;
    }

    private <T extends Exception> void forEachSpecItemBranch(CommitDescriptor commit, ConsumerWithException<HistoryAccessOption, T> consumer) throws T {
        for (String possibleConnectorBranch : this.possibleSpecItemBranches) {
            HistoryAccessOption historyAccessOption = HistoryAccessOption.readTimestamp((String)possibleConnectorBranch, (long)commit.getTimestamp());
            consumer.accept((Object)historyAccessOption);
        }
    }
}

