/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.concurrency.WrappedExecutorServiceProducer;
import com.teamscale.core.log.parse.EParseLogOrigin;
import com.teamscale.core.log.parse.ParseLogEntry;
import com.teamscale.index.findings.ClangTidyAndCppcheckRunnerBase;
import com.teamscale.index.findings.CppFileUtils;
import com.teamscale.index.findings.CppIncludeHandler;
import com.teamscale.index.findings.CppIntegratedToolUtils;
import com.teamscale.index.findings.CppToolAnalysisTokenElementDetails;
import com.teamscale.index.findings.IntegratedToolUtils;
import com.teamscale.index.findings.clangtidy.ClangTidyOutputParser;
import com.teamscale.index.findings.clangtidy.ProcessWrapper;
import com.teamscale.index.findings.clangtidy.ShallowCodeFileRepresentation;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyResultsTransport;
import com.teamscale.index.findings.cppcheck.LineOffsetConverterCache;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.util.ParseLogMessage;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.logging.log4j.message.Message;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;

public class ClangTidyRunner
extends ClangTidyAndCppcheckRunnerBase {
    private static final String CLANG_DIAGNOSTIC_ERROR = "clang-diagnostic-error";
    private static final String CLANG_DIAGNOSTIC_PREFIX = "clang-diagnostic-";
    public static final String CLANG_TIDY_EXE_VM_PROPERTY_NAME = "com.teamscale.clang-tidy-exe";
    static final String CLANG_TIDY_MAX_PARALLEL_PROCESSES_VM_OPTION = "com.teamscale.clang-tidy.max-num-parallel-processes";
    static final int CLANG_TIDY_MAX_PARALLEL_PROCESSES_DEFAULT = 5;
    private static final String CLANG_TIDY_PROCESS_TIMEOUT_VM_OPTION = "com.teamscale.clang-tidy.process_timeout_minutes";
    private static final String CLANG_TIDY_PROCESS_TIMEOUT_DEFAULT = "7";
    private static final String BACKUP_TIMEOUT_SETUPS_JVM_PROPERTY_NAME = "com.teamscale.debug.clang-tidy.timeout.setup_backup_dir";
    private static final File SETUP_BACKUP_DIRECTORY = Optional.ofNullable(System.getProperty("com.teamscale.debug.clang-tidy.timeout.setup_backup_dir")).map(File::new).orElse(null);
    public static final ExecutorService CLANG_TIDY_JOB_EXECUTOR = WrappedExecutorServiceProducer.newFixedThreadPool((int)Integer.getInteger("com.teamscale.clang-tidy.max-num-parallel-processes", 5));
    private static final String VFSOVERLAY_YAML_FILE_NAME = "vfsoverlay.yaml";
    private static final String COMPILE_COMMANDS_FILE_NAME = "compile_commands.json";
    private static final String CLANG_TIDY_CHECK_CONFIG_FILE = ".clang-tidy";
    public static final String CLANG_TIDY_COMMAND_TXT_FILE_NAME = "ClangTidyCommand.txt";
    private static final Pattern WARNING_ERROR_NUMBER_LINE = Pattern.compile("(\\d+ warning(s)?)?( and )?(\\d+ error(s)?)? generated.");
    private static final Pattern ERROR_WHILE_PROCESSING = Pattern.compile("Error while processing .*");
    private static final Pattern SUPPRESSED_WARNING = Pattern.compile("Suppressed \\d+ warning.*");
    private static final Charset CHARSET = FileSystemUtils.SYSTEM_CHARSET;
    private final CodeScopeAware<Map<String, String>> checkOptionsPerCodeScope;
    private final List<ParseLogEntry> parseLogEntries = Collections.synchronizedList(new ArrayList());

    public ClangTidyRunner(CodeScopeAware<Map<String, String>> checkOptionsPerCodeScope) throws StorageException {
        this.checkOptionsPerCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : checkOptionsPerCodeScope.getCodeScopeNames()) {
            this.checkOptionsPerCodeScope.setValue(codeScopeName, (Object)ImmutableMap.copyOf((Map)((Map)checkOptionsPerCodeScope.getValue(codeScopeName))));
        }
    }

    public Map<String, List<IndexFinding>> prepareAndRunClangTidy(List<BasicTokenElementInfo> filesToAnalyze, File tempDirectory, CodeScopeAware<Map<ELanguage, String>> checkSelectorByLanguage, CodeScopeAware<List<String>> globalCompilerArgumentsPerCodeScope, boolean dryRun, CppIncludeHandler includeHandler, CppToolAnalysisTokenElementDetails tokenElementDetails) throws IOException, StorageException {
        HashMap<String, List<IndexFinding>> findings = new HashMap<String, List<IndexFinding>>();
        Map<String, Set<CppIncludeHandler.IncludeFile>> relevantIncludeFilesMap = ClangTidyRunner.computeRelevantIncludeFilesMap(filesToAnalyze, includeHandler, tokenElementDetails.includePathDetails());
        File codeDirectory = new File(tempDirectory, "code");
        FileSystemUtils.ensureDirectoryExists((File)codeDirectory);
        Map<String, ShallowCodeFileRepresentation> fileContents = ClangTidyRunner.loadFileContents(filesToAnalyze, relevantIncludeFilesMap, includeHandler);
        ClangTidyRunner.writeFiles(fileContents.values(), codeDirectory);
        LineOffsetConverterCache lineOffsetConverterCache = new LineOffsetConverterCache(fileContents);
        ArrayList<Callable<Void>> clangTidyJobs = new ArrayList<Callable<Void>>();
        for (int i = 0; i < filesToAnalyze.size(); ++i) {
            String checkName = "check_" + i;
            BasicTokenElementInfo element = filesToAnalyze.get(i);
            CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(element);
            Set<CppIncludeHandler.IncludeFile> relevantIncludeFiles = relevantIncludeFilesMap.getOrDefault(element.getUniformPath(), Collections.emptySet());
            String selectedChecks = (String)((Map)checkSelectorByLanguage.getValue(codeScopeName)).get(element.getLanguage());
            List<String> compilerArguments = ClangTidyRunner.concatenateCompilerArguments(includeHandler.determineCompilerCommands(element, relevantIncludeFiles, tokenElementDetails, false), (List)globalCompilerArgumentsPerCodeScope.getValue(codeScopeName));
            Supplier<Void> clangTidyJob = () -> this.setupConfigAndRunForElement(selectedChecks, dryRun, findings, codeDirectory, relevantIncludeFiles, new File(tempDirectory, checkName), compilerArguments, (ShallowCodeFileRepresentation)fileContents.get(element.getUniformPath()), (Map)this.checkOptionsPerCodeScope.getValue(codeScopeName), lineOffsetConverterCache);
            if (dryRun) {
                clangTidyJob.get();
                continue;
            }
            clangTidyJobs.add(clangTidyJob::get);
        }
        if (!clangTidyJobs.isEmpty()) {
            ClangTidyRunner.executeJobsInParallel(clangTidyJobs, CLANG_TIDY_JOB_EXECUTOR, "clang-tidy");
        }
        return findings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void setupConfigAndRunForElement(String checkSelector, boolean dryRun, Map<String, List<IndexFinding>> findings, File codeDirectory, Set<CppIncludeHandler.IncludeFile> relevantIncludeFiles, File checkDirectory, List<String> compilerCommandAndArguments, ShallowCodeFileRepresentation analyzedFile, Map<String, String> checkOptions, LineOffsetConverterCache lineOffsetConverterCache) {
        try {
            List<ClangTidyOutputParser.ClangTidyResultItem> resultItems = this.runClangTidyOnElement(checkDirectory, checkSelector, dryRun, codeDirectory, relevantIncludeFiles, compilerCommandAndArguments, analyzedFile.uniformPath(), checkOptions);
            ArrayList<ParseLogMessage> parseLogMessages = new ArrayList<ParseLogMessage>();
            List findingsOnElement = CollectionUtils.map(ClangTidyRunner.convertClangTidyResultsToFindings(codeDirectory, resultItems, parseLogMessages, analyzedFile, lineOffsetConverterCache), ClangTidyResultsTransport.ClangTidyFindingTransport::asIndexFinding);
            parseLogMessages.forEach(ClangTidyRunner::logParseLogMessageToParseLog);
            Map<String, List<IndexFinding>> map = findings;
            synchronized (map) {
                findings.computeIfAbsent(analyzedFile.uniformPath(), k -> new ArrayList()).addAll(findingsOnElement);
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException while running clang-tidy for uniform path " + analyzedFile.uniformPath(), (Throwable)e);
        }
        return null;
    }

    public List<ClangTidyOutputParser.ClangTidyResultItem> runClangTidyOnElement(File checkDirectory, String checkSelector, boolean dryRun, File codeDirectory, Set<CppIncludeHandler.IncludeFile> relevantIncludeFiles, List<String> compilerCommandAndArguments, String uniformPath, Map<String, String> checkOptionsInCurrentCodeScope) throws IOException {
        FileSystemUtils.ensureDirectoryExists((File)checkDirectory);
        String mainFile = CppFileUtils.determineTargetFilePathForProcessBuilder(uniformPath, codeDirectory);
        File virtualFileSystemFile = this.writeClangTidyRunConfigFiles(checkSelector, codeDirectory, checkDirectory, mainFile, relevantIncludeFiles, compilerCommandAndArguments, checkOptionsInCurrentCodeScope);
        ProcessWrapper process = ClangTidyRunner.createProcessWrapperAndWriteCommandFile(mainFile, virtualFileSystemFile, checkDirectory);
        if (dryRun) {
            return Collections.emptyList();
        }
        List<ClangTidyOutputParser.ClangTidyResultItem> resultItems = ClangTidyRunner.runClangTidy(process, mainFile, checkDirectory, codeDirectory);
        return resultItems;
    }

    private File writeClangTidyRunConfigFiles(String checkSelector, File codeDirectory, File checkDirectory, String mainFile, Set<CppIncludeHandler.IncludeFile> relevantIncludeFiles, List<String> compilerCommandAndArguments, Map<String, String> checkOptionsInCurrentCodeScope) throws IOException {
        File virtualFileSystemFile = ClangTidyRunner.writeVirtualOverlayFileSystemFile(mainFile, relevantIncludeFiles, codeDirectory, checkDirectory);
        ClangTidyRunner.writeClangTidyConfig(checkDirectory, checkSelector, checkOptionsInCurrentCodeScope);
        File compilationCommand = new File(checkDirectory, COMPILE_COMMANDS_FILE_NAME);
        CppIncludeHandler.writeCompilationDb(checkDirectory, compilationCommand, compilerCommandAndArguments, mainFile, CHARSET);
        return virtualFileSystemFile;
    }

    private static List<ClangTidyOutputParser.ClangTidyResultItem> runClangTidy(ProcessWrapper process, String mainFile, File checkDirectory, File codeDirectory) {
        int returnCode;
        ArrayList<ClangTidyOutputParser.ClangTidyResultItem> resultItems = new ArrayList<ClangTidyOutputParser.ClangTidyResultItem>();
        process.setOutputConsumer(line -> {
            Optional<ClangTidyOutputParser.ClangTidyResultItem> resultItem = ClangTidyOutputParser.parseIssue(line);
            resultItem.ifPresent(resultItems::add);
        });
        StringBuilder errorLog = new StringBuilder();
        process.setErrorConsumer(line -> errorLog.append((String)line).append('\n'));
        int timeoutMinutes = ClangTidyRunner.determineClangProcessTimeoutMinutes();
        try {
            returnCode = process.runWithTimeoutException(timeoutMinutes);
        }
        catch (TimeoutException e) {
            IntegratedToolUtils.reportTimeout(e.getMessage(), errorLog.toString(), mainFile, List.of(checkDirectory, codeDirectory), "clang-tidy", SETUP_BACKUP_DIRECTORY);
            return Collections.emptyList();
        }
        if (returnCode != 0 && !errorLog.isEmpty()) {
            String completeErrorLog = errorLog.toString();
            String reducedErrorLog = ClangTidyRunner.filterErrorLog(completeErrorLog);
            if (!reducedErrorLog.isEmpty()) {
                LOGGER.warn("Received errors from clang-tidy on file {}:\n{}", (Object)mainFile, (Object)reducedErrorLog);
            }
            LOGGER.debug("Full clang-tidy error log on file {}:\n{}", (Object)mainFile, (Object)completeErrorLog);
        }
        if (returnCode != -1) {
            return resultItems;
        }
        return Collections.emptyList();
    }

    private static int determineClangProcessTimeoutMinutes() {
        String optionValue = System.getProperty(CLANG_TIDY_PROCESS_TIMEOUT_VM_OPTION, CLANG_TIDY_PROCESS_TIMEOUT_DEFAULT);
        try {
            return Integer.parseInt(optionValue);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Could not parse the value of the VM option com.teamscale.clang-tidy.process_timeout_minutes as an integer. This must be a timeout (positive integer) in minutes. The value is `" + optionValue + "`.");
        }
    }

    private static ProcessWrapper createProcessWrapperAndWriteCommandFile(String mainFile, File virtualFileSystemFile, File checkDir) throws IOException {
        String clangTidyExe = ClangTidyRunner.loadConfiguredClangTidyExe();
        ProcessWrapper process = new ProcessWrapper(clangTidyExe);
        process.setWorkingDirectory(checkDir);
        String checkDirectoryPath = checkDir.getAbsolutePath();
        process.addArgument("-p");
        process.addArgument(checkDirectoryPath);
        process.addArgument("--config-file=" + FileSystemUtils.concatenatePaths((String)checkDirectoryPath, (String[])new String[]{CLANG_TIDY_CHECK_CONFIG_FILE}));
        process.addArgument("--vfsoverlay=" + virtualFileSystemFile.getAbsolutePath());
        process.addArgument("--header-filter=.*");
        process.addArgument(CppFileUtils.makeOsSpecificPath(mainFile));
        FileSystemUtils.writeFile((File)new File(checkDir, CLANG_TIDY_COMMAND_TXT_FILE_NAME), (String)("This is the command we use to run clang tidy (using this folder as working directory):\n" + process.getCommand()), (Charset)StandardCharsets.UTF_8);
        return process;
    }

    private static String filterErrorLog(String completeErrorLog) {
        StringBuilder reducedLog = new StringBuilder();
        for (String line : StringUtils.splitLines((String)completeErrorLog)) {
            if (WARNING_ERROR_NUMBER_LINE.matcher(line).matches() || ERROR_WHILE_PROCESSING.matcher(line).matches() || SUPPRESSED_WARNING.matcher(line).matches() || line.startsWith("Error reading configuration from ") && line.endsWith("directory doesn't exist.") || line.startsWith("Use -header-filter=.* to ") || line.equals("Found compiler error(s).")) continue;
            if (reducedLog.length() >= 0) {
                reducedLog.append('\n');
            }
            reducedLog.append(line);
        }
        return reducedLog.toString();
    }

    private static void writeClangTidyConfig(File checkDirectory, String checkSelector, Map<String, String> checkOptions) throws IOException {
        JsonNodeFactory factory = new JsonNodeFactory(false);
        ObjectNode jsonRoot = factory.objectNode();
        jsonRoot.set("Checks", (JsonNode)factory.textNode(checkSelector));
        ArrayNode optionsNode = factory.arrayNode();
        jsonRoot.set("CheckOptions", (JsonNode)optionsNode);
        for (Map.Entry<String, String> option : checkOptions.entrySet()) {
            ObjectNode optionNode = factory.objectNode();
            optionsNode.add((JsonNode)optionNode);
            optionNode.set("key", (JsonNode)factory.textNode(option.getKey()));
            optionNode.set("value", (JsonNode)factory.textNode(option.getValue()));
        }
        File configFile = new File(checkDirectory, CLANG_TIDY_CHECK_CONFIG_FILE);
        FileSystemUtils.writeFile((File)configFile, (String)jsonRoot.toPrettyString(), (Charset)CHARSET);
    }

    private static File writeVirtualOverlayFileSystemFile(String mainFile, Set<CppIncludeHandler.IncludeFile> includeFiles, File codeDirectory, File checkDirectory) throws IOException {
        JsonNodeFactory factory = new JsonNodeFactory(false);
        ObjectNode jsonRoot = factory.objectNode();
        jsonRoot.set("version", (JsonNode)factory.numberNode(0));
        ArrayNode dirRootsNode = factory.arrayNode();
        jsonRoot.set("roots", (JsonNode)dirRootsNode);
        ObjectNode virtualCodeRoot = factory.objectNode();
        dirRootsNode.add((JsonNode)virtualCodeRoot);
        virtualCodeRoot.set("name", (JsonNode)factory.textNode(checkDirectory.getAbsolutePath()));
        virtualCodeRoot.set("type", (JsonNode)factory.textNode("directory"));
        ArrayNode codeRootContents = factory.arrayNode();
        virtualCodeRoot.set("contents", (JsonNode)codeRootContents);
        HashMap<String, JsonNode> directoryNodeCache = new HashMap<String, JsonNode>();
        ClangTidyRunner.insertFileInVirtualFsOverlay(FileSystemUtils.normalizeSeparatorsPlatformIndependently((String)mainFile), codeRootContents, factory, codeDirectory, directoryNodeCache);
        for (CppIncludeHandler.IncludeFile includeFile : includeFiles) {
            ClangTidyRunner.insertFileInVirtualFsOverlay(includeFile.uniformPath(), codeRootContents, factory, codeDirectory, directoryNodeCache);
        }
        File targetFile = new File(checkDirectory, VFSOVERLAY_YAML_FILE_NAME);
        FileSystemUtils.writeFile((File)targetFile, (String)jsonRoot.toPrettyString(), (Charset)CHARSET);
        return targetFile;
    }

    private static void insertFileInVirtualFsOverlay(String uniformPath, ArrayNode dirRootsNode, JsonNodeFactory factory, File codeDirectory, Map<String, JsonNode> directoryNodeCache) {
        String filePath = UniformPathUtils.cleanPath((String)uniformPath);
        String[] pathSegments = filePath.split("/");
        ArrayNode currentParentNode = dirRootsNode;
        for (int i = 0; i < pathSegments.length; ++i) {
            if (i == pathSegments.length - 1) {
                ObjectNode fileNode = factory.objectNode();
                fileNode.set("name", (JsonNode)factory.textNode(pathSegments[i]));
                fileNode.set("type", (JsonNode)factory.textNode("file"));
                fileNode.set("external-contents", (JsonNode)factory.textNode(codeDirectory.getAbsolutePath() + File.separator + filePath.replace('/', File.separatorChar)));
                currentParentNode.add((JsonNode)fileNode);
                continue;
            }
            String directoryName = pathSegments[i];
            String subPath = StringUtils.concat(Arrays.asList(pathSegments).subList(0, i + 1), (String)String.valueOf('/'));
            JsonNode currentDirectoryNode = directoryNodeCache.get(subPath);
            if (currentDirectoryNode == null) {
                currentDirectoryNode = factory.objectNode();
                ((ObjectNode)currentDirectoryNode).set("name", (JsonNode)factory.textNode(directoryName));
                ((ObjectNode)currentDirectoryNode).set("type", (JsonNode)factory.textNode("directory"));
                ((ObjectNode)currentDirectoryNode).set("contents", (JsonNode)factory.arrayNode());
                currentParentNode.add(currentDirectoryNode);
                directoryNodeCache.put(subPath, currentDirectoryNode);
            }
            currentParentNode = (ArrayNode)currentDirectoryNode.findValue("contents");
        }
    }

    public static List<ClangTidyResultsTransport.ClangTidyFindingTransport> convertClangTidyResultsToFindings(File codeDir, List<ClangTidyOutputParser.ClangTidyResultItem> resultItems, List<ParseLogMessage> parseLogMessages, ShallowCodeFileRepresentation analyzedFile, LineOffsetConverterCache lineOffsetConverterCache) {
        if (resultItems.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ClangTidyResultsTransport.ClangTidyFindingTransport> findings = new ArrayList<ClangTidyResultsTransport.ClangTidyFindingTransport>();
        String expectedPath = codeDir.getAbsolutePath() + File.separator + CppFileUtils.makeOsSpecificPath(analyzedFile.uniformPath());
        boolean crossFileAnalysisEnabled = EFeatureToggle.ENABLE_CLANG_TIDY_CPPCHECK_CROSS_FILE_ANALYSIS.isEnabled();
        for (ClangTidyOutputParser.ClangTidyResultItem resultItem : resultItems) {
            Optional<LineOffsetConverter> lineOffsetConverter;
            if (StringUtils.isEmpty((String)resultItem.sourceFile)) continue;
            if (CLANG_DIAGNOSTIC_ERROR.equals(resultItem.checkId)) {
                parseLogMessages.add(ClangTidyRunner.determineParseLogMessage(codeDir, analyzedFile.uniformPath(), expectedPath, resultItem));
                continue;
            }
            if (resultItem.checkId.startsWith(CLANG_DIAGNOSTIC_PREFIX)) continue;
            String findingPath = StringUtils.stripPrefix((String)UniformPathUtils.normalizeAllSeparators((String)StringUtils.stripPrefix((String)ClangTidyRunner.resolveSourceFilePath(resultItem.sourceFile), (String)codeDir.getAbsolutePath())), (String)"/");
            if ((CppIntegratedToolUtils.isReanalyzeOnHeaderChangeAnalysisDisabled() || !crossFileAnalysisEnabled) && !analyzedFile.uniformPath().equals(findingPath) || (lineOffsetConverter = lineOffsetConverterCache.getLineOffsetConverter(findingPath)).isEmpty()) continue;
            int line = resultItem.lineNumber;
            TextRegionLocation location = new TextRegionLocation(findingPath, lineOffsetConverter.get().getOffset(line), lineOffsetConverter.get().getOffset(line + 1) - 1, line, line);
            String message = MarkupUtils.escapeMarkdownRelevantSymbols((String)resultItem.message);
            message = StringUtils.truncateWithEllipsis((String)message, (int)1000);
            ClangTidyResultsTransport.ClangTidyFindingTransport finding = new ClangTidyResultsTransport.ClangTidyFindingTransport(resultItem.checkId, "clang-tidy", message, location, analyzedFile.language(), analyzedFile.codeScopeName().name());
            findings.add(finding);
        }
        return findings;
    }

    private static String resolveSourceFilePath(String sourceFilePath) {
        return Path.of(sourceFilePath, new String[0]).normalize().toString();
    }

    public static void logParseLogMessageToParseLog(ParseLogMessage parseLogMessage) {
        LOGGER.info(ShallowParsingUtils.PARSE_LOG_ENTRY_MARKER, (Message)parseLogMessage);
    }

    private static ParseLogMessage determineParseLogMessage(File codeDir, String uniformPath, String expectedPath, ClangTidyOutputParser.ClangTidyResultItem resultItem) {
        String path = StringUtils.stripPrefix((String)ClangTidyRunner.resolveSourceFilePath(resultItem.sourceFile), (String)codeDir.getAbsolutePath());
        path = UniformPathUtils.normalizeAllSeparators((String)path);
        if (!expectedPath.equals(resultItem.sourceFile)) {
            return new ParseLogMessage(EParseLogOrigin.CLANG_TIDY.name(), path + ":" + resultItem.lineNumber + ": " + resultItem.message, uniformPath, 1);
        }
        int line = resultItem.lineNumber;
        return new ParseLogMessage(EParseLogOrigin.CLANG_TIDY.name(), path + ": " + resultItem.message, uniformPath, line);
    }

    public List<ParseLogEntry> getParseLogEntries() {
        return this.parseLogEntries;
    }

    public static Pair<Integer, String> determineClangTidyVersion() {
        return IntegratedToolUtils.getNonAnalysisCommandLineOutput(ClangTidyRunner.loadConfiguredClangTidyExe(), "--version");
    }

    public static String loadConfiguredClangTidyExe() {
        return System.getProperty(CLANG_TIDY_EXE_VM_PROPERTY_NAME, "clang-tidy-17");
    }
}

