/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.golangcilint;

import com.teamscale.index.findings.golangcilint.GoLangCILintConfigurationFile;
import com.teamscale.index.findings.golangcilint.GoLangCILintException;
import com.teamscale.index.findings.golangcilint.GoLangCILintSynchronizer;
import eu.cqse.check.framework.core.option.EToolCheckOptionType;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

public class GoLangCILintUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CHECK_ID_PREFIX = "golang";

    public static GoLangCILintConfigurationFile generateConfiguration(List<String> selectedChecks, List<String> selectedOptions, List<String> checkOptionTypes, List<String> checkOptionValues) throws JsonSerializationException {
        GoLangCILintConfigurationFile configurationFile = (GoLangCILintConfigurationFile)JsonUtils.deserializeFromJson((String)GoLangCILintSynchronizer.getContentOfBaseConfigurationFile(), GoLangCILintConfigurationFile.class);
        ArrayList<String> parsedCheckIds = new ArrayList<String>();
        for (String uniqueCheckId : selectedChecks) {
            try {
                parsedCheckIds.add(GoLangCILintUtils.parseCheckId(uniqueCheckId));
            }
            catch (GoLangCILintException e) {
                LOGGER.error((Object)e);
            }
        }
        configurationFile.addEnabledLinters(parsedCheckIds);
        for (int i = 0; i < selectedOptions.size(); ++i) {
            String fullyQualifiedOption = selectedOptions.get(i);
            try {
                Pair<String, String> checkAndOption = GoLangCILintUtils.parseCheckAndOptionIds(fullyQualifiedOption);
                String checkId = (String)checkAndOption.getFirst();
                String optionId = (String)checkAndOption.getSecond();
                if (!configurationFile.shouldAddOption(checkId, optionId)) continue;
                configurationFile.addCheckOption(checkId, optionId, checkOptionTypes.get(i), checkOptionValues.get(i));
                continue;
            }
            catch (GoLangCILintException e) {
                LOGGER.error("Could not add option {} to GoLangCI-Lint configuration file. {}", (Object)fullyQualifiedOption, (Object)e);
            }
        }
        return configurationFile;
    }

    public static String createUniqueCheckId(String checkId) {
        return "golang." + checkId;
    }

    private static String parseCheckId(String uniqueCheckId) throws GoLangCILintException {
        String checkPrefix = "golang.";
        if (!uniqueCheckId.startsWith(checkPrefix)) {
            throw new GoLangCILintException("Check ID " + uniqueCheckId + " not well formatted. Must begin with '" + checkPrefix + "'");
        }
        return StringUtils.getLastPart((String)uniqueCheckId, (String)".");
    }

    public static String createUniqueOptionId(String checkId, String option) {
        return checkId + "." + option;
    }

    private static Pair<String, String> parseCheckAndOptionIds(String uniqueOptionId) throws GoLangCILintException {
        String checkPrefix = "golang.";
        if (!uniqueOptionId.startsWith(checkPrefix)) {
            throw new GoLangCILintException("Option ID " + uniqueOptionId + " not well formatted. Must begin with '" + checkPrefix + "'");
        }
        String checkAndOptionIds = uniqueOptionId.substring(checkPrefix.length());
        int indexOfDot = checkAndOptionIds.indexOf(".");
        if (indexOfDot == -1) {
            throw new GoLangCILintException("Check and Option IDs " + checkAndOptionIds + " not well formatted. Expected format as 'check-id.option-id' but no separator '.' found");
        }
        String checkId = checkAndOptionIds.substring(0, indexOfDot);
        String option = checkAndOptionIds.substring(indexOfDot + 1);
        return Pair.createPair((Object)checkId, (Object)option);
    }

    public static Object parseToConfigurationValue(EToolCheckOptionType optionType, String optionValue) throws JsonSerializationException {
        return switch (optionType) {
            case EToolCheckOptionType.BOOLEAN -> Boolean.parseBoolean(optionValue);
            case EToolCheckOptionType.INTEGER -> Integer.parseInt(optionValue);
            case EToolCheckOptionType.JSON -> JsonUtils.deserializeFromJson((String)optionValue);
            case EToolCheckOptionType.STRING -> {
                if (optionValue == null) {
                    yield "";
                }
                yield optionValue;
            }
            case EToolCheckOptionType.STRING_LIST -> {
                if (StringUtils.isEmpty((String)optionValue)) {
                    yield new Object[]{};
                }
                yield GoLangCILintUtils.fromString(optionValue);
            }
            default -> optionValue;
        };
    }

    private static Object[] fromString(String value) {
        String newValue = StringUtils.stripPrefix((String)StringUtils.stripSuffix((String)value, (String)"]"), (String)"[").trim();
        if (newValue.isEmpty()) {
            return new Object[0];
        }
        String[] parts = newValue.split(",");
        Object[] result = new Object[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            result[i] = parts[i].trim();
        }
        return result;
    }
}

