/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.phpstan;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Converter;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.string.StringUtils;
import org.intellij.lang.annotations.Language;

record PHPStanReport(@JsonProperty(value="totals") Totals totals, @JsonProperty(value="files") @JsonDeserialize(converter=PossibleArrayTypeConverter.class) UnmodifiableMap<Path, FileErrors> fileErrors, @JsonProperty(value="errors") UnmodifiableList<String> errors) {
    public static final PHPStanReport EMPTY = new PHPStanReport(new Totals(0, 0), (UnmodifiableMap<Path, FileErrors>)CollectionUtils.emptyMap(), (UnmodifiableList<String>)CollectionUtils.emptyList());

    public PHPStanReport relativize(Path root) {
        return new PHPStanReport(this.totals, (UnmodifiableMap<Path, FileErrors>)CollectionUtils.asUnmodifiable(this.fileErrors.entrySet().stream().collect(Collectors.toMap(entry -> root.relativize((Path)entry.getKey()), Map.Entry::getValue))), this.errors);
    }

    public static PHPStanReport fromJson(@Language(value="JSON") String json) throws JsonSerializationException {
        if (StringUtils.isEmpty((String)json)) {
            return EMPTY;
        }
        return (PHPStanReport)JsonUtils.deserializeFromJson((String)json, PHPStanReport.class);
    }

    record Totals(@JsonProperty(value="errors") int errors, @JsonProperty(value="file_errors") int fileErrors) {
    }

    private static class PossibleArrayTypeConverter
    implements Converter<JsonNode, UnmodifiableMap<Path, FileErrors>> {
        private PossibleArrayTypeConverter() {
        }

        public UnmodifiableMap<Path, FileErrors> convert(JsonNode value) {
            if (value.isArray()) {
                ArrayNode arrayNode;
                if (value instanceof ArrayNode && (arrayNode = (ArrayNode)value).isEmpty()) {
                    return CollectionUtils.emptyMap();
                }
                throw new IllegalArgumentException("Cannot deserialize map out of non-empty array");
            }
            try {
                return (UnmodifiableMap)JsonUtils.getObjectMapper().treeToValue((TreeNode)value, (TypeReference)new TypeReference<UnmodifiableMap<Path, FileErrors>>(this){});
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Failed to deserialize map", e);
            }
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructType(JsonNode.class);
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructParametricType(UnmodifiableMap.class, new Class[]{Path.class, FileErrors.class});
        }
    }

    record FileErrors(@JsonProperty(value="errors") int errorCount, @JsonProperty(value="messages") UnmodifiableList<FileError> errors) {

        record FileError(@JsonProperty(value="message") String message, @JsonProperty(value="line") int line, @JsonProperty(value="ignorable") boolean ignorable, @JsonProperty(value="tip") @Nullable String tip, @JsonProperty(value="identifier") String identifier) {
            public Optional<String> getTip() {
                return Optional.ofNullable(this.tip);
            }
        }
    }
}

