/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.sonarlint.dev_utils;

import com.teamscale.index.findings.sonarlint.SonarLintEnginePool;
import com.teamscale.index.findings.sonarlint.SonarLintRulesExtractor;
import com.teamscale.index.findings.sonarlint.dev_utils.SonarLintRuleOptionsExtractor;
import java.io.IOException;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.core.ConQATException;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneSonarLintEngine;

public class SonarLintUpdater {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... arguments) throws ConQATException, IOException {
        EFeatureToggle.ENABLE_DEV_MODE.setFeatureToggle(true);
        StandaloneSonarLintEngine engine = null;
        try {
            engine = SonarLintEnginePool.createEngine();
            SonarLintRulesExtractor rulesExtractor = new SonarLintRulesExtractor(engine);
            rulesExtractor.execute();
            SonarLintRuleOptionsExtractor optionsExtractor = new SonarLintRuleOptionsExtractor(engine);
            optionsExtractor.execute();
        }
        catch (IOException e) {
            SonarLintUpdater.exitWithError(e.toString());
        }
        finally {
            SonarLintUpdater.stopEngine(engine);
        }
    }

    private static void exitWithError(String message) {
        System.err.println(message);
        System.exit(1);
    }

    private static void stopEngine(StandaloneSonarLintEngine engine) {
        if (engine != null) {
            SonarLintEnginePool.returnEngine(engine);
            engine.stop();
        }
    }
}

