/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.sonarlint.independent_analysis;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintFileInfo;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisUtils;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.SchemaNotFoundException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public final class SonarLintIndependentAnalysisLocalContentReader {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Map<String, TokenElementInfo> readLocalContentByHash(IndexLayer indexLayer, @Nullable IProjectId projectId, @Nullable UnresolvedCommitDescriptor commit, List<SonarLintFileInfo> fileInfos) throws StorageException {
        if (projectId == null && commit == null) {
            LOGGER.debug("External SonarLint analysis request without project id and commit descriptor. Continuing without local file contents.");
            return CollectionUtils.emptyMap();
        }
        if (projectId == null || commit == null) {
            throw new StorageException("Provided project id '" + String.valueOf(projectId) + "' and commit descriptor '" + String.valueOf(commit) + "'. Please provide both to enable reading content from server storage or none to disable reading content.");
        }
        ProjectStorageSystem projectStorage = SonarLintIndependentAnalysisLocalContentReader.tryOpenProjectStorage(indexLayer, projectId);
        if (projectStorage == null) {
            throw new StorageException("External SonarLint analysis request referenced unknown project id '" + String.valueOf(projectId) + "'.");
        }
        LOGGER.debug("Continuing independent SonarLint analysis with local file content from project id '{}'.", (Object)projectId);
        return SonarLintIndependentAnalysisLocalContentReader.getTokensByHash(fileInfos, projectStorage, commit);
    }

    private static @Nullable ProjectStorageSystem tryOpenProjectStorage(IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        try {
            return indexLayer.openNonCommitResolvingProjectStorageSystem(projectId);
        }
        catch (SchemaNotFoundException e) {
            return null;
        }
    }

    private static Map<String, TokenElementInfo> getTokensByHash(List<SonarLintFileInfo> fileInfos, ProjectStorageSystem projectStorage, UnresolvedCommitDescriptor commit) throws StorageException {
        int missingFiles;
        TokenElementIndex tokenElementIndex = (TokenElementIndex)projectStorage.openProjectIndex(TokenElementIndex.class, "content", HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
        HashMap<String, TokenElementInfo> tokensByHash = new HashMap<String, TokenElementInfo>();
        CollectionUtils.forEach(fileInfos, tokenElementIndex.getTokenElements(CollectionUtils.map(fileInfos, SonarLintFileInfo::uniformPath)), (fileInfo, tokenElementInfo) -> SonarLintIndependentAnalysisLocalContentReader.addTokenInfoIfAvailable(tokensByHash, commit, fileInfo, tokenElementInfo));
        if (!tokensByHash.isEmpty()) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = tokensByHash::size;
            supplierArray[1] = () -> HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp());
            LOGGER.debug("Found local content for {} file(s) by {}.", supplierArray);
        }
        if ((missingFiles = fileInfos.size() - tokensByHash.size()) > 0) {
            LOGGER.error("Missing local content at {} for file(s): {}", new Supplier[]{() -> HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()), () -> fileInfos.stream().filter(Predicate.not(fileInfo -> tokensByHash.containsKey(fileInfo.hash()))).map(SonarLintFileInfo::uniformPath).map(StringUtils::surroundWithSingleQuotes).collect(Collectors.joining(", "))});
        }
        return tokensByHash;
    }

    private static void addTokenInfoIfAvailable(Map<String, TokenElementInfo> tokensByHash, UnresolvedCommitDescriptor commit, SonarLintFileInfo fileInfo, TokenElementInfo contentInfo) {
        if (contentInfo == null) {
            return;
        }
        if (fileInfo.hash().equals(SonarLintIndependentAnalysisUtils.generateSonarLintFileHash(contentInfo.getUniformPath(), contentInfo.getText()))) {
            tokensByHash.put(fileInfo.hash(), contentInfo);
        } else {
            LOGGER.debug("Content will not be used for analysis: Found '{}' reading from {}, but hashes did not match.", (Object)fileInfo.uniformPath(), (Object)HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
        }
    }
}

