/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.sonarlint.independent_analysis;

import com.google.common.hash.Hashing;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisCredentialsNameOption;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public class SonarLintIndependentAnalysisUtils {
    private static final String BASE_CREDENTIALS_ERROR_MESSAGE = "Independent SonarLint analysis was enabled, but credentials for the analysis service are not fully configured. ";

    public static String generateSonarLintFileHash(String uniformPath, String textContent) {
        return Hashing.murmur3_128().hashBytes(StringUtils.stringToBytes((String)(uniformPath + textContent))).toString();
    }

    public static String generateSonarLintFileHash(BasicTokenElementInfo tokens) {
        return SonarLintIndependentAnalysisUtils.generateSonarLintFileHash(tokens.getUniformPath(), tokens.getText());
    }

    static ExternalCredentials getSonarLintAnalysisServiceCredentials(ServerOptionIndex serverOptions, IExternalCredentialsProvider credentialsProvider) throws StorageException {
        String credentialsName = SonarLintIndependentAnalysisCredentialsNameOption.getCredentialsName(serverOptions);
        if (credentialsName == null) {
            throw new StorageException("Independent SonarLint analysis was enabled, but credentials for the analysis service are not fully configured. Please set the 'Credentials name for the SonarLint analysis service' option in the administrator settings.");
        }
        ExternalCredentials externalCredentials = credentialsProvider.getExternalCredentials(credentialsName);
        if (externalCredentials == null) {
            throw new StorageException("Independent SonarLint analysis was enabled, but credentials for the analysis service are not fully configured. Please create an external account with the name '" + credentialsName + "' (configured in the administrator settings).");
        }
        return externalCredentials;
    }

    private SonarLintIndependentAnalysisUtils() {
    }
}

