/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.GitHubRepositoryConnectorUrl;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.github.AppBasedGitHubIssueSynchronizer;
import com.teamscale.index.issues.github.GitHubIssueConnectorDescriptorBase;
import com.teamscale.index.issues.github.client.GitHubIssueClient;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.AppBasedGithubConnectorValidationUtils;
import com.teamscale.index.repository.git.github.GitHubAppBasedRepositoryAccessHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

@ConnectorDescriptor
public class AppBasedGitHubIssueConnectorDescriptor
extends GitHubIssueConnectorDescriptorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CREDENTIALS_NAME = "unused-dummy";
    @ConfigExposed(name="GitHub Server URL", description="The URL the GitHub instance is reachable at.", required=true)
    private GitHubRepositoryConnectorUrl gitHubServerUrl;
    @ConfigExposed(name="Repository name", description="The name of the repository, e.g. 'cqse/teamscale-python-client'.", visibility=ConfigExposed.EConfigVisibility.DEFAULT, required=true)
    protected String repositoryName;

    public AppBasedGitHubIssueConnectorDescriptor() {
        super(EIssueTracker.GITHUB_APP_BASED);
        this.hideOption("Account");
        this.hideOption("Projects");
    }

    @Override
    protected Class<? extends IssueTrackerSynchronizerBase<?>> getIssueTrackerSynchronizerClass() {
        return AppBasedGitHubIssueSynchronizer.class;
    }

    @Override
    protected void configureAdditionalIssueTrackerParameters(TriggerBuilder issueTrackerTriggerBuilder) throws ProjectConfigurationException {
        super.configureAdditionalIssueTrackerParameters(issueTrackerTriggerBuilder);
        issueTrackerTriggerBuilder.setTriggerParameter("repository-name", this.repositoryName);
        issueTrackerTriggerBuilder.setTriggerParameter("githubServerUrl", this.gitHubServerUrl.url());
    }

    protected ExternalCredentials resolveExternalCredentials() throws ConnectorValidationException {
        try {
            GitHubAppBasedRepositoryAccessHelper<ConnectorValidationException> repositoryAccessHelper = this.createRepositoryAccessHelper();
            return new ExternalCredentials(CREDENTIALS_NAME, repositoryAccessHelper.getRepositoryHtmlUrl(), "x-access-token", repositoryAccessHelper.getInstallationAccessToken());
        }
        catch (ServiceCallException | StorageException e) {
            throw new ConnectorValidationException(e);
        }
    }

    private GitHubAppBasedRepositoryAccessHelper<ConnectorValidationException> createRepositoryAccessHelper() throws ConnectorValidationException {
        try {
            return new GitHubAppBasedRepositoryAccessHelper<ConnectorValidationException>(this.gitHubServerUrl.url(), this.repositoryName, this.getContext().getGlobalStorageSystem(), ConnectorValidationException::new, LOGGER);
        }
        catch (StorageException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
    }

    private PlatformRepositoryIdentifier getRepositoryId() throws ConnectorValidationException {
        return PlatformRepositoryIdentifier.fromRepositoryName(this.repositoryName, ConnectorValidationException::new);
    }

    @Override
    public void validate() throws ConnectorValidationException {
        try {
            AppBasedGithubConnectorValidationUtils.checkUserIsCollaborator(this.createRepositoryAccessHelper().getApplicationDescription(), this.resolveExternalCredentials().password, this.getRepositoryId(), this.getContext(), LOGGER);
        }
        catch (StorageException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
        super.validate();
    }

    @Override
    protected void validateAccessToken(GitHubIssueClient client) {
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

