/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.gitlab.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.issues.gitlab.client.IGitLabIssueApi;
import com.teamscale.index.issues.gitlab.client.PaginatedServiceCallStreamSource;
import com.teamscale.index.issues.gitlab.client.model.GitLabIssue;
import com.teamscale.index.issues.gitlab.client.model.GitLabIssueStateEvent;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jetbrains.annotations.TestOnly;
import retrofit2.Call;

public class GitLabIssueClient {
    private final IGitLabIssueApi gitlab;

    public GitLabIssueClient(String baseUrl, String accessToken, Logger interactionLogger) {
        this.gitlab = (IGitLabIssueApi)Retrofit.builder((String)baseUrl).withBearerAuthentication(accessToken).withInteractionLogger(interactionLogger).create(IGitLabIssueApi.class);
    }

    public Set<String> retrieveAllIssueIds(String project) throws ServiceCallException {
        IStreamWithException<GitLabIssue, ServiceCallException> issues = this.getIssues(project, (Collection<String>)CollectionUtils.emptyList(), null);
        return (Set)issues.map(GitLabIssue::issueId).map(String::valueOf).collect(Collectors.toSet());
    }

    @TestOnly
    public void createIssue(String project, String issueTitle) throws ServiceCallException {
        this.gitlab.createProjectIssue(project, issueTitle);
    }

    @TestOnly
    public void deleteIssue(String project, Integer issueId) throws ServiceCallException {
        this.gitlab.deleteProjectIssue(project, issueId);
    }

    public IStreamWithException<GitLabIssue, ServiceCallException> getIssues(String project, Collection<String> labels, @Nullable Instant updateAfter) {
        if (labels.isEmpty()) {
            return this.getPaginatedResults(this.gitlab.getProjectIssues(project, Collections.emptyList(), updateAfter), this.gitlab::getNextProjectIssues);
        }
        return IStreamWithException.wrap(labels.stream(), ServiceCallException.class).flatMap(label -> this.getPaginatedResults(this.gitlab.getProjectIssues(project, List.of(label), updateAfter), this.gitlab::getNextProjectIssues)).distinctBy(GitLabIssue::id);
    }

    public IStreamWithException<GitLabIssueStateEvent, ServiceCallException> getStateChangeEvents(GitLabIssue issue) {
        return this.getStateChangeEvents(String.valueOf(issue.projectId()), issue.issueId());
    }

    public IStreamWithException<GitLabIssueStateEvent, ServiceCallException> getStateChangeEvents(String projectIdOrPath, long issueId) {
        return this.getPaginatedResults(this.gitlab.getIssueStateEvents(projectIdOrPath, issueId), this.gitlab::getNextIssueStateEvents);
    }

    private <T> IStreamWithException<T, ServiceCallException> getPaginatedResults(Call<? extends Iterable<T>> initialRequest, Function<String, Call<? extends Iterable<T>>> followupRequest) {
        return IStreamWithException.of(new PaginatedServiceCallStreamSource(initialRequest, followupRequest));
    }
}

