/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.voting;

import com.teamscale.commons.links.TeamscaleProjectLinkProvider;
import com.teamscale.core.analysis.configuration.model.option.JiraIssueUpdateTgaBranchConfiguration;
import com.teamscale.index.issues.jira.voting.ExtendedJiraIssueUpdateConfiguration;
import com.teamscale.index.issues.jira.voting.JiraCloudTableMarkdownBuilder;
import com.teamscale.index.issues.jira.voting.JiraDatacenterTableMarkdownBuilder;
import com.teamscale.index.issues.jira.voting.JiraTableMarkdownBuilderBase;
import com.teamscale.index.issues.jira.voting.JiraVotingInput;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;

final class TeamscaleJiraMessageRow {
    private JiraTableMarkdownBuilderBase jiraTableBuilder = new JiraDatacenterTableMarkdownBuilder();
    public static final String TEAMSCALE_MESSAGE_START_MARKER = "\r\nTeamscale Info\r\n----\r\n";
    public static final String JIRA_DATACENTER_TEAMSCALE_HEADER_START_MARKER = new JiraDatacenterTableMarkdownBuilder().withPrependedHeaderCell("Test Gap").withPrependedHeaderCell("Findings balance").withPrependedHeaderCell("Project name").build();
    public static final String JIRA_CLOUD_TEAMSCALE_HEADER_START_MARKER = new JiraCloudTableMarkdownBuilder().withPrependedHeaderCell("Test Gap").withPrependedHeaderCell("Findings balance").withPrependedHeaderCell("Project name").build();
    private String projectSpecificLinePrefix = null;

    private TeamscaleJiraMessageRow() {
    }

    static @NonNull TeamscaleJiraMessageRow create(JiraVotingInput votingInput, ExtendedJiraIssueUpdateConfiguration jiraIssueUpdateConfiguration, String projectName, PublicProjectId projectId, String baseUrl) {
        String branch = null;
        JiraIssueUpdateTgaBranchConfiguration tgaBranchConfig = jiraIssueUpdateConfiguration.getTgaBranchConfig();
        if (!tgaBranchConfig.isAutoSelectBranch() && tgaBranchConfig.getBranchName() != null) {
            branch = tgaBranchConfig.getBranchName();
        }
        TeamscaleJiraMessageRow message = new TeamscaleJiraMessageRow();
        message.setProjectName(projectName);
        TeamscaleJiraMessageRow.addFindingsChurn(message, votingInput, jiraIssueUpdateConfiguration.shouldHideResolvedFindings(), baseUrl, projectId, branch);
        TeamscaleJiraMessageRow.addTgaRatio(message, votingInput, jiraIssueUpdateConfiguration.shouldHideResolvedFindings(), baseUrl, projectId, branch);
        message.skipToNextLine();
        return message;
    }

    private static void addTgaRatio(TeamscaleJiraMessageRow message, JiraVotingInput votingInput, boolean shouldHideResolvedFindings, String baseUrl, PublicProjectId projectId, String branch) {
        if (votingInput.issueTgaRatio().isEmpty()) {
            message.jiraTableBuilder.withEmptyNonHeaderCell().withAdditionalCellSeparator();
        } else {
            message.setTgaRatio(projectId, baseUrl, votingInput.issueId(), branch, votingInput.issueTgaRatio().get(), shouldHideResolvedFindings);
        }
    }

    private static void addFindingsChurn(TeamscaleJiraMessageRow message, JiraVotingInput votingInput, boolean shouldHideResolvedFindings, String baseUrl, PublicProjectId projectId, String branch) {
        if (votingInput.findingChurnList().isEmpty()) {
            message.jiraTableBuilder.withEmptyNonHeaderCell();
        } else {
            message.setFindingChurn(projectId, baseUrl, votingInput.issueId(), branch, votingInput.findingChurnList().get(), shouldHideResolvedFindings);
        }
    }

    public TeamscaleJiraMessageRow copy() {
        TeamscaleJiraMessageRow message = new TeamscaleJiraMessageRow(this.jiraTableBuilder.copy());
        message.projectSpecificLinePrefix = this.projectSpecificLinePrefix;
        return message;
    }

    private TeamscaleJiraMessageRow(JiraTableMarkdownBuilderBase jiraTableBuilder) {
        this.jiraTableBuilder = jiraTableBuilder;
    }

    private void setTgaRatio(PublicProjectId projectId, String baseUrl, TeamscaleIssueId issueId, String branch, @NonNull Pair<Double, Boolean> ratioAndChangedMethods, boolean hideResolvedFindingsInLink) {
        double ratio = (Double)ratioAndChangedMethods.getFirst();
        String ratioPercentage = String.format("%.2f%%", ratio * 100.0);
        if (!((Boolean)ratioAndChangedMethods.getSecond()).booleanValue()) {
            ratioPercentage = "n/a (no changed methods)";
        }
        if (StringUtils.isEmpty((String)baseUrl) || projectId == null || issueId == null) {
            this.jiraTableBuilder.withNonHeaderCell(ratioPercentage);
            return;
        }
        TeamscaleProjectLinkProvider linkProvider = new TeamscaleProjectLinkProvider(baseUrl, projectId);
        String tgaRatioLink = "[" + ratioPercentage + "|" + linkProvider.createIssuePerspectiveLink(issueId.getInternalId(), branch, hideResolvedFindingsInLink) + "]";
        this.jiraTableBuilder.withNonHeaderCell(tgaRatioLink);
    }

    private void setProjectName(String projectName) {
        String escapedProjectName = StringUtils.escapeChars((String)projectName, (Map)CollectionUtils.asMap((Pair[])new Pair[]{Pair.createPair((Object)"|", (Object)"\\|")}));
        this.projectSpecificLinePrefix = "|" + escapedProjectName + "|";
        this.jiraTableBuilder.withNonHeaderCell(escapedProjectName);
    }

    public String getProjectSpecificLinePrefix() {
        return this.projectSpecificLinePrefix;
    }

    private void skipToNextLine() {
        this.jiraTableBuilder.withNewRow();
    }

    private void setFindingChurn(PublicProjectId projectId, String baseUrl, TeamscaleIssueId issueId, @Nullable String branch, @NonNull FindingChurnList findingChurn, boolean hideResolvedFindingsInLink) {
        if (StringUtils.isEmpty((String)baseUrl) || projectId == null || issueId == null) {
            this.jiraTableBuilder.withNonHeaderCell(TeamscaleJiraMessageRow.buildFindingChurnMessage(findingChurn));
        } else {
            String targetUrl = new TeamscaleProjectLinkProvider(baseUrl, projectId).createIssuePerspectiveLink(issueId.getInternalId(), branch, hideResolvedFindingsInLink);
            this.jiraTableBuilder.withNonHeaderCell("[" + TeamscaleJiraMessageRow.buildFindingChurnMessage(findingChurn) + "|" + targetUrl + "]");
        }
    }

    private static String buildFindingChurnMessage(FindingChurnList findingChurn) {
        ArrayList<String> findingChanges = new ArrayList<String>();
        TeamscaleJiraMessageRow.appendMessageIfNotZero(findingChurn.getAddedFindings().size(), "added", findingChanges);
        TeamscaleJiraMessageRow.appendMessageIfNotZero(findingChurn.getFindingsInChangedCode().size(), "in changed code", findingChanges);
        TeamscaleJiraMessageRow.appendMessageIfNotZero(findingChurn.getRemovedFindings().size(), "removed", findingChanges);
        if (findingChanges.isEmpty()) {
            findingChanges.add("no change");
        }
        return StringUtils.concat(findingChanges, (String)", ");
    }

    private static void appendMessageIfNotZero(int size, String qualifier, List<String> messages) {
        if (size > 0) {
            messages.add(size + " " + qualifier);
        }
    }

    public String toJiraMessage(boolean withMarker) {
        StringBuilder builder = new StringBuilder();
        if (withMarker) {
            builder.append(TEAMSCALE_MESSAGE_START_MARKER);
        }
        builder.append(this.jiraTableBuilder.build());
        return builder.toString();
    }

    public void prependStandardHeader() {
        this.jiraTableBuilder.withPrependedNewRow().withPrependedHeaderCell("Test Gap").withPrependedHeaderCell("Findings balance").withPrependedHeaderCell("Project name");
    }

    @TestOnly
    public static TeamscaleJiraMessageRow messageForTesting(String projectName, String findingsContent, String testGapContent) {
        TeamscaleJiraMessageRow teamscaleJiraMessageRow = new TeamscaleJiraMessageRow();
        teamscaleJiraMessageRow.setProjectName(projectName);
        teamscaleJiraMessageRow.jiraTableBuilder.withNonHeaderCell(findingsContent);
        teamscaleJiraMessageRow.jiraTableBuilder.withNonHeaderCell(testGapContent);
        teamscaleJiraMessageRow.skipToNextLine();
        return teamscaleJiraMessageRow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamscaleJiraMessageRow message = (TeamscaleJiraMessageRow)o;
        return Objects.equals(this.jiraTableBuilder, message.jiraTableBuilder);
    }

    public int hashCode() {
        return Objects.hash(this.jiraTableBuilder);
    }
}

