/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.findings.calculation.BasicFindingsFilterSettings;
import com.teamscale.index.findings.calculation.CodeFindingsRetriever;
import com.teamscale.index.findings.calculation.EBlacklistingOption;
import com.teamscale.index.findings.calculation.ExtendedTrackedFindingUtils;
import com.teamscale.index.findings.calculation.FilteredFindingDelta;
import com.teamscale.index.findings.calculation.FindingDeltaCalculator;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.findings.calculation.IFindingsRetriever;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.index.tracking.index.FindingChurnListIndex;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.FindingDelta;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;

public class MergeRequestFindingChurnCalculator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CommitDescriptor source;
    private final CommitDescriptor target;
    private final BasicFindingsFilterSettings filterSettings;
    private final FindingsCalculationInfo calculationInfo;
    private final MergeBaseInfo mergeBaseInfo;

    private MergeRequestFindingChurnCalculator(CommitDescriptor source, CommitDescriptor target, BasicFindingsFilterSettings filterSettings, FindingsCalculationInfo calculationInfo, MergeBaseInfo mergeBaseInfo) {
        this.source = source;
        this.target = target;
        this.filterSettings = filterSettings;
        this.calculationInfo = calculationInfo;
        this.mergeBaseInfo = mergeBaseInfo;
    }

    public static FilteredFindingDelta getFindingDeltaForMerge(CommitDescriptor source, CommitDescriptor target, BasicFindingsFilterSettings filterSettings, FindingsCalculationInfo calculationContext, MergeBaseInfo mergeBaseInfo) throws StorageException {
        return new MergeRequestFindingChurnCalculator(source, target, filterSettings, calculationContext, mergeBaseInfo).calculate();
    }

    private FilteredFindingDelta calculate() throws StorageException {
        CommitDescriptor startCommit = this.determineStartCommit();
        LOGGER.debug("Computing finding churn using the following commits: {} (start commit), {} (source commit), {} (target commit).", (Object)startCommit, (Object)this.source, (Object)this.target);
        CodeFindingsRetriever codeFindingsRetriever = new CodeFindingsRetriever(this.calculationInfo.projectStorageSystem());
        FindingDelta sourceDelta = FindingDeltaCalculator.computeUnfilteredDelta("", startCommit, this.source, false, codeFindingsRetriever, this.calculationInfo);
        Set<String> findingIdsInTarget = codeFindingsRetriever.getFindingIds("", this.target);
        List<TrackedFinding> addedFindings = this.calculateAddedFindings(sourceDelta.getAddedFindings(), startCommit);
        List<TrackedFinding> removedFindings = this.calculateRemovedFindings(sourceDelta.getRemovedFindings());
        List<TrackedFinding> changedCodeFindings = this.calculateFindingsInChangedCode(findingIdsInTarget, codeFindingsRetriever);
        this.removeFlaggedFindings(addedFindings, changedCodeFindings, this.filterSettings.getBlacklistingOption());
        FindingDelta findingDelta = FindingDelta.create(addedFindings, changedCodeFindings, removedFindings);
        return ExtendedTrackedFindingUtils.fromFindingDelta(findingDelta, this.calculationInfo, codeFindingsRetriever, this.target, this.source).applyFilter(this.filterSettings, this.calculationInfo);
    }

    private CommitDescriptor determineStartCommit() {
        if (this.mergeBaseInfo.getBranchPoint().isPresent()) {
            return this.mergeBaseInfo.getBranchPoint().get();
        }
        LOGGER.warn("Could not find branching point for {} and {}. Falling back to merge base: {}.", (Object)this.source, (Object)this.target, (Object)this.mergeBaseInfo.getMergeBase());
        return this.mergeBaseInfo.getMergeBase();
    }

    private void removeFlaggedFindings(List<TrackedFinding> addedFindings, List<TrackedFinding> changedCodeFindings, EBlacklistingOption flagFilter) {
        HashSet findingIds = new HashSet(CollectionUtils.map(addedFindings, TrackedFinding::getId));
        findingIds.addAll(CollectionUtils.map(changedCodeFindings, TrackedFinding::getId));
        ArrayList<String> findingIdList = new ArrayList<String>(findingIds);
        HashSet<String> idsOfFlaggedFindings = new HashSet<String>(this.getFlaggedFindingIds(this.source, findingIdList, flagFilter));
        idsOfFlaggedFindings.addAll(this.getFlaggedFindingIds(CommitDescriptor.latestOnBranch((String)this.target.getBranchName()), findingIdList, flagFilter));
        addedFindings.removeIf(finding -> idsOfFlaggedFindings.contains(finding.getId()));
        changedCodeFindings.removeIf(finding -> idsOfFlaggedFindings.contains(finding.getId()));
    }

    private List<String> getFlaggedFindingIds(CommitDescriptor commit, List<String> findingIdsToConsider, EBlacklistingOption flagFilter) {
        try {
            FindingBlacklistIndex findingBlacklistIndex = (FindingBlacklistIndex)this.calculationInfo.projectStorageSystem().openProjectIndex(FindingBlacklistIndex.class, HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
            return findingBlacklistIndex.getBlacklistInfos(findingIdsToConsider).stream().filter(flag -> flag != null && flagFilter.filter.negate().test(flag.getType())).map(FindingBlacklistInfo::getFindingId).toList();
        }
        catch (StorageException e) {
            LOGGER.error("Error retrieving flagged findings in merge request for commit " + String.valueOf(commit), (Throwable)e);
            return CollectionUtils.emptyList();
        }
    }

    private List<TrackedFinding> calculateAddedFindings(List<TrackedFinding> addedInSource, CommitDescriptor startCommit) throws StorageException {
        ArrayList<TrackedFinding> addedFindings = new ArrayList<TrackedFinding>();
        List addedInSourceIds = CollectionUtils.map(addedInSource, TrackedFinding::getId);
        List<TrackedFinding> findingsInTarget = this.retrieveFindingsOnCommitById(this.target, addedInSourceIds);
        List<TrackedFinding> findingsOnStartCommit = this.retrieveFindingsOnCommitById(startCommit, addedInSourceIds);
        for (int i = 0; i < addedInSource.size(); ++i) {
            TrackedFinding findingInTarget = findingsInTarget.get(i);
            if (findingInTarget == null) {
                addedFindings.add(addedInSource.get(i));
                continue;
            }
            TrackedFinding findingOnStartCommit = findingsOnStartCommit.get(i);
            if (findingOnStartCommit == null || findingOnStartCommit.isAlive() || findingInTarget.isAlive()) continue;
            addedFindings.add(addedInSource.get(i));
        }
        return addedFindings;
    }

    private List<TrackedFinding> calculateRemovedFindings(List<TrackedFinding> removedInSource) throws StorageException {
        ArrayList<TrackedFinding> removedFindings = new ArrayList<TrackedFinding>();
        List removedInSourceIds = CollectionUtils.map(removedInSource, TrackedFinding::getId);
        List<TrackedFinding> findingsInTarget = this.retrieveFindingsOnCommitById(this.target, removedInSourceIds);
        for (int i = 0; i < removedInSource.size(); ++i) {
            if (findingsInTarget.get(i) == null || findingsInTarget.get(i).getDeathCommit() != null) continue;
            removedFindings.add(removedInSource.get(i));
        }
        return removedFindings;
    }

    private List<TrackedFinding> retrieveFindingsOnCommitById(CommitDescriptor commit, List<String> findingIds) throws StorageException {
        TrackedFindingsByIdIndex trackedFindingsByIdIndex = (TrackedFindingsByIdIndex)this.calculationInfo.projectStorageSystem().openProjectIndex(TrackedFindingsByIdIndex.class, HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
        return trackedFindingsByIdIndex.getFindings(findingIds);
    }

    private List<TrackedFinding> calculateFindingsInChangedCode(Set<String> findingIdsInTarget, IFindingsRetriever findingsRetriever) throws StorageException {
        if (this.mergeBaseInfo.getBranchPoint().isEmpty()) {
            return Collections.emptyList();
        }
        CommitDescriptor startCommit = this.mergeBaseInfo.getBranchPoint().get();
        FindingDelta changedCodeFindingsDelta = FindingDeltaCalculator.computeUnfilteredDelta("", startCommit, this.source, false, findingsRetriever, this.calculationInfo);
        List findingsWithoutRemovedOnTarget = CollectionUtils.filter((Collection)changedCodeFindingsDelta.getFindingsInChangedCode(), finding -> findingIdsInTarget.contains(finding.getId()));
        return this.ignoreMergesForFindingsInChangedCode(findingsWithoutRemovedOnTarget);
    }

    private List<TrackedFinding> ignoreMergesForFindingsInChangedCode(List<TrackedFinding> findingsInChangedCode) throws StorageException {
        if (findingsInChangedCode.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<TrackedFinding> changedFindingsWithoutMergeCommits = new HashSet<TrackedFinding>();
        Map idsToChangedCodeFindings = findingsInChangedCode.stream().collect(Collectors.toMap(TrackedFinding::getId, Function.identity()));
        FindingChurnListIndex findingChurnListIndex = (FindingChurnListIndex)this.calculationInfo.projectStorageSystem().openProjectIndex(FindingChurnListIndex.class, null);
        List nonMergeAncestors = CollectionUtils.filter(this.mergeBaseInfo.getAncestorsOfSource(), Predicate.not(ParentedCommitDescriptor::isMergeCommit));
        for (FindingChurnList findingChurn : findingChurnListIndex.getEntries(nonMergeAncestors)) {
            if (findingChurn == null) continue;
            for (TrackedFinding findingInChangedCode : findingChurn.getFindingsInChangedCode()) {
                TrackedFinding originalFindingInChangedCode = (TrackedFinding)idsToChangedCodeFindings.remove(findingInChangedCode.getId());
                if (originalFindingInChangedCode == null) continue;
                changedFindingsWithoutMergeCommits.add(originalFindingInChangedCode);
            }
            if (!idsToChangedCodeFindings.isEmpty()) continue;
            break;
        }
        return new ArrayList<TrackedFinding>(changedFindingsWithoutMergeCommits);
    }
}

