/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.comments.comments;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.index.merge_request.comments.FindingUtils;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import java.util.Arrays;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.markup.MarkupUtils;

public class SingleFindingReviewComment
implements IReviewComment {
    protected final TrackedFinding finding;
    protected final TeamscaleCommitLinkProvider linkProvider;
    private final CommitDescriptor commentedCommit;

    public SingleFindingReviewComment(TrackedFinding finding, CommitDescriptor commentedCommit, TeamscaleCommitLinkProvider linkProvider) {
        this.finding = finding;
        this.commentedCommit = commentedCommit;
        this.linkProvider = linkProvider;
    }

    @Override
    public ETrafficLightColor getAssessment() {
        return this.finding.getAssessment();
    }

    @Override
    public String getCategory() {
        return this.finding.getCategoryName();
    }

    @Override
    public String getGroup() {
        return this.finding.getGroupName();
    }

    @Override
    public ElementLocation getLocation() {
        return this.finding.getLocation();
    }

    @Override
    public List<ElementLocation> getSecondaryLocations() {
        return this.finding.getSecondaryLocations();
    }

    @Override
    public String getText() {
        StringBuilder sb = new StringBuilder();
        if (this.isNewFinding()) {
            sb.append("[New] ");
        }
        return sb.append(MarkupUtils.unescapeMarkdownRelevantSymbols((String)this.finding.getMessage())).append("\n").append(this.linkProvider.createFindingsDetailLink(this.finding.getId())).toString();
    }

    @Override
    public String getMarkdownText() {
        StringBuilder sb = new StringBuilder();
        if (this.isNewFinding()) {
            sb.append("**[New]** ");
        }
        return sb.append(SingleFindingReviewComment.escapeUserEchoedFindings(this.finding)).append(" [(view in Teamscale)](").append(this.linkProvider.createFindingsDetailLink(this.finding.getId())).append(")").toString();
    }

    @Override
    public String getTeamscaleCommitDetailUrl() {
        return this.linkProvider.createCommitDetailsLink();
    }

    @Override
    public boolean isKubernetesReviewComment() {
        return this.finding.getTypeId().startsWith("kube-score");
    }

    protected boolean isNewFinding() {
        return FindingUtils.findingWasAddedInCommit(this.finding, this.commentedCommit);
    }

    public static String escapeUserEchoedFindings(TrackedFinding findings) {
        String[] prefixes = new String[]{"Task Tags", "Problem Tags"};
        boolean hasUserEchoedMsg = Arrays.stream(prefixes).anyMatch(findings.getGroupName()::startsWith);
        if (hasUserEchoedMsg && findings.getMessage().contains("@")) {
            return findings.getMessage().replace("@", "\\@");
        }
        return findings.getMessage();
    }
}

