/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.critical_changes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.merge_request.MergeRequestChangedMethod;
import java.io.Serializable;
import java.util.Objects;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public final class MergeRequestCriticalChangeLocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String uniformFilePath;
    private final String methodName;
    private final int methodStartOffset;
    private final int methodEndOffset;

    @JsonCreator
    private MergeRequestCriticalChangeLocation(@JsonProperty(value="uniformFilePath") String uniformFilePath, @JsonProperty(value="methodName") String methodName, @JsonProperty(value="methodStartOffset") int methodStartOffset, @JsonProperty(value="methodEndOffset") int methodEndOffset) {
        this.uniformFilePath = uniformFilePath;
        this.methodName = methodName;
        this.methodStartOffset = methodStartOffset;
        this.methodEndOffset = methodEndOffset;
    }

    @JsonGetter(value="isMethodLocation")
    public boolean isMethodLocation() {
        return this.methodName != null;
    }

    @JsonGetter(value="fullLocationName")
    public String getFullLocationName() {
        if (this.methodName != null) {
            return this.uniformFilePath + "#" + this.methodName + "(\u2026)";
        }
        return this.uniformFilePath;
    }

    public static MergeRequestCriticalChangeLocation forChangedFile(String uniformFilePath) {
        return new MergeRequestCriticalChangeLocation(uniformFilePath, null, -1, -1);
    }

    public static MergeRequestCriticalChangeLocation forChangedMethod(MergeRequestChangedMethod changedMethod) {
        return MergeRequestCriticalChangeLocation.forChangedMethod(changedMethod.location().getUniformPath(), changedMethod.methodName(), changedMethod.location().getRegion().getStart(), changedMethod.location().getRegion().getEnd());
    }

    public static MergeRequestCriticalChangeLocation forChangedMethod(String uniformFilePath, String methodName, int methodStartOffset, int methodEndOffset) {
        return new MergeRequestCriticalChangeLocation(uniformFilePath, methodName, methodStartOffset, methodEndOffset);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MergeRequestCriticalChangeLocation)) {
            return false;
        }
        MergeRequestCriticalChangeLocation that = (MergeRequestCriticalChangeLocation)o;
        return this.methodStartOffset == that.methodStartOffset && this.methodEndOffset == that.methodEndOffset && Objects.equals(this.uniformFilePath, that.uniformFilePath) && Objects.equals(this.methodName, that.methodName);
    }

    public int hashCode() {
        return Objects.hash(this.uniformFilePath, this.methodName, this.methodStartOffset, this.methodEndOffset);
    }

    public String toString() {
        return this.getFullLocationName();
    }
}

