/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.critical_changes;

import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.critical_change.CriticalChangeBadgesConfigurationEntry;
import com.teamscale.index.merge_request.MergeRequestChangedMethod;
import com.teamscale.index.merge_request.critical_changes.MergeRequestCriticalChange;
import com.teamscale.index.merge_request.critical_changes.MergeRequestCriticalChangeInfo;
import com.teamscale.index.merge_request.critical_changes.MergeRequestCriticalChangeLocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class MergeRequestCriticalChangeMatcher {
    private static final String METHOD_NAME_SEPARATOR = "#";
    private final List<CriticalChangeBadgesConfigurationEntry> configuredCriticalBadges;
    private final List<MergeRequestChangedMethod> changedMethods;

    public MergeRequestCriticalChangeMatcher(List<CriticalChangeBadgesConfigurationEntry> configuredCriticalBadges, List<MergeRequestChangedMethod> changedMethods) {
        this.configuredCriticalBadges = configuredCriticalBadges;
        this.changedMethods = changedMethods;
    }

    public MergeRequestCriticalChangeInfo findCriticalChanges() {
        HashSet<MergeRequestCriticalChange> matchedCriticalChanges = new HashSet<MergeRequestCriticalChange>();
        for (CriticalChangeBadgesConfigurationEntry configuredBadge : this.configuredCriticalBadges) {
            List<MergeRequestCriticalChangeLocation> matchedLocations = this.findMatchingMethods(configuredBadge.criticalChangeRegexes());
            matchedLocations.addAll(this.findMatchingFiles(configuredBadge.criticalChangeRegexes()));
            if (matchedLocations.isEmpty()) continue;
            matchedCriticalChanges.add(new MergeRequestCriticalChange(configuredBadge, matchedLocations));
        }
        return new MergeRequestCriticalChangeInfo(matchedCriticalChanges);
    }

    private List<MergeRequestCriticalChangeLocation> findMatchingFiles(List<String> criticalChangeRegexes) {
        IncludeExcludeRegexSupport fileRegexes = new IncludeExcludeRegexSupport(criticalChangeRegexes.stream().filter(regex -> !regex.contains(METHOD_NAME_SEPARATOR)).toList(), Collections.emptyList());
        if (fileRegexes.getIncludePatterns().isEmpty()) {
            return new ArrayList<MergeRequestCriticalChangeLocation>();
        }
        Stream<String> distinctFilePaths = this.changedMethods.stream().map(MergeRequestChangedMethod::getFilePath).distinct();
        return distinctFilePaths.filter(arg_0 -> ((IncludeExcludeRegexSupport)fileRegexes).isIncluded(arg_0)).map(MergeRequestCriticalChangeLocation::forChangedFile).collect(Collectors.toCollection(ArrayList::new));
    }

    private List<MergeRequestCriticalChangeLocation> findMatchingMethods(List<String> criticalChangeRegexes) {
        List<String> methodRegexes = criticalChangeRegexes.stream().filter(regex -> regex.contains(METHOD_NAME_SEPARATOR)).toList();
        if (methodRegexes.isEmpty()) {
            return new ArrayList<MergeRequestCriticalChangeLocation>();
        }
        ArrayList<String> filePathRegexParts = new ArrayList<String>();
        ArrayList<String> methodNameRegexParts = new ArrayList<String>();
        for (String methodRegex : methodRegexes) {
            String[] split = methodRegex.split(METHOD_NAME_SEPARATOR);
            CCSMAssert.isTrue((split.length > 1 ? 1 : 0) != 0, (String)("Cannot happen. We filter for regexes that have the separator. Mismatching regex: " + methodRegex));
            filePathRegexParts.add(split[0]);
            methodNameRegexParts.add(Arrays.stream(split).skip(1L).reduce("", String::concat));
        }
        IncludeExcludeRegexSupport filePathRegexSupport = new IncludeExcludeRegexSupport(filePathRegexParts, Collections.emptyList());
        IncludeExcludeRegexSupport methodNameRegexSupport = new IncludeExcludeRegexSupport(methodNameRegexParts, Collections.emptyList());
        return this.changedMethods.stream().filter(method -> filePathRegexSupport.isIncluded(method.getFilePath()) && methodNameRegexSupport.isIncluded(method.methodName())).map(MergeRequestCriticalChangeLocation::forChangedMethod).collect(Collectors.toCollection(ArrayList::new));
    }
}

