/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.voting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.merge_request.MergeRequestBuildJob;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@IndexValueClass(containedInBackup=true)
public class VotingRecord
implements Serializable {
    private static final long serialVersionUID = -1L;
    private static final long NO_TIMESTAMP_VALUE = -1L;
    @JsonProperty(value="timestamp")
    private long timestamp;
    @JsonProperty(value="state")
    public final EVotingState state;
    @JsonProperty(value="commit")
    public final @Nullable CommitDescriptor commit;
    @JsonProperty(value="comment")
    public final String comment;
    @JsonProperty(value="partitionsIncludedInVote")
    private final @Nullable Map<String, Long> partitionsIncludedInVote;
    @JsonProperty(value="timeToVote")
    private long timeToVote = -1L;
    @JsonProperty(value="relevantBuildJobs")
    private final List<MergeRequestBuildJob> relevantBuildJobs;

    @JsonCreator
    private VotingRecord(@JsonProperty(value="state") EVotingState state, @JsonProperty(value="commit") @Nullable CommitDescriptor commit, @JsonProperty(value="comment") String comment, @JsonProperty(value="partitionsIncludedInVote") @Nullable Map<String, Long> partitionsIncludedInVote, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="relevantBuildJobs") List<MergeRequestBuildJob> relevantBuildJobs) {
        this.state = state;
        this.commit = commit;
        this.comment = comment;
        this.partitionsIncludedInVote = partitionsIncludedInVote;
        this.timestamp = timestamp;
        this.relevantBuildJobs = relevantBuildJobs;
    }

    private VotingRecord(EVotingState state, @Nullable CommitDescriptor commit, String comment, @Nullable Map<String, Long> partitionsIncludedInVote, List<MergeRequestBuildJob> relevantBuildJobs) {
        this(state, commit, comment, partitionsIncludedInVote, System.currentTimeMillis(), relevantBuildJobs);
    }

    public EVotingState getState() {
        return this.state;
    }

    public Optional<Long> getTimestamp() {
        if (this.timestamp == -1L) {
            return Optional.empty();
        }
        return Optional.of(this.timestamp);
    }

    public String getComment() {
        return this.comment;
    }

    public Map<String, Long> getPartitionsIncludedInVote() {
        if (this.partitionsIncludedInVote == null) {
            return Collections.emptyMap();
        }
        return this.partitionsIncludedInVote;
    }

    public List<MergeRequestBuildJob> getRelevantBuildJobs() {
        return this.relevantBuildJobs;
    }

    public Optional<Long> getTimeToVoteInSeconds() {
        if (this.timeToVote == -1L) {
            return Optional.empty();
        }
        return Optional.of(TimeUnit.MILLISECONDS.toSeconds(this.timeToVote));
    }

    public void setTimeToVote(@Nullable Long timeToVote) {
        this.timeToVote = Objects.requireNonNullElse(timeToVote, -1L);
    }

    public void setTimestamp(@Nullable Long timestamp) {
        this.timestamp = Objects.requireNonNullElse(timestamp, -1L);
    }

    public String toString() {
        return "VotingRecord{timestamp=" + this.timestamp + ", state=" + String.valueOf((Object)this.state) + ", comment='" + this.comment + "', voted on partitions=" + String.valueOf(this.partitionsIncludedInVote) + ", relevant build jobs=" + String.valueOf(this.relevantBuildJobs) + "}";
    }

    @VisibleForTesting
    public static VotingRecord successful(EVotingState state, CommitDescriptor commit, String comment, PairList<String, Long> partitionsIncludedInVote, List<MergeRequestBuildJob> relevantBuildJobs) {
        if (partitionsIncludedInVote != null) {
            return new VotingRecord(state, commit, comment, partitionsIncludedInVote.toMap(), relevantBuildJobs);
        }
        return new VotingRecord(state, commit, comment, null, relevantBuildJobs);
    }

    static VotingRecord error(CommitDescriptor commit, String comment) {
        return new VotingRecord(EVotingState.ERROR, commit, comment, Collections.emptyMap(), Collections.emptyList());
    }

    public static VotingRecord skipped(CommitDescriptor commit, String comment) {
        return new VotingRecord(EVotingState.SKIPPED, commit, comment, Collections.emptyMap(), Collections.emptyList());
    }

    public static VotingRecord unvoted() {
        return new VotingRecord(EVotingState.UNVOTED, null, "Teamscale has not yet voted.", Collections.emptyMap(), -1L, Collections.emptyList());
    }

    @ExportToTypeScript
    @IndexValueClass(containedInBackup=true)
    public static enum EVotingState {
        VOTED(true),
        SKIPPED(false),
        ERROR(false),
        VOTED_POSITIVE(true),
        VOTED_NEGATIVE(true),
        UNVOTED(false),
        VOTED_INCOMPLETE_BUILD(false),
        COMMENTED(true),
        VOTING_DISABLED(true);

        private final boolean isSuccessfulAndComplete;

        private EVotingState(boolean isSuccessfulAndComplete) {
            this.isSuccessfulAndComplete = isSuccessfulAndComplete;
        }

        public boolean isSuccessfulAndComplete() {
            return this.isSuccessfulAndComplete;
        }
    }
}

