/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.migration.JsonMigrator;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.index.configuration.AnalysisProfileMigrationUtils;
import com.teamscale.index.migration.finding.ConfigurationOptionReplacement;
import java.util.List;
import java.util.Set;

public class ConditionalStatementsSwiftMigrator {
    private static final String OLD_CHECK_ID = "cqse-conditional-statements-equal";
    private static final String NEW_CHECK_ID = "cqse-conditional-statements-equal-swift";
    private static final String OLD_CHECK_OPTION = "Statements in Conditional Expression are equal: Use character equality.";
    private static final String NEW_CHECK_OPTION = "Statements in Conditional Expression are equal (Swift): Use character equality.";
    private static final String ANALYSIS_GROUP = "Possible Bugs";

    public static String migrate(String json) throws MigrationException {
        Set<String> languages = AnalysisProfileMigrationUtils.getLanguagesInUseJson(json);
        if (!languages.contains("SWIFT")) {
            return json;
        }
        Set<String> otherLanguages = Set.of("JAVA", "CS", "CPP", "C", "OPEN_CL", "JAVASCRIPT", "XTEND", "GROOVY", "GOSU", "KOTLIN", "OBJECTIVE_C", "OBJECTIVE_CPP");
        boolean onlySwift = languages.stream().noneMatch(otherLanguages::contains);
        ConfigurationOptionReplacement replaceCheckID = new ConfigurationOptionReplacement(OLD_CHECK_ID, ANALYSIS_GROUP, NEW_CHECK_ID, ANALYSIS_GROUP, onlySwift);
        ConfigurationOptionReplacement replaceCheckOption = new ConfigurationOptionReplacement(OLD_CHECK_OPTION, ANALYSIS_GROUP, NEW_CHECK_OPTION, ANALYSIS_GROUP, onlySwift);
        List<ConfigurationOptionReplacement> migrations = List.of(replaceCheckID, replaceCheckOption);
        return new JsonMigrator(migrations).migrate(json);
    }
}

