/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.mail.MailUtils;
import com.teamscale.core.mail.SmtpServerOptions;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogFileChurn;
import com.teamscale.index.repository.RepositoryLogFileChurnIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.user.UserAliasLookup;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;

public class NotificationContext
implements IStorageInfo {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IndexLayer indexLayer;
    private final CommitResolvingStorageSystem projectStorageSystem;
    private final GlobalStorageSystem globalStorageSystem;
    private final MailUtils mailUtils;
    private final UserGroupIndex userGroupIndex;
    private final RepositoryLogIndex repositoryLogIndex;
    private final RepositoryLogFileChurnIndex repositoryLogFileChurnIndex;
    private final CommitDescriptor commit;
    private final InternalProjectId internalId;
    private final List<PublicProjectId> publicIds;
    private final String projectReadableName;
    private final RepositoryLogEntryAggregate logEntry;
    private final RepositoryLogFileChurn fileChurn;
    private final MetricSchemaRetrieverFactory schemaRetrieverFactory;
    private final String commitUserName;

    private NotificationContext(RepositoryLogEntryAggregate logEntry, JobDescriptor jobDescriptor, IndexLayer indexLayer, MailUtils mailUtils) throws StorageException {
        CCSMAssert.isNotNull((Object)jobDescriptor, (String)"Should not be scheduled without a job descriptor.");
        CCSMAssert.isNotNull((Object)logEntry, (String)"Log entry must not be null.");
        this.logEntry = logEntry;
        this.mailUtils = mailUtils;
        this.indexLayer = indexLayer;
        this.globalStorageSystem = indexLayer.openGlobalStorageSystem();
        this.projectStorageSystem = indexLayer.openProjectStorageSystem((IProjectId)jobDescriptor.getInternalProjectId());
        this.userGroupIndex = (UserGroupIndex)this.globalStorageSystem.openGlobalIndex(UserGroupIndex.class);
        this.repositoryLogIndex = (RepositoryLogIndex)this.projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null);
        this.commit = jobDescriptor.getSchedulingCommit();
        CCSMAssert.isNotNull((Object)this.commit, (String)"Should not be scheduled without valid commit!");
        logEntry = (RepositoryLogEntryAggregate)this.repositoryLogIndex.getEntry(this.commit);
        if (logEntry == null) {
            throw new StorageException("Could not retrieve log entry at commit " + String.valueOf(this.commit) + ".");
        }
        this.repositoryLogFileChurnIndex = (RepositoryLogFileChurnIndex)this.projectStorageSystem.openProjectIndex(RepositoryLogFileChurnIndex.class, null);
        this.fileChurn = (RepositoryLogFileChurn)this.repositoryLogFileChurnIndex.getEntry(this.commit);
        this.commitUserName = UserAliasLookup.createInstance(this.globalStorageSystem).resolveAuthorOf(logEntry).map(User::getUsername).orElse(logEntry.getAuthor());
        this.internalId = jobDescriptor.getInternalProjectId();
        this.publicIds = ((ProjectIndex)this.globalStorageSystem.openGlobalIndex(ProjectIndex.class)).resolveProject((IProjectId)this.internalId).getPublicIds();
        ProjectIndex projectIndex = (ProjectIndex)this.getGlobalStorageSystem().openGlobalIndex(ProjectIndex.class);
        ProjectInfo projectInfo = projectIndex.resolveProject((IProjectId)this.getInternalId());
        this.projectReadableName = projectInfo.getName();
        this.schemaRetrieverFactory = new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.projectStorageSystem);
    }

    public static NotificationContext createNotificationContext(JobDescriptor jobDescriptor, IndexLayer indexLayer) throws StorageException {
        CommitDescriptor schedulingCommit;
        GlobalStorageSystem globalStorageSystem = indexLayer.openGlobalStorageSystem();
        SmtpServerOptions mailOptions = MailUtils.getMailOptions((GlobalStorageSystem)globalStorageSystem);
        if (mailOptions == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)mailOptions.host)) {
            return null;
        }
        RepositoryLogIndex repositoryLogIndex = (RepositoryLogIndex)indexLayer.openProjectStorageSystem((IProjectId)jobDescriptor.getInternalProjectId()).openProjectIndex(RepositoryLogIndex.class, null);
        RepositoryLogEntryAggregate logEntry = (RepositoryLogEntryAggregate)repositoryLogIndex.getEntry(schedulingCommit = jobDescriptor.getSchedulingCommit());
        if (logEntry == null) {
            LOGGER.warn("Could not retrieve log entry for commit " + String.valueOf(schedulingCommit) + ". No notifications will be sent.");
            return null;
        }
        return new NotificationContext(logEntry, jobDescriptor, indexLayer, new MailUtils(mailOptions));
    }

    public IndexLayer getIndexLayer() {
        return this.indexLayer;
    }

    public CommitResolvingStorageSystem getProjectStorageSystem() {
        return this.projectStorageSystem;
    }

    public GlobalStorageSystem getGlobalStorageSystem() {
        return this.globalStorageSystem;
    }

    public MailUtils getMailUtils() {
        return this.mailUtils;
    }

    public UserGroupIndex getUserGroupIndex() {
        return this.userGroupIndex;
    }

    public RepositoryLogEntryAggregate getRepositoryLogEntry() {
        return this.logEntry;
    }

    public RepositoryLogFileChurn getRepositoryLogFileChurn() {
        if (this.fileChurn == null) {
            return new RepositoryLogFileChurn(this.commit, 0, 0, 0, 0, 0);
        }
        return this.fileChurn;
    }

    public CommitDescriptor getCommit() {
        return this.commit;
    }

    public InternalProjectId getInternalId() {
        return this.internalId;
    }

    public PublicProjectId getPrimaryPublicId() {
        return this.publicIds.get(0);
    }

    public List<PublicProjectId> getPublicIds() {
        return this.publicIds;
    }

    public String getProjectReadableName() {
        return this.projectReadableName;
    }

    public String getCommitUserName() {
        return this.commitUserName;
    }

    public RepositoryLogIndex getRepositoryLogIndex() {
        return this.repositoryLogIndex;
    }

    public MetricSchemaRetrieverFactory getSchemaRetrieverFactory() {
        return this.schemaRetrieverFactory;
    }
}

