/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report.retrospective;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.quality_report.QualityArtifactDescriptor;
import com.teamscale.index.quality_report.QualityArtifactMetaInfo;
import com.teamscale.index.quality_report.QualityArtifactProfile;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class Retrospective
extends QualityArtifactDescriptor {
    private static final long serialVersionUID = 1L;
    private static final String REPORT_ID_PROPERTY = "reportId";
    private static final String PROPERTY_ADDITIONAL_PROJECTS = "additionalProjects";
    @JsonIgnore
    private final Map<PublicProjectId, String> notes = new HashMap<PublicProjectId, String>();
    @JsonProperty(value="reportId")
    private @Nullable String reportId;
    @JsonProperty(value="additionalProjects")
    private final List<ProjectBranchPath> additionalProjects = new ArrayList<ProjectBranchPath>();

    @JsonCreator
    public Retrospective(@JsonProperty(value="metaInfo") QualityArtifactMetaInfo metaInfo, @JsonProperty(value="qualityArtifactProfile") QualityArtifactProfile qualityArtifactProfile, @JsonProperty(value="additionalProjects") List<ProjectBranchPath> additionalProjects, @JsonProperty(value="reportId") @Nullable String reportId) {
        this(metaInfo, qualityArtifactProfile, additionalProjects, Collections.emptyMap(), reportId);
    }

    public Retrospective(QualityArtifactMetaInfo metaInfo, QualityArtifactProfile qualityArtifactProfile, List<ProjectBranchPath> additionalProjects, Map<PublicProjectId, String> notes, @Nullable String reportId) {
        super(metaInfo, qualityArtifactProfile);
        this.reportId = reportId;
        this.notes.putAll(notes);
        this.additionalProjects.addAll(additionalProjects);
    }

    public @Nullable String getReportId() {
        return this.reportId;
    }

    public void setReportId(@Nullable String reportId) {
        this.reportId = reportId;
    }

    public List<PublicProjectId> getReferencedProjects() {
        ArrayList<PublicProjectId> referencedProjects = new ArrayList<PublicProjectId>();
        referencedProjects.add(this.getQualityArtifactProfile().getDefaultProjectSetting().getProjectId());
        for (ProjectBranchPath additionalProject : this.additionalProjects) {
            referencedProjects.add(additionalProject.getProjectId());
        }
        return referencedProjects;
    }

    public Map<PublicProjectId, String> getNotes() {
        return Collections.unmodifiableMap(this.notes);
    }

    public void setNote(PublicProjectId projectId, String notes) {
        this.notes.put(projectId, notes);
    }

    public int hashCode() {
        return Objects.hash(this.getQualityArtifactProfile(), this.getMetaInfo(), this.notes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Retrospective other = (Retrospective)obj;
        return Objects.equals(this.getMetaInfo(), other.getMetaInfo()) && Objects.equals(this.getQualityArtifactProfile(), other.getQualityArtifactProfile()) && Objects.equals(this.notes, other.notes);
    }
}

